/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.billing.lineitemgroups;

import com.chrt.api.core.ChrtApiApiException;
import com.chrt.api.core.ChrtApiException;
import com.chrt.api.core.ChrtApiHttpResponse;
import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.MediaTypes;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.core.QueryStringMapper;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.errors.UnprocessableEntityError;
import com.chrt.api.resources.billing.lineitemgroups.requests.AdjustLineItemReq;
import com.chrt.api.resources.billing.lineitemgroups.requests.LineItemGroupsAssociateWithStatementV1Request;
import com.chrt.api.resources.billing.lineitemgroups.requests.LineItemGroupsListForCourierOrgV1Request;
import com.chrt.api.types.HttpValidationError;
import com.chrt.api.types.LineItemGroup1;
import com.chrt.api.types.LineItemGroupListRes;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

public class AsyncRawLineItemGroupsClient {
    protected final ClientOptions clientOptions;

    public AsyncRawLineItemGroupsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public CompletableFuture<ChrtApiHttpResponse<LineItemGroup1>> getV1(String lineItemGroupId) {
        return this.getV1(lineItemGroupId, null);
    }

    public CompletableFuture<ChrtApiHttpResponse<LineItemGroup1>> getV1(String lineItemGroupId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("billing/line_item_groups/v1").addPathSegment(lineItemGroupId).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<ChrtApiHttpResponse<LineItemGroup1>> future = new CompletableFuture<ChrtApiHttpResponse<LineItemGroup1>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            /*
             * Loose catch block
             */
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try {
                    String responseBodyString;
                    ResponseBody responseBody;
                    block13: {
                        block14: {
                            block11: {
                                block12: {
                                    responseBody = response.body();
                                    String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
                                    if (!response.isSuccessful()) break block11;
                                    future.complete(new ChrtApiHttpResponse<LineItemGroup1>((LineItemGroup1)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, LineItemGroup1.class), response));
                                    if (responseBody == null) break block12;
                                    responseBody.close();
                                }
                                return;
                            }
                            if (response.code() != 422) break block13;
                            future.completeExceptionally(new UnprocessableEntityError((HttpValidationError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class), response));
                            if (responseBody == null) break block14;
                            responseBody.close();
                        }
                        return;
                    }
                    try {
                        block15: {
                            break block15;
                            catch (JsonProcessingException jsonProcessingException) {
                                // empty catch block
                            }
                        }
                        future.completeExceptionally(new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                        return;
                    }
                    finally {
                        if (responseBody != null) {
                            responseBody.close();
                        }
                    }
                }
                catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<ChrtApiHttpResponse<LineItemGroupListRes>> listForCourierOrgV1() {
        return this.listForCourierOrgV1(LineItemGroupsListForCourierOrgV1Request.builder().build());
    }

    public CompletableFuture<ChrtApiHttpResponse<LineItemGroupListRes>> listForCourierOrgV1(LineItemGroupsListForCourierOrgV1Request request) {
        return this.listForCourierOrgV1(request, null);
    }

    public CompletableFuture<ChrtApiHttpResponse<LineItemGroupListRes>> listForCourierOrgV1(LineItemGroupsListForCourierOrgV1Request request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("billing/line_item_groups/list/for_courier_org/v1");
        if (request.getFilterDriverId().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_driver_id", request.getFilterDriverId().get(), false);
        }
        if (request.getFilterAttachedToStatement().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_attached_to_statement", request.getFilterAttachedToStatement().get(), false);
        }
        if (request.getFilterPaymentRole().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_payment_role", request.getFilterPaymentRole().get(), false);
        }
        if (request.getPage().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "page", request.getPage().get(), false);
        }
        if (request.getPageSize().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "page_size", request.getPageSize().get(), false);
        }
        if (request.getFilterStatus().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_status", request.getFilterStatus().get(), true);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<ChrtApiHttpResponse<LineItemGroupListRes>> future = new CompletableFuture<ChrtApiHttpResponse<LineItemGroupListRes>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            /*
             * Loose catch block
             */
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try {
                    String responseBodyString;
                    ResponseBody responseBody;
                    block13: {
                        block14: {
                            block11: {
                                block12: {
                                    responseBody = response.body();
                                    String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
                                    if (!response.isSuccessful()) break block11;
                                    future.complete(new ChrtApiHttpResponse<LineItemGroupListRes>((LineItemGroupListRes)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, LineItemGroupListRes.class), response));
                                    if (responseBody == null) break block12;
                                    responseBody.close();
                                }
                                return;
                            }
                            if (response.code() != 422) break block13;
                            future.completeExceptionally(new UnprocessableEntityError((HttpValidationError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class), response));
                            if (responseBody == null) break block14;
                            responseBody.close();
                        }
                        return;
                    }
                    try {
                        block15: {
                            break block15;
                            catch (JsonProcessingException jsonProcessingException) {
                                // empty catch block
                            }
                        }
                        future.completeExceptionally(new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                        return;
                    }
                    finally {
                        if (responseBody != null) {
                            responseBody.close();
                        }
                    }
                }
                catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<ChrtApiHttpResponse<LineItemGroup1>> finalizeV1(String lineItemGroupId) {
        return this.finalizeV1(lineItemGroupId, null);
    }

    public CompletableFuture<ChrtApiHttpResponse<LineItemGroup1>> finalizeV1(String lineItemGroupId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("billing/line_item_groups/finalize/v1").addPathSegment(lineItemGroupId).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", RequestBody.create((String)"", null)).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<ChrtApiHttpResponse<LineItemGroup1>> future = new CompletableFuture<ChrtApiHttpResponse<LineItemGroup1>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            /*
             * Loose catch block
             */
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try {
                    String responseBodyString;
                    ResponseBody responseBody;
                    block13: {
                        block14: {
                            block11: {
                                block12: {
                                    responseBody = response.body();
                                    String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
                                    if (!response.isSuccessful()) break block11;
                                    future.complete(new ChrtApiHttpResponse<LineItemGroup1>((LineItemGroup1)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, LineItemGroup1.class), response));
                                    if (responseBody == null) break block12;
                                    responseBody.close();
                                }
                                return;
                            }
                            if (response.code() != 422) break block13;
                            future.completeExceptionally(new UnprocessableEntityError((HttpValidationError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class), response));
                            if (responseBody == null) break block14;
                            responseBody.close();
                        }
                        return;
                    }
                    try {
                        block15: {
                            break block15;
                            catch (JsonProcessingException jsonProcessingException) {
                                // empty catch block
                            }
                        }
                        future.completeExceptionally(new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                        return;
                    }
                    finally {
                        if (responseBody != null) {
                            responseBody.close();
                        }
                    }
                }
                catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<ChrtApiHttpResponse<LineItemGroup1>> calculateLineItemsV1(String lineItemGroupId) {
        return this.calculateLineItemsV1(lineItemGroupId, null);
    }

    public CompletableFuture<ChrtApiHttpResponse<LineItemGroup1>> calculateLineItemsV1(String lineItemGroupId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("billing/line_item_groups/calculate_line_items/v1").addPathSegment(lineItemGroupId).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", RequestBody.create((String)"", null)).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<ChrtApiHttpResponse<LineItemGroup1>> future = new CompletableFuture<ChrtApiHttpResponse<LineItemGroup1>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            /*
             * Loose catch block
             */
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try {
                    String responseBodyString;
                    ResponseBody responseBody;
                    block13: {
                        block14: {
                            block11: {
                                block12: {
                                    responseBody = response.body();
                                    String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
                                    if (!response.isSuccessful()) break block11;
                                    future.complete(new ChrtApiHttpResponse<LineItemGroup1>((LineItemGroup1)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, LineItemGroup1.class), response));
                                    if (responseBody == null) break block12;
                                    responseBody.close();
                                }
                                return;
                            }
                            if (response.code() != 422) break block13;
                            future.completeExceptionally(new UnprocessableEntityError((HttpValidationError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class), response));
                            if (responseBody == null) break block14;
                            responseBody.close();
                        }
                        return;
                    }
                    try {
                        block15: {
                            break block15;
                            catch (JsonProcessingException jsonProcessingException) {
                                // empty catch block
                            }
                        }
                        future.completeExceptionally(new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                        return;
                    }
                    finally {
                        if (responseBody != null) {
                            responseBody.close();
                        }
                    }
                }
                catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<ChrtApiHttpResponse<LineItemGroup1>> associateWithStatementV1(String lineItemGroupId, LineItemGroupsAssociateWithStatementV1Request request) {
        return this.associateWithStatementV1(lineItemGroupId, request, null);
    }

    public CompletableFuture<ChrtApiHttpResponse<LineItemGroup1>> associateWithStatementV1(String lineItemGroupId, LineItemGroupsAssociateWithStatementV1Request request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("billing/line_item_groups/associate_with_statement/v1").addPathSegment(lineItemGroupId);
        QueryStringMapper.addQueryParameter(httpUrl, "statement_id", request.getStatementId(), false);
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("POST", RequestBody.create((String)"", null)).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<ChrtApiHttpResponse<LineItemGroup1>> future = new CompletableFuture<ChrtApiHttpResponse<LineItemGroup1>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            /*
             * Loose catch block
             */
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try {
                    String responseBodyString;
                    ResponseBody responseBody;
                    block13: {
                        block14: {
                            block11: {
                                block12: {
                                    responseBody = response.body();
                                    String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
                                    if (!response.isSuccessful()) break block11;
                                    future.complete(new ChrtApiHttpResponse<LineItemGroup1>((LineItemGroup1)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, LineItemGroup1.class), response));
                                    if (responseBody == null) break block12;
                                    responseBody.close();
                                }
                                return;
                            }
                            if (response.code() != 422) break block13;
                            future.completeExceptionally(new UnprocessableEntityError((HttpValidationError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class), response));
                            if (responseBody == null) break block14;
                            responseBody.close();
                        }
                        return;
                    }
                    try {
                        block15: {
                            break block15;
                            catch (JsonProcessingException jsonProcessingException) {
                                // empty catch block
                            }
                        }
                        future.completeExceptionally(new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                        return;
                    }
                    finally {
                        if (responseBody != null) {
                            responseBody.close();
                        }
                    }
                }
                catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<ChrtApiHttpResponse<LineItemGroup1>> adjustLineItemV1(String lineItemGroupId, AdjustLineItemReq request) {
        return this.adjustLineItemV1(lineItemGroupId, request, null);
    }

    public CompletableFuture<ChrtApiHttpResponse<LineItemGroup1>> adjustLineItemV1(String lineItemGroupId, AdjustLineItemReq request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("billing/line_item_groups/adjust_line_item/v1").addPathSegment(lineItemGroupId).build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new ChrtApiException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("PATCH", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<ChrtApiHttpResponse<LineItemGroup1>> future = new CompletableFuture<ChrtApiHttpResponse<LineItemGroup1>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            /*
             * Loose catch block
             */
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try {
                    String responseBodyString;
                    ResponseBody responseBody;
                    block13: {
                        block14: {
                            block11: {
                                block12: {
                                    responseBody = response.body();
                                    String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
                                    if (!response.isSuccessful()) break block11;
                                    future.complete(new ChrtApiHttpResponse<LineItemGroup1>((LineItemGroup1)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, LineItemGroup1.class), response));
                                    if (responseBody == null) break block12;
                                    responseBody.close();
                                }
                                return;
                            }
                            if (response.code() != 422) break block13;
                            future.completeExceptionally(new UnprocessableEntityError((HttpValidationError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class), response));
                            if (responseBody == null) break block14;
                            responseBody.close();
                        }
                        return;
                    }
                    try {
                        block15: {
                            break block15;
                            catch (JsonProcessingException jsonProcessingException) {
                                // empty catch block
                            }
                        }
                        future.completeExceptionally(new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                        return;
                    }
                    finally {
                        if (responseBody != null) {
                            responseBody.close();
                        }
                    }
                }
                catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }
}

