/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.billing.lineitemgroups;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.core.Suppliers;
import com.chrt.api.resources.billing.lineitemgroups.RawLineItemGroupsClient;
import com.chrt.api.resources.billing.lineitemgroups.adhoc.AdHocClient;
import com.chrt.api.resources.billing.lineitemgroups.messages.MessagesClient;
import com.chrt.api.resources.billing.lineitemgroups.requests.AdjustLineItemReq;
import com.chrt.api.resources.billing.lineitemgroups.requests.LineItemGroupsAssociateWithStatementV1Request;
import com.chrt.api.resources.billing.lineitemgroups.requests.LineItemGroupsListForCourierOrgV1Request;
import com.chrt.api.resources.billing.lineitemgroups.s3objects.S3ObjectsClient;
import com.chrt.api.types.LineItemGroup1;
import com.chrt.api.types.LineItemGroupListRes;
import java.util.function.Supplier;

public class LineItemGroupsClient {
    protected final ClientOptions clientOptions;
    private final RawLineItemGroupsClient rawClient;
    protected final Supplier<AdHocClient> adHocClient;
    protected final Supplier<MessagesClient> messagesClient;
    protected final Supplier<S3ObjectsClient> s3ObjectsClient;

    public LineItemGroupsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawLineItemGroupsClient(clientOptions);
        this.adHocClient = Suppliers.memoize(() -> new AdHocClient(clientOptions));
        this.messagesClient = Suppliers.memoize(() -> new MessagesClient(clientOptions));
        this.s3ObjectsClient = Suppliers.memoize(() -> new S3ObjectsClient(clientOptions));
    }

    public RawLineItemGroupsClient withRawResponse() {
        return this.rawClient;
    }

    public LineItemGroup1 getV1(String lineItemGroupId) {
        return this.rawClient.getV1(lineItemGroupId).body();
    }

    public LineItemGroup1 getV1(String lineItemGroupId, RequestOptions requestOptions) {
        return this.rawClient.getV1(lineItemGroupId, requestOptions).body();
    }

    public LineItemGroupListRes listForCourierOrgV1() {
        return this.rawClient.listForCourierOrgV1().body();
    }

    public LineItemGroupListRes listForCourierOrgV1(LineItemGroupsListForCourierOrgV1Request request) {
        return this.rawClient.listForCourierOrgV1(request).body();
    }

    public LineItemGroupListRes listForCourierOrgV1(LineItemGroupsListForCourierOrgV1Request request, RequestOptions requestOptions) {
        return this.rawClient.listForCourierOrgV1(request, requestOptions).body();
    }

    public LineItemGroup1 finalizeV1(String lineItemGroupId) {
        return this.rawClient.finalizeV1(lineItemGroupId).body();
    }

    public LineItemGroup1 finalizeV1(String lineItemGroupId, RequestOptions requestOptions) {
        return this.rawClient.finalizeV1(lineItemGroupId, requestOptions).body();
    }

    public LineItemGroup1 calculateLineItemsV1(String lineItemGroupId) {
        return this.rawClient.calculateLineItemsV1(lineItemGroupId).body();
    }

    public LineItemGroup1 calculateLineItemsV1(String lineItemGroupId, RequestOptions requestOptions) {
        return this.rawClient.calculateLineItemsV1(lineItemGroupId, requestOptions).body();
    }

    public LineItemGroup1 associateWithStatementV1(String lineItemGroupId, LineItemGroupsAssociateWithStatementV1Request request) {
        return this.rawClient.associateWithStatementV1(lineItemGroupId, request).body();
    }

    public LineItemGroup1 associateWithStatementV1(String lineItemGroupId, LineItemGroupsAssociateWithStatementV1Request request, RequestOptions requestOptions) {
        return this.rawClient.associateWithStatementV1(lineItemGroupId, request, requestOptions).body();
    }

    public LineItemGroup1 adjustLineItemV1(String lineItemGroupId, AdjustLineItemReq request) {
        return this.rawClient.adjustLineItemV1(lineItemGroupId, request).body();
    }

    public LineItemGroup1 adjustLineItemV1(String lineItemGroupId, AdjustLineItemReq request, RequestOptions requestOptions) {
        return this.rawClient.adjustLineItemV1(lineItemGroupId, request, requestOptions).body();
    }

    public AdHocClient adHoc() {
        return this.adHocClient.get();
    }

    public MessagesClient messages() {
        return this.messagesClient.get();
    }

    public S3ObjectsClient s3Objects() {
        return this.s3ObjectsClient.get();
    }
}

