/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.billing.lineitemgroups.adhoc;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.billing.lineitemgroups.adhoc.AsyncRawAdHocClient;
import com.chrt.api.resources.billing.lineitemgroups.adhoc.requests.AdHocRemoveLineItemV1Request;
import com.chrt.api.resources.billing.lineitemgroups.adhoc.requests.CreateAdHocLineItemGroupReq;
import com.chrt.api.resources.billing.lineitemgroups.adhoc.requests.LineItemClientCreate1;
import com.chrt.api.types.LineItemGroup1;
import java.util.concurrent.CompletableFuture;

public class AsyncAdHocClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawAdHocClient rawClient;

    public AsyncAdHocClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawAdHocClient(clientOptions);
    }

    public AsyncRawAdHocClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<LineItemGroup1> createV1(CreateAdHocLineItemGroupReq request) {
        return this.rawClient.createV1(request).thenApply(response -> (LineItemGroup1)response.body());
    }

    public CompletableFuture<LineItemGroup1> createV1(CreateAdHocLineItemGroupReq request, RequestOptions requestOptions) {
        return this.rawClient.createV1(request, requestOptions).thenApply(response -> (LineItemGroup1)response.body());
    }

    public CompletableFuture<LineItemGroup1> addLineItemV1(String lineItemGroupId, LineItemClientCreate1 request) {
        return this.rawClient.addLineItemV1(lineItemGroupId, request).thenApply(response -> (LineItemGroup1)response.body());
    }

    public CompletableFuture<LineItemGroup1> addLineItemV1(String lineItemGroupId, LineItemClientCreate1 request, RequestOptions requestOptions) {
        return this.rawClient.addLineItemV1(lineItemGroupId, request, requestOptions).thenApply(response -> (LineItemGroup1)response.body());
    }

    public CompletableFuture<LineItemGroup1> removeLineItemV1(String lineItemGroupId, AdHocRemoveLineItemV1Request request) {
        return this.rawClient.removeLineItemV1(lineItemGroupId, request).thenApply(response -> (LineItemGroup1)response.body());
    }

    public CompletableFuture<LineItemGroup1> removeLineItemV1(String lineItemGroupId, AdHocRemoveLineItemV1Request request, RequestOptions requestOptions) {
        return this.rawClient.removeLineItemV1(lineItemGroupId, request, requestOptions).thenApply(response -> (LineItemGroup1)response.body());
    }

    public CompletableFuture<Boolean> deleteV1(String lineItemGroupId) {
        return this.rawClient.deleteV1(lineItemGroupId).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> deleteV1(String lineItemGroupId, RequestOptions requestOptions) {
        return this.rawClient.deleteV1(lineItemGroupId, requestOptions).thenApply(response -> (Boolean)response.body());
    }
}

