/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.billing.lineitemgroups.adhoc.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.PaymentVectorTypeEnum1;
import com.chrt.api.types.SettlementTypeEnum1;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateAdHocLineItemGroupReq {
    private final PaymentVectorTypeEnum1 paymentVectorType;
    private final SettlementTypeEnum1 settlementType;
    private final Optional<String> paymentOriginOrgId;
    private final Optional<String> paymentOriginOffChrtShipperOrgId;
    private final Optional<String> paymentDestinationOrgId;
    private final Optional<String> paymentDestinationDriverId;
    private final Map<String, Object> additionalProperties;

    private CreateAdHocLineItemGroupReq(PaymentVectorTypeEnum1 paymentVectorType, SettlementTypeEnum1 settlementType, Optional<String> paymentOriginOrgId, Optional<String> paymentOriginOffChrtShipperOrgId, Optional<String> paymentDestinationOrgId, Optional<String> paymentDestinationDriverId, Map<String, Object> additionalProperties) {
        this.paymentVectorType = paymentVectorType;
        this.settlementType = settlementType;
        this.paymentOriginOrgId = paymentOriginOrgId;
        this.paymentOriginOffChrtShipperOrgId = paymentOriginOffChrtShipperOrgId;
        this.paymentDestinationOrgId = paymentDestinationOrgId;
        this.paymentDestinationDriverId = paymentDestinationDriverId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="payment_vector_type")
    public PaymentVectorTypeEnum1 getPaymentVectorType() {
        return this.paymentVectorType;
    }

    @JsonProperty(value="settlement_type")
    public SettlementTypeEnum1 getSettlementType() {
        return this.settlementType;
    }

    @JsonIgnore
    public Optional<String> getPaymentOriginOrgId() {
        if (this.paymentOriginOrgId == null) {
            return Optional.empty();
        }
        return this.paymentOriginOrgId;
    }

    @JsonIgnore
    public Optional<String> getPaymentOriginOffChrtShipperOrgId() {
        if (this.paymentOriginOffChrtShipperOrgId == null) {
            return Optional.empty();
        }
        return this.paymentOriginOffChrtShipperOrgId;
    }

    @JsonIgnore
    public Optional<String> getPaymentDestinationOrgId() {
        if (this.paymentDestinationOrgId == null) {
            return Optional.empty();
        }
        return this.paymentDestinationOrgId;
    }

    @JsonIgnore
    public Optional<String> getPaymentDestinationDriverId() {
        if (this.paymentDestinationDriverId == null) {
            return Optional.empty();
        }
        return this.paymentDestinationDriverId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="payment_origin_org_id")
    private Optional<String> _getPaymentOriginOrgId() {
        return this.paymentOriginOrgId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="payment_origin_off_chrt_shipper_org_id")
    private Optional<String> _getPaymentOriginOffChrtShipperOrgId() {
        return this.paymentOriginOffChrtShipperOrgId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="payment_destination_org_id")
    private Optional<String> _getPaymentDestinationOrgId() {
        return this.paymentDestinationOrgId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="payment_destination_driver_id")
    private Optional<String> _getPaymentDestinationDriverId() {
        return this.paymentDestinationDriverId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateAdHocLineItemGroupReq && this.equalTo((CreateAdHocLineItemGroupReq)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateAdHocLineItemGroupReq other) {
        return this.paymentVectorType.equals(other.paymentVectorType) && this.settlementType.equals(other.settlementType) && this.paymentOriginOrgId.equals(other.paymentOriginOrgId) && this.paymentOriginOffChrtShipperOrgId.equals(other.paymentOriginOffChrtShipperOrgId) && this.paymentDestinationOrgId.equals(other.paymentDestinationOrgId) && this.paymentDestinationDriverId.equals(other.paymentDestinationDriverId);
    }

    public int hashCode() {
        return Objects.hash(this.paymentVectorType, this.settlementType, this.paymentOriginOrgId, this.paymentOriginOffChrtShipperOrgId, this.paymentDestinationOrgId, this.paymentDestinationDriverId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PaymentVectorTypeStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements PaymentVectorTypeStage,
    SettlementTypeStage,
    _FinalStage {
        private PaymentVectorTypeEnum1 paymentVectorType;
        private SettlementTypeEnum1 settlementType;
        private Optional<String> paymentDestinationDriverId = Optional.empty();
        private Optional<String> paymentDestinationOrgId = Optional.empty();
        private Optional<String> paymentOriginOffChrtShipperOrgId = Optional.empty();
        private Optional<String> paymentOriginOrgId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateAdHocLineItemGroupReq other) {
            this.paymentVectorType(other.getPaymentVectorType());
            this.settlementType(other.getSettlementType());
            this.paymentOriginOrgId(other.getPaymentOriginOrgId());
            this.paymentOriginOffChrtShipperOrgId(other.getPaymentOriginOffChrtShipperOrgId());
            this.paymentDestinationOrgId(other.getPaymentDestinationOrgId());
            this.paymentDestinationDriverId(other.getPaymentDestinationDriverId());
            return this;
        }

        @Override
        @JsonSetter(value="payment_vector_type")
        public SettlementTypeStage paymentVectorType(@NotNull PaymentVectorTypeEnum1 paymentVectorType) {
            this.paymentVectorType = Objects.requireNonNull(paymentVectorType, "paymentVectorType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="settlement_type")
        public _FinalStage settlementType(@NotNull SettlementTypeEnum1 settlementType) {
            this.settlementType = Objects.requireNonNull(settlementType, "settlementType must not be null");
            return this;
        }

        @Override
        public _FinalStage paymentDestinationDriverId(Nullable<String> paymentDestinationDriverId) {
            this.paymentDestinationDriverId = paymentDestinationDriverId.isNull() ? null : (paymentDestinationDriverId.isEmpty() ? Optional.empty() : Optional.of(paymentDestinationDriverId.get()));
            return this;
        }

        @Override
        public _FinalStage paymentDestinationDriverId(String paymentDestinationDriverId) {
            this.paymentDestinationDriverId = Optional.ofNullable(paymentDestinationDriverId);
            return this;
        }

        @Override
        @JsonSetter(value="payment_destination_driver_id", nulls=Nulls.SKIP)
        public _FinalStage paymentDestinationDriverId(Optional<String> paymentDestinationDriverId) {
            this.paymentDestinationDriverId = paymentDestinationDriverId;
            return this;
        }

        @Override
        public _FinalStage paymentDestinationOrgId(Nullable<String> paymentDestinationOrgId) {
            this.paymentDestinationOrgId = paymentDestinationOrgId.isNull() ? null : (paymentDestinationOrgId.isEmpty() ? Optional.empty() : Optional.of(paymentDestinationOrgId.get()));
            return this;
        }

        @Override
        public _FinalStage paymentDestinationOrgId(String paymentDestinationOrgId) {
            this.paymentDestinationOrgId = Optional.ofNullable(paymentDestinationOrgId);
            return this;
        }

        @Override
        @JsonSetter(value="payment_destination_org_id", nulls=Nulls.SKIP)
        public _FinalStage paymentDestinationOrgId(Optional<String> paymentDestinationOrgId) {
            this.paymentDestinationOrgId = paymentDestinationOrgId;
            return this;
        }

        @Override
        public _FinalStage paymentOriginOffChrtShipperOrgId(Nullable<String> paymentOriginOffChrtShipperOrgId) {
            this.paymentOriginOffChrtShipperOrgId = paymentOriginOffChrtShipperOrgId.isNull() ? null : (paymentOriginOffChrtShipperOrgId.isEmpty() ? Optional.empty() : Optional.of(paymentOriginOffChrtShipperOrgId.get()));
            return this;
        }

        @Override
        public _FinalStage paymentOriginOffChrtShipperOrgId(String paymentOriginOffChrtShipperOrgId) {
            this.paymentOriginOffChrtShipperOrgId = Optional.ofNullable(paymentOriginOffChrtShipperOrgId);
            return this;
        }

        @Override
        @JsonSetter(value="payment_origin_off_chrt_shipper_org_id", nulls=Nulls.SKIP)
        public _FinalStage paymentOriginOffChrtShipperOrgId(Optional<String> paymentOriginOffChrtShipperOrgId) {
            this.paymentOriginOffChrtShipperOrgId = paymentOriginOffChrtShipperOrgId;
            return this;
        }

        @Override
        public _FinalStage paymentOriginOrgId(Nullable<String> paymentOriginOrgId) {
            this.paymentOriginOrgId = paymentOriginOrgId.isNull() ? null : (paymentOriginOrgId.isEmpty() ? Optional.empty() : Optional.of(paymentOriginOrgId.get()));
            return this;
        }

        @Override
        public _FinalStage paymentOriginOrgId(String paymentOriginOrgId) {
            this.paymentOriginOrgId = Optional.ofNullable(paymentOriginOrgId);
            return this;
        }

        @Override
        @JsonSetter(value="payment_origin_org_id", nulls=Nulls.SKIP)
        public _FinalStage paymentOriginOrgId(Optional<String> paymentOriginOrgId) {
            this.paymentOriginOrgId = paymentOriginOrgId;
            return this;
        }

        @Override
        public CreateAdHocLineItemGroupReq build() {
            return new CreateAdHocLineItemGroupReq(this.paymentVectorType, this.settlementType, this.paymentOriginOrgId, this.paymentOriginOffChrtShipperOrgId, this.paymentDestinationOrgId, this.paymentDestinationDriverId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateAdHocLineItemGroupReq build();

        public _FinalStage paymentOriginOrgId(Optional<String> var1);

        public _FinalStage paymentOriginOrgId(String var1);

        public _FinalStage paymentOriginOrgId(Nullable<String> var1);

        public _FinalStage paymentOriginOffChrtShipperOrgId(Optional<String> var1);

        public _FinalStage paymentOriginOffChrtShipperOrgId(String var1);

        public _FinalStage paymentOriginOffChrtShipperOrgId(Nullable<String> var1);

        public _FinalStage paymentDestinationOrgId(Optional<String> var1);

        public _FinalStage paymentDestinationOrgId(String var1);

        public _FinalStage paymentDestinationOrgId(Nullable<String> var1);

        public _FinalStage paymentDestinationDriverId(Optional<String> var1);

        public _FinalStage paymentDestinationDriverId(String var1);

        public _FinalStage paymentDestinationDriverId(Nullable<String> var1);
    }

    public static interface SettlementTypeStage {
        public _FinalStage settlementType(@NotNull SettlementTypeEnum1 var1);
    }

    public static interface PaymentVectorTypeStage {
        public SettlementTypeStage paymentVectorType(@NotNull PaymentVectorTypeEnum1 var1);

        public Builder from(CreateAdHocLineItemGroupReq var1);
    }
}

