/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.billing.lineitemgroups.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class AdjustLineItemReq {
    private final String lineItemUuidStr;
    private final double adjustment;
    private final Optional<String> adjustmentComments;
    private final Map<String, Object> additionalProperties;

    private AdjustLineItemReq(String lineItemUuidStr, double adjustment, Optional<String> adjustmentComments, Map<String, Object> additionalProperties) {
        this.lineItemUuidStr = lineItemUuidStr;
        this.adjustment = adjustment;
        this.adjustmentComments = adjustmentComments;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="line_item_uuid_str")
    public String getLineItemUuidStr() {
        return this.lineItemUuidStr;
    }

    @JsonProperty(value="adjustment")
    public double getAdjustment() {
        return this.adjustment;
    }

    @JsonIgnore
    public Optional<String> getAdjustmentComments() {
        if (this.adjustmentComments == null) {
            return Optional.empty();
        }
        return this.adjustmentComments;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="adjustment_comments")
    private Optional<String> _getAdjustmentComments() {
        return this.adjustmentComments;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AdjustLineItemReq && this.equalTo((AdjustLineItemReq)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AdjustLineItemReq other) {
        return this.lineItemUuidStr.equals(other.lineItemUuidStr) && this.adjustment == other.adjustment && this.adjustmentComments.equals(other.adjustmentComments);
    }

    public int hashCode() {
        return Objects.hash(this.lineItemUuidStr, this.adjustment, this.adjustmentComments);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static LineItemUuidStrStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements LineItemUuidStrStage,
    AdjustmentStage,
    _FinalStage {
        private String lineItemUuidStr;
        private double adjustment;
        private Optional<String> adjustmentComments = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(AdjustLineItemReq other) {
            this.lineItemUuidStr(other.getLineItemUuidStr());
            this.adjustment(other.getAdjustment());
            this.adjustmentComments(other.getAdjustmentComments());
            return this;
        }

        @Override
        @JsonSetter(value="line_item_uuid_str")
        public AdjustmentStage lineItemUuidStr(@NotNull String lineItemUuidStr) {
            this.lineItemUuidStr = Objects.requireNonNull(lineItemUuidStr, "lineItemUuidStr must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="adjustment")
        public _FinalStage adjustment(double adjustment) {
            this.adjustment = adjustment;
            return this;
        }

        @Override
        public _FinalStage adjustmentComments(Nullable<String> adjustmentComments) {
            this.adjustmentComments = adjustmentComments.isNull() ? null : (adjustmentComments.isEmpty() ? Optional.empty() : Optional.of(adjustmentComments.get()));
            return this;
        }

        @Override
        public _FinalStage adjustmentComments(String adjustmentComments) {
            this.adjustmentComments = Optional.ofNullable(adjustmentComments);
            return this;
        }

        @Override
        @JsonSetter(value="adjustment_comments", nulls=Nulls.SKIP)
        public _FinalStage adjustmentComments(Optional<String> adjustmentComments) {
            this.adjustmentComments = adjustmentComments;
            return this;
        }

        @Override
        public AdjustLineItemReq build() {
            return new AdjustLineItemReq(this.lineItemUuidStr, this.adjustment, this.adjustmentComments, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public AdjustLineItemReq build();

        public _FinalStage adjustmentComments(Optional<String> var1);

        public _FinalStage adjustmentComments(String var1);

        public _FinalStage adjustmentComments(Nullable<String> var1);
    }

    public static interface AdjustmentStage {
        public _FinalStage adjustment(double var1);
    }

    public static interface LineItemUuidStrStage {
        public AdjustmentStage lineItemUuidStr(@NotNull String var1);

        public Builder from(AdjustLineItemReq var1);
    }
}

