/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.billing.lineitemgroups.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.LineItemGroupStatusEnum1;
import com.chrt.api.types.PaymentRoleFilterEnum;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class LineItemGroupsListForCourierOrgV1Request {
    private final Optional<List<LineItemGroupStatusEnum1>> filterStatus;
    private final Optional<String> filterDriverId;
    private final Optional<Boolean> filterAttachedToStatement;
    private final Optional<PaymentRoleFilterEnum> filterPaymentRole;
    private final Optional<Integer> page;
    private final Optional<Integer> pageSize;
    private final Map<String, Object> additionalProperties;

    private LineItemGroupsListForCourierOrgV1Request(Optional<List<LineItemGroupStatusEnum1>> filterStatus, Optional<String> filterDriverId, Optional<Boolean> filterAttachedToStatement, Optional<PaymentRoleFilterEnum> filterPaymentRole, Optional<Integer> page, Optional<Integer> pageSize, Map<String, Object> additionalProperties) {
        this.filterStatus = filterStatus;
        this.filterDriverId = filterDriverId;
        this.filterAttachedToStatement = filterAttachedToStatement;
        this.filterPaymentRole = filterPaymentRole;
        this.page = page;
        this.pageSize = pageSize;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<List<LineItemGroupStatusEnum1>> getFilterStatus() {
        if (this.filterStatus == null) {
            return Optional.empty();
        }
        return this.filterStatus;
    }

    @JsonIgnore
    public Optional<String> getFilterDriverId() {
        if (this.filterDriverId == null) {
            return Optional.empty();
        }
        return this.filterDriverId;
    }

    @JsonIgnore
    public Optional<Boolean> getFilterAttachedToStatement() {
        if (this.filterAttachedToStatement == null) {
            return Optional.empty();
        }
        return this.filterAttachedToStatement;
    }

    @JsonIgnore
    public Optional<PaymentRoleFilterEnum> getFilterPaymentRole() {
        if (this.filterPaymentRole == null) {
            return Optional.empty();
        }
        return this.filterPaymentRole;
    }

    @JsonIgnore
    public Optional<Integer> getPage() {
        if (this.page == null) {
            return Optional.empty();
        }
        return this.page;
    }

    @JsonIgnore
    public Optional<Integer> getPageSize() {
        if (this.pageSize == null) {
            return Optional.empty();
        }
        return this.pageSize;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="filter_status")
    private Optional<List<LineItemGroupStatusEnum1>> _getFilterStatus() {
        return this.filterStatus;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="filter_driver_id")
    private Optional<String> _getFilterDriverId() {
        return this.filterDriverId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="filter_attached_to_statement")
    private Optional<Boolean> _getFilterAttachedToStatement() {
        return this.filterAttachedToStatement;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="filter_payment_role")
    private Optional<PaymentRoleFilterEnum> _getFilterPaymentRole() {
        return this.filterPaymentRole;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="page")
    private Optional<Integer> _getPage() {
        return this.page;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="page_size")
    private Optional<Integer> _getPageSize() {
        return this.pageSize;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LineItemGroupsListForCourierOrgV1Request && this.equalTo((LineItemGroupsListForCourierOrgV1Request)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LineItemGroupsListForCourierOrgV1Request other) {
        return this.filterStatus.equals(other.filterStatus) && this.filterDriverId.equals(other.filterDriverId) && this.filterAttachedToStatement.equals(other.filterAttachedToStatement) && this.filterPaymentRole.equals(other.filterPaymentRole) && this.page.equals(other.page) && this.pageSize.equals(other.pageSize);
    }

    public int hashCode() {
        return Objects.hash(this.filterStatus, this.filterDriverId, this.filterAttachedToStatement, this.filterPaymentRole, this.page, this.pageSize);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<LineItemGroupStatusEnum1>> filterStatus = Optional.empty();
        private Optional<String> filterDriverId = Optional.empty();
        private Optional<Boolean> filterAttachedToStatement = Optional.empty();
        private Optional<PaymentRoleFilterEnum> filterPaymentRole = Optional.empty();
        private Optional<Integer> page = Optional.empty();
        private Optional<Integer> pageSize = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(LineItemGroupsListForCourierOrgV1Request other) {
            this.filterStatus(other.getFilterStatus());
            this.filterDriverId(other.getFilterDriverId());
            this.filterAttachedToStatement(other.getFilterAttachedToStatement());
            this.filterPaymentRole(other.getFilterPaymentRole());
            this.page(other.getPage());
            this.pageSize(other.getPageSize());
            return this;
        }

        @JsonSetter(value="filter_status", nulls=Nulls.SKIP)
        public Builder filterStatus(Optional<List<LineItemGroupStatusEnum1>> filterStatus) {
            this.filterStatus = filterStatus;
            return this;
        }

        public Builder filterStatus(List<LineItemGroupStatusEnum1> filterStatus) {
            this.filterStatus = Optional.ofNullable(filterStatus);
            return this;
        }

        public Builder filterStatus(Nullable<List<LineItemGroupStatusEnum1>> filterStatus) {
            this.filterStatus = filterStatus.isNull() ? null : (filterStatus.isEmpty() ? Optional.empty() : Optional.of(filterStatus.get()));
            return this;
        }

        public Builder filterStatus(LineItemGroupStatusEnum1 filterStatus) {
            this.filterStatus = Optional.of(Collections.singletonList(filterStatus));
            return this;
        }

        @JsonSetter(value="filter_driver_id", nulls=Nulls.SKIP)
        public Builder filterDriverId(Optional<String> filterDriverId) {
            this.filterDriverId = filterDriverId;
            return this;
        }

        public Builder filterDriverId(String filterDriverId) {
            this.filterDriverId = Optional.ofNullable(filterDriverId);
            return this;
        }

        public Builder filterDriverId(Nullable<String> filterDriverId) {
            this.filterDriverId = filterDriverId.isNull() ? null : (filterDriverId.isEmpty() ? Optional.empty() : Optional.of(filterDriverId.get()));
            return this;
        }

        @JsonSetter(value="filter_attached_to_statement", nulls=Nulls.SKIP)
        public Builder filterAttachedToStatement(Optional<Boolean> filterAttachedToStatement) {
            this.filterAttachedToStatement = filterAttachedToStatement;
            return this;
        }

        public Builder filterAttachedToStatement(Boolean filterAttachedToStatement) {
            this.filterAttachedToStatement = Optional.ofNullable(filterAttachedToStatement);
            return this;
        }

        public Builder filterAttachedToStatement(Nullable<Boolean> filterAttachedToStatement) {
            this.filterAttachedToStatement = filterAttachedToStatement.isNull() ? null : (filterAttachedToStatement.isEmpty() ? Optional.empty() : Optional.of(filterAttachedToStatement.get()));
            return this;
        }

        @JsonSetter(value="filter_payment_role", nulls=Nulls.SKIP)
        public Builder filterPaymentRole(Optional<PaymentRoleFilterEnum> filterPaymentRole) {
            this.filterPaymentRole = filterPaymentRole;
            return this;
        }

        public Builder filterPaymentRole(PaymentRoleFilterEnum filterPaymentRole) {
            this.filterPaymentRole = Optional.ofNullable(filterPaymentRole);
            return this;
        }

        public Builder filterPaymentRole(Nullable<PaymentRoleFilterEnum> filterPaymentRole) {
            this.filterPaymentRole = filterPaymentRole.isNull() ? null : (filterPaymentRole.isEmpty() ? Optional.empty() : Optional.of(filterPaymentRole.get()));
            return this;
        }

        @JsonSetter(value="page", nulls=Nulls.SKIP)
        public Builder page(Optional<Integer> page) {
            this.page = page;
            return this;
        }

        public Builder page(Integer page) {
            this.page = Optional.ofNullable(page);
            return this;
        }

        public Builder page(Nullable<Integer> page) {
            this.page = page.isNull() ? null : (page.isEmpty() ? Optional.empty() : Optional.of(page.get()));
            return this;
        }

        @JsonSetter(value="page_size", nulls=Nulls.SKIP)
        public Builder pageSize(Optional<Integer> pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.pageSize = Optional.ofNullable(pageSize);
            return this;
        }

        public Builder pageSize(Nullable<Integer> pageSize) {
            this.pageSize = pageSize.isNull() ? null : (pageSize.isEmpty() ? Optional.empty() : Optional.of(pageSize.get()));
            return this;
        }

        public LineItemGroupsListForCourierOrgV1Request build() {
            return new LineItemGroupsListForCourierOrgV1Request(this.filterStatus, this.filterDriverId, this.filterAttachedToStatement, this.filterPaymentRole, this.page, this.pageSize, this.additionalProperties);
        }
    }
}

