/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.billing.ratesheets;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.billing.ratesheets.AsyncRawRateSheetsClient;
import com.chrt.api.resources.billing.ratesheets.requests.RateSheetClientCreate1;
import com.chrt.api.resources.billing.ratesheets.requests.RateSheetClientUpdate1;
import com.chrt.api.resources.billing.ratesheets.requests.RateSheetsArchiveV1Request;
import com.chrt.api.resources.billing.ratesheets.requests.RateSheetsListByOrgV1Request;
import com.chrt.api.resources.billing.ratesheets.requests.RateSheetsUpdateDefaultForConnectionV1Request;
import com.chrt.api.resources.billing.ratesheets.requests.RateSheetsUpdateDefaultForDriverV1Request;
import com.chrt.api.resources.billing.ratesheets.requests.RateSheetsUpdateOrgDefaultForServiceTypeV1Request;
import com.chrt.api.types.RateSheet1;
import com.chrt.api.types.RateSheetListResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncRateSheetsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawRateSheetsClient rawClient;

    public AsyncRateSheetsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawRateSheetsClient(clientOptions);
    }

    public AsyncRawRateSheetsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<RateSheet1> getV1(String rateSheetId) {
        return this.rawClient.getV1(rateSheetId).thenApply(response -> (RateSheet1)response.body());
    }

    public CompletableFuture<RateSheet1> getV1(String rateSheetId, RequestOptions requestOptions) {
        return this.rawClient.getV1(rateSheetId, requestOptions).thenApply(response -> (RateSheet1)response.body());
    }

    public CompletableFuture<RateSheet1> updateV1(String rateSheetId) {
        return this.rawClient.updateV1(rateSheetId).thenApply(response -> (RateSheet1)response.body());
    }

    public CompletableFuture<RateSheet1> updateV1(String rateSheetId, RateSheetClientUpdate1 request) {
        return this.rawClient.updateV1(rateSheetId, request).thenApply(response -> (RateSheet1)response.body());
    }

    public CompletableFuture<RateSheet1> updateV1(String rateSheetId, RateSheetClientUpdate1 request, RequestOptions requestOptions) {
        return this.rawClient.updateV1(rateSheetId, request, requestOptions).thenApply(response -> (RateSheet1)response.body());
    }

    public CompletableFuture<RateSheetListResponse> listByOrgV1() {
        return this.rawClient.listByOrgV1().thenApply(response -> (RateSheetListResponse)response.body());
    }

    public CompletableFuture<RateSheetListResponse> listByOrgV1(RateSheetsListByOrgV1Request request) {
        return this.rawClient.listByOrgV1(request).thenApply(response -> (RateSheetListResponse)response.body());
    }

    public CompletableFuture<RateSheetListResponse> listByOrgV1(RateSheetsListByOrgV1Request request, RequestOptions requestOptions) {
        return this.rawClient.listByOrgV1(request, requestOptions).thenApply(response -> (RateSheetListResponse)response.body());
    }

    public CompletableFuture<String> createV1(RateSheetClientCreate1 request) {
        return this.rawClient.createV1(request).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<String> createV1(RateSheetClientCreate1 request, RequestOptions requestOptions) {
        return this.rawClient.createV1(request, requestOptions).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<Boolean> archiveV1(String rateSheetId, RateSheetsArchiveV1Request request) {
        return this.rawClient.archiveV1(rateSheetId, request).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> archiveV1(String rateSheetId, RateSheetsArchiveV1Request request, RequestOptions requestOptions) {
        return this.rawClient.archiveV1(rateSheetId, request, requestOptions).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> updateOrgDefaultForServiceTypeV1(RateSheetsUpdateOrgDefaultForServiceTypeV1Request request) {
        return this.rawClient.updateOrgDefaultForServiceTypeV1(request).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> updateOrgDefaultForServiceTypeV1(RateSheetsUpdateOrgDefaultForServiceTypeV1Request request, RequestOptions requestOptions) {
        return this.rawClient.updateOrgDefaultForServiceTypeV1(request, requestOptions).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> updateDefaultForConnectionV1(RateSheetsUpdateDefaultForConnectionV1Request request) {
        return this.rawClient.updateDefaultForConnectionV1(request).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> updateDefaultForConnectionV1(RateSheetsUpdateDefaultForConnectionV1Request request, RequestOptions requestOptions) {
        return this.rawClient.updateDefaultForConnectionV1(request, requestOptions).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> updateDefaultForDriverV1(RateSheetsUpdateDefaultForDriverV1Request request) {
        return this.rawClient.updateDefaultForDriverV1(request).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> updateDefaultForDriverV1(RateSheetsUpdateDefaultForDriverV1Request request, RequestOptions requestOptions) {
        return this.rawClient.updateDefaultForDriverV1(request, requestOptions).thenApply(response -> (Boolean)response.body());
    }
}

