/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.billing.ratesheets.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.CargoTypeEnum1;
import com.chrt.api.types.PaymentVectorTypeEnum1;
import com.chrt.api.types.ServiceTypeEnum1;
import com.chrt.api.types.VehicleTypeEnum;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class RateSheetClientCreate1 {
    private final PaymentVectorTypeEnum1 paymentVectorType;
    private final int schemaVersion;
    private final Optional<Boolean> archived;
    private final Optional<String> name;
    private final Optional<String> comments;
    private final Optional<List<CargoTypeEnum1>> cargoTypes;
    private final Optional<List<VehicleTypeEnum>> vehicleTypes;
    private final ServiceTypeEnum1 serviceType;
    private final Optional<Double> baseMileageDistanceMiles;
    private final Optional<Double> baseMileageRateUsdPerInstance;
    private final Optional<Double> additionalMileageRateUsdPerMile;
    private final Optional<Double> longDistanceSurchargeMilesBeforeSurcharge;
    private final Optional<Double> longDistanceSurchargeRateUsdPerMile;
    private final Optional<Double> fuelSurchargeRateUsdPerMile;
    private final Optional<Double> waitTimeBeforeChargeMinutes;
    private final Optional<Double> waitTimeRateUsdPerMinute;
    private final Optional<Double> extraStopRateUsd;
    private final Optional<Double> dangerousGoodsRateUsdPerInstance;
    private final Optional<Double> afterHoursRateUsdPerInstance;
    private final Optional<Double> weekendRateUsdPerInstance;
    private final Optional<Double> holidayRateUsdPerInstance;
    private final Map<String, Object> additionalProperties;

    private RateSheetClientCreate1(PaymentVectorTypeEnum1 paymentVectorType, int schemaVersion, Optional<Boolean> archived, Optional<String> name, Optional<String> comments, Optional<List<CargoTypeEnum1>> cargoTypes, Optional<List<VehicleTypeEnum>> vehicleTypes, ServiceTypeEnum1 serviceType, Optional<Double> baseMileageDistanceMiles, Optional<Double> baseMileageRateUsdPerInstance, Optional<Double> additionalMileageRateUsdPerMile, Optional<Double> longDistanceSurchargeMilesBeforeSurcharge, Optional<Double> longDistanceSurchargeRateUsdPerMile, Optional<Double> fuelSurchargeRateUsdPerMile, Optional<Double> waitTimeBeforeChargeMinutes, Optional<Double> waitTimeRateUsdPerMinute, Optional<Double> extraStopRateUsd, Optional<Double> dangerousGoodsRateUsdPerInstance, Optional<Double> afterHoursRateUsdPerInstance, Optional<Double> weekendRateUsdPerInstance, Optional<Double> holidayRateUsdPerInstance, Map<String, Object> additionalProperties) {
        this.paymentVectorType = paymentVectorType;
        this.schemaVersion = schemaVersion;
        this.archived = archived;
        this.name = name;
        this.comments = comments;
        this.cargoTypes = cargoTypes;
        this.vehicleTypes = vehicleTypes;
        this.serviceType = serviceType;
        this.baseMileageDistanceMiles = baseMileageDistanceMiles;
        this.baseMileageRateUsdPerInstance = baseMileageRateUsdPerInstance;
        this.additionalMileageRateUsdPerMile = additionalMileageRateUsdPerMile;
        this.longDistanceSurchargeMilesBeforeSurcharge = longDistanceSurchargeMilesBeforeSurcharge;
        this.longDistanceSurchargeRateUsdPerMile = longDistanceSurchargeRateUsdPerMile;
        this.fuelSurchargeRateUsdPerMile = fuelSurchargeRateUsdPerMile;
        this.waitTimeBeforeChargeMinutes = waitTimeBeforeChargeMinutes;
        this.waitTimeRateUsdPerMinute = waitTimeRateUsdPerMinute;
        this.extraStopRateUsd = extraStopRateUsd;
        this.dangerousGoodsRateUsdPerInstance = dangerousGoodsRateUsdPerInstance;
        this.afterHoursRateUsdPerInstance = afterHoursRateUsdPerInstance;
        this.weekendRateUsdPerInstance = weekendRateUsdPerInstance;
        this.holidayRateUsdPerInstance = holidayRateUsdPerInstance;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="payment_vector_type")
    public PaymentVectorTypeEnum1 getPaymentVectorType() {
        return this.paymentVectorType;
    }

    @JsonProperty(value="schema_version")
    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    @JsonProperty(value="archived")
    public Optional<Boolean> getArchived() {
        return this.archived;
    }

    @JsonIgnore
    public Optional<String> getName() {
        if (this.name == null) {
            return Optional.empty();
        }
        return this.name;
    }

    @JsonIgnore
    public Optional<String> getComments() {
        if (this.comments == null) {
            return Optional.empty();
        }
        return this.comments;
    }

    @JsonProperty(value="cargo_types")
    public Optional<List<CargoTypeEnum1>> getCargoTypes() {
        return this.cargoTypes;
    }

    @JsonProperty(value="vehicle_types")
    public Optional<List<VehicleTypeEnum>> getVehicleTypes() {
        return this.vehicleTypes;
    }

    @JsonProperty(value="service_type")
    public ServiceTypeEnum1 getServiceType() {
        return this.serviceType;
    }

    @JsonIgnore
    public Optional<Double> getBaseMileageDistanceMiles() {
        if (this.baseMileageDistanceMiles == null) {
            return Optional.empty();
        }
        return this.baseMileageDistanceMiles;
    }

    @JsonIgnore
    public Optional<Double> getBaseMileageRateUsdPerInstance() {
        if (this.baseMileageRateUsdPerInstance == null) {
            return Optional.empty();
        }
        return this.baseMileageRateUsdPerInstance;
    }

    @JsonIgnore
    public Optional<Double> getAdditionalMileageRateUsdPerMile() {
        if (this.additionalMileageRateUsdPerMile == null) {
            return Optional.empty();
        }
        return this.additionalMileageRateUsdPerMile;
    }

    @JsonIgnore
    public Optional<Double> getLongDistanceSurchargeMilesBeforeSurcharge() {
        if (this.longDistanceSurchargeMilesBeforeSurcharge == null) {
            return Optional.empty();
        }
        return this.longDistanceSurchargeMilesBeforeSurcharge;
    }

    @JsonIgnore
    public Optional<Double> getLongDistanceSurchargeRateUsdPerMile() {
        if (this.longDistanceSurchargeRateUsdPerMile == null) {
            return Optional.empty();
        }
        return this.longDistanceSurchargeRateUsdPerMile;
    }

    @JsonIgnore
    public Optional<Double> getFuelSurchargeRateUsdPerMile() {
        if (this.fuelSurchargeRateUsdPerMile == null) {
            return Optional.empty();
        }
        return this.fuelSurchargeRateUsdPerMile;
    }

    @JsonIgnore
    public Optional<Double> getWaitTimeBeforeChargeMinutes() {
        if (this.waitTimeBeforeChargeMinutes == null) {
            return Optional.empty();
        }
        return this.waitTimeBeforeChargeMinutes;
    }

    @JsonIgnore
    public Optional<Double> getWaitTimeRateUsdPerMinute() {
        if (this.waitTimeRateUsdPerMinute == null) {
            return Optional.empty();
        }
        return this.waitTimeRateUsdPerMinute;
    }

    @JsonIgnore
    public Optional<Double> getExtraStopRateUsd() {
        if (this.extraStopRateUsd == null) {
            return Optional.empty();
        }
        return this.extraStopRateUsd;
    }

    @JsonIgnore
    public Optional<Double> getDangerousGoodsRateUsdPerInstance() {
        if (this.dangerousGoodsRateUsdPerInstance == null) {
            return Optional.empty();
        }
        return this.dangerousGoodsRateUsdPerInstance;
    }

    @JsonIgnore
    public Optional<Double> getAfterHoursRateUsdPerInstance() {
        if (this.afterHoursRateUsdPerInstance == null) {
            return Optional.empty();
        }
        return this.afterHoursRateUsdPerInstance;
    }

    @JsonIgnore
    public Optional<Double> getWeekendRateUsdPerInstance() {
        if (this.weekendRateUsdPerInstance == null) {
            return Optional.empty();
        }
        return this.weekendRateUsdPerInstance;
    }

    @JsonIgnore
    public Optional<Double> getHolidayRateUsdPerInstance() {
        if (this.holidayRateUsdPerInstance == null) {
            return Optional.empty();
        }
        return this.holidayRateUsdPerInstance;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="name")
    private Optional<String> _getName() {
        return this.name;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="comments")
    private Optional<String> _getComments() {
        return this.comments;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="base_mileage_distance_miles")
    private Optional<Double> _getBaseMileageDistanceMiles() {
        return this.baseMileageDistanceMiles;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="base_mileage_rate_usd_per_instance")
    private Optional<Double> _getBaseMileageRateUsdPerInstance() {
        return this.baseMileageRateUsdPerInstance;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="additional_mileage_rate_usd_per_mile")
    private Optional<Double> _getAdditionalMileageRateUsdPerMile() {
        return this.additionalMileageRateUsdPerMile;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="long_distance_surcharge_miles_before_surcharge")
    private Optional<Double> _getLongDistanceSurchargeMilesBeforeSurcharge() {
        return this.longDistanceSurchargeMilesBeforeSurcharge;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="long_distance_surcharge_rate_usd_per_mile")
    private Optional<Double> _getLongDistanceSurchargeRateUsdPerMile() {
        return this.longDistanceSurchargeRateUsdPerMile;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="fuel_surcharge_rate_usd_per_mile")
    private Optional<Double> _getFuelSurchargeRateUsdPerMile() {
        return this.fuelSurchargeRateUsdPerMile;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="wait_time_before_charge_minutes")
    private Optional<Double> _getWaitTimeBeforeChargeMinutes() {
        return this.waitTimeBeforeChargeMinutes;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="wait_time_rate_usd_per_minute")
    private Optional<Double> _getWaitTimeRateUsdPerMinute() {
        return this.waitTimeRateUsdPerMinute;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="extra_stop_rate_usd")
    private Optional<Double> _getExtraStopRateUsd() {
        return this.extraStopRateUsd;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="dangerous_goods_rate_usd_per_instance")
    private Optional<Double> _getDangerousGoodsRateUsdPerInstance() {
        return this.dangerousGoodsRateUsdPerInstance;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="after_hours_rate_usd_per_instance")
    private Optional<Double> _getAfterHoursRateUsdPerInstance() {
        return this.afterHoursRateUsdPerInstance;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="weekend_rate_usd_per_instance")
    private Optional<Double> _getWeekendRateUsdPerInstance() {
        return this.weekendRateUsdPerInstance;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="holiday_rate_usd_per_instance")
    private Optional<Double> _getHolidayRateUsdPerInstance() {
        return this.holidayRateUsdPerInstance;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof RateSheetClientCreate1 && this.equalTo((RateSheetClientCreate1)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(RateSheetClientCreate1 other) {
        return this.paymentVectorType.equals(other.paymentVectorType) && this.schemaVersion == other.schemaVersion && this.archived.equals(other.archived) && this.name.equals(other.name) && this.comments.equals(other.comments) && this.cargoTypes.equals(other.cargoTypes) && this.vehicleTypes.equals(other.vehicleTypes) && this.serviceType.equals(other.serviceType) && this.baseMileageDistanceMiles.equals(other.baseMileageDistanceMiles) && this.baseMileageRateUsdPerInstance.equals(other.baseMileageRateUsdPerInstance) && this.additionalMileageRateUsdPerMile.equals(other.additionalMileageRateUsdPerMile) && this.longDistanceSurchargeMilesBeforeSurcharge.equals(other.longDistanceSurchargeMilesBeforeSurcharge) && this.longDistanceSurchargeRateUsdPerMile.equals(other.longDistanceSurchargeRateUsdPerMile) && this.fuelSurchargeRateUsdPerMile.equals(other.fuelSurchargeRateUsdPerMile) && this.waitTimeBeforeChargeMinutes.equals(other.waitTimeBeforeChargeMinutes) && this.waitTimeRateUsdPerMinute.equals(other.waitTimeRateUsdPerMinute) && this.extraStopRateUsd.equals(other.extraStopRateUsd) && this.dangerousGoodsRateUsdPerInstance.equals(other.dangerousGoodsRateUsdPerInstance) && this.afterHoursRateUsdPerInstance.equals(other.afterHoursRateUsdPerInstance) && this.weekendRateUsdPerInstance.equals(other.weekendRateUsdPerInstance) && this.holidayRateUsdPerInstance.equals(other.holidayRateUsdPerInstance);
    }

    public int hashCode() {
        return Objects.hash(this.paymentVectorType, this.schemaVersion, this.archived, this.name, this.comments, this.cargoTypes, this.vehicleTypes, this.serviceType, this.baseMileageDistanceMiles, this.baseMileageRateUsdPerInstance, this.additionalMileageRateUsdPerMile, this.longDistanceSurchargeMilesBeforeSurcharge, this.longDistanceSurchargeRateUsdPerMile, this.fuelSurchargeRateUsdPerMile, this.waitTimeBeforeChargeMinutes, this.waitTimeRateUsdPerMinute, this.extraStopRateUsd, this.dangerousGoodsRateUsdPerInstance, this.afterHoursRateUsdPerInstance, this.weekendRateUsdPerInstance, this.holidayRateUsdPerInstance);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PaymentVectorTypeStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements PaymentVectorTypeStage,
    SchemaVersionStage,
    ServiceTypeStage,
    _FinalStage {
        private PaymentVectorTypeEnum1 paymentVectorType;
        private int schemaVersion;
        private ServiceTypeEnum1 serviceType;
        private Optional<Double> holidayRateUsdPerInstance = Optional.empty();
        private Optional<Double> weekendRateUsdPerInstance = Optional.empty();
        private Optional<Double> afterHoursRateUsdPerInstance = Optional.empty();
        private Optional<Double> dangerousGoodsRateUsdPerInstance = Optional.empty();
        private Optional<Double> extraStopRateUsd = Optional.empty();
        private Optional<Double> waitTimeRateUsdPerMinute = Optional.empty();
        private Optional<Double> waitTimeBeforeChargeMinutes = Optional.empty();
        private Optional<Double> fuelSurchargeRateUsdPerMile = Optional.empty();
        private Optional<Double> longDistanceSurchargeRateUsdPerMile = Optional.empty();
        private Optional<Double> longDistanceSurchargeMilesBeforeSurcharge = Optional.empty();
        private Optional<Double> additionalMileageRateUsdPerMile = Optional.empty();
        private Optional<Double> baseMileageRateUsdPerInstance = Optional.empty();
        private Optional<Double> baseMileageDistanceMiles = Optional.empty();
        private Optional<List<VehicleTypeEnum>> vehicleTypes = Optional.empty();
        private Optional<List<CargoTypeEnum1>> cargoTypes = Optional.empty();
        private Optional<String> comments = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<Boolean> archived = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(RateSheetClientCreate1 other) {
            this.paymentVectorType(other.getPaymentVectorType());
            this.schemaVersion(other.getSchemaVersion());
            this.archived(other.getArchived());
            this.name(other.getName());
            this.comments(other.getComments());
            this.cargoTypes(other.getCargoTypes());
            this.vehicleTypes(other.getVehicleTypes());
            this.serviceType(other.getServiceType());
            this.baseMileageDistanceMiles(other.getBaseMileageDistanceMiles());
            this.baseMileageRateUsdPerInstance(other.getBaseMileageRateUsdPerInstance());
            this.additionalMileageRateUsdPerMile(other.getAdditionalMileageRateUsdPerMile());
            this.longDistanceSurchargeMilesBeforeSurcharge(other.getLongDistanceSurchargeMilesBeforeSurcharge());
            this.longDistanceSurchargeRateUsdPerMile(other.getLongDistanceSurchargeRateUsdPerMile());
            this.fuelSurchargeRateUsdPerMile(other.getFuelSurchargeRateUsdPerMile());
            this.waitTimeBeforeChargeMinutes(other.getWaitTimeBeforeChargeMinutes());
            this.waitTimeRateUsdPerMinute(other.getWaitTimeRateUsdPerMinute());
            this.extraStopRateUsd(other.getExtraStopRateUsd());
            this.dangerousGoodsRateUsdPerInstance(other.getDangerousGoodsRateUsdPerInstance());
            this.afterHoursRateUsdPerInstance(other.getAfterHoursRateUsdPerInstance());
            this.weekendRateUsdPerInstance(other.getWeekendRateUsdPerInstance());
            this.holidayRateUsdPerInstance(other.getHolidayRateUsdPerInstance());
            return this;
        }

        @Override
        @JsonSetter(value="payment_vector_type")
        public SchemaVersionStage paymentVectorType(@NotNull PaymentVectorTypeEnum1 paymentVectorType) {
            this.paymentVectorType = Objects.requireNonNull(paymentVectorType, "paymentVectorType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="schema_version")
        public ServiceTypeStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @Override
        @JsonSetter(value="service_type")
        public _FinalStage serviceType(@NotNull ServiceTypeEnum1 serviceType) {
            this.serviceType = Objects.requireNonNull(serviceType, "serviceType must not be null");
            return this;
        }

        @Override
        public _FinalStage holidayRateUsdPerInstance(Nullable<Double> holidayRateUsdPerInstance) {
            this.holidayRateUsdPerInstance = holidayRateUsdPerInstance.isNull() ? null : (holidayRateUsdPerInstance.isEmpty() ? Optional.empty() : Optional.of(holidayRateUsdPerInstance.get()));
            return this;
        }

        @Override
        public _FinalStage holidayRateUsdPerInstance(Double holidayRateUsdPerInstance) {
            this.holidayRateUsdPerInstance = Optional.ofNullable(holidayRateUsdPerInstance);
            return this;
        }

        @Override
        @JsonSetter(value="holiday_rate_usd_per_instance", nulls=Nulls.SKIP)
        public _FinalStage holidayRateUsdPerInstance(Optional<Double> holidayRateUsdPerInstance) {
            this.holidayRateUsdPerInstance = holidayRateUsdPerInstance;
            return this;
        }

        @Override
        public _FinalStage weekendRateUsdPerInstance(Nullable<Double> weekendRateUsdPerInstance) {
            this.weekendRateUsdPerInstance = weekendRateUsdPerInstance.isNull() ? null : (weekendRateUsdPerInstance.isEmpty() ? Optional.empty() : Optional.of(weekendRateUsdPerInstance.get()));
            return this;
        }

        @Override
        public _FinalStage weekendRateUsdPerInstance(Double weekendRateUsdPerInstance) {
            this.weekendRateUsdPerInstance = Optional.ofNullable(weekendRateUsdPerInstance);
            return this;
        }

        @Override
        @JsonSetter(value="weekend_rate_usd_per_instance", nulls=Nulls.SKIP)
        public _FinalStage weekendRateUsdPerInstance(Optional<Double> weekendRateUsdPerInstance) {
            this.weekendRateUsdPerInstance = weekendRateUsdPerInstance;
            return this;
        }

        @Override
        public _FinalStage afterHoursRateUsdPerInstance(Nullable<Double> afterHoursRateUsdPerInstance) {
            this.afterHoursRateUsdPerInstance = afterHoursRateUsdPerInstance.isNull() ? null : (afterHoursRateUsdPerInstance.isEmpty() ? Optional.empty() : Optional.of(afterHoursRateUsdPerInstance.get()));
            return this;
        }

        @Override
        public _FinalStage afterHoursRateUsdPerInstance(Double afterHoursRateUsdPerInstance) {
            this.afterHoursRateUsdPerInstance = Optional.ofNullable(afterHoursRateUsdPerInstance);
            return this;
        }

        @Override
        @JsonSetter(value="after_hours_rate_usd_per_instance", nulls=Nulls.SKIP)
        public _FinalStage afterHoursRateUsdPerInstance(Optional<Double> afterHoursRateUsdPerInstance) {
            this.afterHoursRateUsdPerInstance = afterHoursRateUsdPerInstance;
            return this;
        }

        @Override
        public _FinalStage dangerousGoodsRateUsdPerInstance(Nullable<Double> dangerousGoodsRateUsdPerInstance) {
            this.dangerousGoodsRateUsdPerInstance = dangerousGoodsRateUsdPerInstance.isNull() ? null : (dangerousGoodsRateUsdPerInstance.isEmpty() ? Optional.empty() : Optional.of(dangerousGoodsRateUsdPerInstance.get()));
            return this;
        }

        @Override
        public _FinalStage dangerousGoodsRateUsdPerInstance(Double dangerousGoodsRateUsdPerInstance) {
            this.dangerousGoodsRateUsdPerInstance = Optional.ofNullable(dangerousGoodsRateUsdPerInstance);
            return this;
        }

        @Override
        @JsonSetter(value="dangerous_goods_rate_usd_per_instance", nulls=Nulls.SKIP)
        public _FinalStage dangerousGoodsRateUsdPerInstance(Optional<Double> dangerousGoodsRateUsdPerInstance) {
            this.dangerousGoodsRateUsdPerInstance = dangerousGoodsRateUsdPerInstance;
            return this;
        }

        @Override
        public _FinalStage extraStopRateUsd(Nullable<Double> extraStopRateUsd) {
            this.extraStopRateUsd = extraStopRateUsd.isNull() ? null : (extraStopRateUsd.isEmpty() ? Optional.empty() : Optional.of(extraStopRateUsd.get()));
            return this;
        }

        @Override
        public _FinalStage extraStopRateUsd(Double extraStopRateUsd) {
            this.extraStopRateUsd = Optional.ofNullable(extraStopRateUsd);
            return this;
        }

        @Override
        @JsonSetter(value="extra_stop_rate_usd", nulls=Nulls.SKIP)
        public _FinalStage extraStopRateUsd(Optional<Double> extraStopRateUsd) {
            this.extraStopRateUsd = extraStopRateUsd;
            return this;
        }

        @Override
        public _FinalStage waitTimeRateUsdPerMinute(Nullable<Double> waitTimeRateUsdPerMinute) {
            this.waitTimeRateUsdPerMinute = waitTimeRateUsdPerMinute.isNull() ? null : (waitTimeRateUsdPerMinute.isEmpty() ? Optional.empty() : Optional.of(waitTimeRateUsdPerMinute.get()));
            return this;
        }

        @Override
        public _FinalStage waitTimeRateUsdPerMinute(Double waitTimeRateUsdPerMinute) {
            this.waitTimeRateUsdPerMinute = Optional.ofNullable(waitTimeRateUsdPerMinute);
            return this;
        }

        @Override
        @JsonSetter(value="wait_time_rate_usd_per_minute", nulls=Nulls.SKIP)
        public _FinalStage waitTimeRateUsdPerMinute(Optional<Double> waitTimeRateUsdPerMinute) {
            this.waitTimeRateUsdPerMinute = waitTimeRateUsdPerMinute;
            return this;
        }

        @Override
        public _FinalStage waitTimeBeforeChargeMinutes(Nullable<Double> waitTimeBeforeChargeMinutes) {
            this.waitTimeBeforeChargeMinutes = waitTimeBeforeChargeMinutes.isNull() ? null : (waitTimeBeforeChargeMinutes.isEmpty() ? Optional.empty() : Optional.of(waitTimeBeforeChargeMinutes.get()));
            return this;
        }

        @Override
        public _FinalStage waitTimeBeforeChargeMinutes(Double waitTimeBeforeChargeMinutes) {
            this.waitTimeBeforeChargeMinutes = Optional.ofNullable(waitTimeBeforeChargeMinutes);
            return this;
        }

        @Override
        @JsonSetter(value="wait_time_before_charge_minutes", nulls=Nulls.SKIP)
        public _FinalStage waitTimeBeforeChargeMinutes(Optional<Double> waitTimeBeforeChargeMinutes) {
            this.waitTimeBeforeChargeMinutes = waitTimeBeforeChargeMinutes;
            return this;
        }

        @Override
        public _FinalStage fuelSurchargeRateUsdPerMile(Nullable<Double> fuelSurchargeRateUsdPerMile) {
            this.fuelSurchargeRateUsdPerMile = fuelSurchargeRateUsdPerMile.isNull() ? null : (fuelSurchargeRateUsdPerMile.isEmpty() ? Optional.empty() : Optional.of(fuelSurchargeRateUsdPerMile.get()));
            return this;
        }

        @Override
        public _FinalStage fuelSurchargeRateUsdPerMile(Double fuelSurchargeRateUsdPerMile) {
            this.fuelSurchargeRateUsdPerMile = Optional.ofNullable(fuelSurchargeRateUsdPerMile);
            return this;
        }

        @Override
        @JsonSetter(value="fuel_surcharge_rate_usd_per_mile", nulls=Nulls.SKIP)
        public _FinalStage fuelSurchargeRateUsdPerMile(Optional<Double> fuelSurchargeRateUsdPerMile) {
            this.fuelSurchargeRateUsdPerMile = fuelSurchargeRateUsdPerMile;
            return this;
        }

        @Override
        public _FinalStage longDistanceSurchargeRateUsdPerMile(Nullable<Double> longDistanceSurchargeRateUsdPerMile) {
            this.longDistanceSurchargeRateUsdPerMile = longDistanceSurchargeRateUsdPerMile.isNull() ? null : (longDistanceSurchargeRateUsdPerMile.isEmpty() ? Optional.empty() : Optional.of(longDistanceSurchargeRateUsdPerMile.get()));
            return this;
        }

        @Override
        public _FinalStage longDistanceSurchargeRateUsdPerMile(Double longDistanceSurchargeRateUsdPerMile) {
            this.longDistanceSurchargeRateUsdPerMile = Optional.ofNullable(longDistanceSurchargeRateUsdPerMile);
            return this;
        }

        @Override
        @JsonSetter(value="long_distance_surcharge_rate_usd_per_mile", nulls=Nulls.SKIP)
        public _FinalStage longDistanceSurchargeRateUsdPerMile(Optional<Double> longDistanceSurchargeRateUsdPerMile) {
            this.longDistanceSurchargeRateUsdPerMile = longDistanceSurchargeRateUsdPerMile;
            return this;
        }

        @Override
        public _FinalStage longDistanceSurchargeMilesBeforeSurcharge(Nullable<Double> longDistanceSurchargeMilesBeforeSurcharge) {
            this.longDistanceSurchargeMilesBeforeSurcharge = longDistanceSurchargeMilesBeforeSurcharge.isNull() ? null : (longDistanceSurchargeMilesBeforeSurcharge.isEmpty() ? Optional.empty() : Optional.of(longDistanceSurchargeMilesBeforeSurcharge.get()));
            return this;
        }

        @Override
        public _FinalStage longDistanceSurchargeMilesBeforeSurcharge(Double longDistanceSurchargeMilesBeforeSurcharge) {
            this.longDistanceSurchargeMilesBeforeSurcharge = Optional.ofNullable(longDistanceSurchargeMilesBeforeSurcharge);
            return this;
        }

        @Override
        @JsonSetter(value="long_distance_surcharge_miles_before_surcharge", nulls=Nulls.SKIP)
        public _FinalStage longDistanceSurchargeMilesBeforeSurcharge(Optional<Double> longDistanceSurchargeMilesBeforeSurcharge) {
            this.longDistanceSurchargeMilesBeforeSurcharge = longDistanceSurchargeMilesBeforeSurcharge;
            return this;
        }

        @Override
        public _FinalStage additionalMileageRateUsdPerMile(Nullable<Double> additionalMileageRateUsdPerMile) {
            this.additionalMileageRateUsdPerMile = additionalMileageRateUsdPerMile.isNull() ? null : (additionalMileageRateUsdPerMile.isEmpty() ? Optional.empty() : Optional.of(additionalMileageRateUsdPerMile.get()));
            return this;
        }

        @Override
        public _FinalStage additionalMileageRateUsdPerMile(Double additionalMileageRateUsdPerMile) {
            this.additionalMileageRateUsdPerMile = Optional.ofNullable(additionalMileageRateUsdPerMile);
            return this;
        }

        @Override
        @JsonSetter(value="additional_mileage_rate_usd_per_mile", nulls=Nulls.SKIP)
        public _FinalStage additionalMileageRateUsdPerMile(Optional<Double> additionalMileageRateUsdPerMile) {
            this.additionalMileageRateUsdPerMile = additionalMileageRateUsdPerMile;
            return this;
        }

        @Override
        public _FinalStage baseMileageRateUsdPerInstance(Nullable<Double> baseMileageRateUsdPerInstance) {
            this.baseMileageRateUsdPerInstance = baseMileageRateUsdPerInstance.isNull() ? null : (baseMileageRateUsdPerInstance.isEmpty() ? Optional.empty() : Optional.of(baseMileageRateUsdPerInstance.get()));
            return this;
        }

        @Override
        public _FinalStage baseMileageRateUsdPerInstance(Double baseMileageRateUsdPerInstance) {
            this.baseMileageRateUsdPerInstance = Optional.ofNullable(baseMileageRateUsdPerInstance);
            return this;
        }

        @Override
        @JsonSetter(value="base_mileage_rate_usd_per_instance", nulls=Nulls.SKIP)
        public _FinalStage baseMileageRateUsdPerInstance(Optional<Double> baseMileageRateUsdPerInstance) {
            this.baseMileageRateUsdPerInstance = baseMileageRateUsdPerInstance;
            return this;
        }

        @Override
        public _FinalStage baseMileageDistanceMiles(Nullable<Double> baseMileageDistanceMiles) {
            this.baseMileageDistanceMiles = baseMileageDistanceMiles.isNull() ? null : (baseMileageDistanceMiles.isEmpty() ? Optional.empty() : Optional.of(baseMileageDistanceMiles.get()));
            return this;
        }

        @Override
        public _FinalStage baseMileageDistanceMiles(Double baseMileageDistanceMiles) {
            this.baseMileageDistanceMiles = Optional.ofNullable(baseMileageDistanceMiles);
            return this;
        }

        @Override
        @JsonSetter(value="base_mileage_distance_miles", nulls=Nulls.SKIP)
        public _FinalStage baseMileageDistanceMiles(Optional<Double> baseMileageDistanceMiles) {
            this.baseMileageDistanceMiles = baseMileageDistanceMiles;
            return this;
        }

        @Override
        public _FinalStage vehicleTypes(List<VehicleTypeEnum> vehicleTypes) {
            this.vehicleTypes = Optional.ofNullable(vehicleTypes);
            return this;
        }

        @Override
        @JsonSetter(value="vehicle_types", nulls=Nulls.SKIP)
        public _FinalStage vehicleTypes(Optional<List<VehicleTypeEnum>> vehicleTypes) {
            this.vehicleTypes = vehicleTypes;
            return this;
        }

        @Override
        public _FinalStage cargoTypes(List<CargoTypeEnum1> cargoTypes) {
            this.cargoTypes = Optional.ofNullable(cargoTypes);
            return this;
        }

        @Override
        @JsonSetter(value="cargo_types", nulls=Nulls.SKIP)
        public _FinalStage cargoTypes(Optional<List<CargoTypeEnum1>> cargoTypes) {
            this.cargoTypes = cargoTypes;
            return this;
        }

        @Override
        public _FinalStage comments(Nullable<String> comments) {
            this.comments = comments.isNull() ? null : (comments.isEmpty() ? Optional.empty() : Optional.of(comments.get()));
            return this;
        }

        @Override
        public _FinalStage comments(String comments) {
            this.comments = Optional.ofNullable(comments);
            return this;
        }

        @Override
        @JsonSetter(value="comments", nulls=Nulls.SKIP)
        public _FinalStage comments(Optional<String> comments) {
            this.comments = comments;
            return this;
        }

        @Override
        public _FinalStage name(Nullable<String> name) {
            this.name = name.isNull() ? null : (name.isEmpty() ? Optional.empty() : Optional.of(name.get()));
            return this;
        }

        @Override
        public _FinalStage name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @Override
        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public _FinalStage name(Optional<String> name) {
            this.name = name;
            return this;
        }

        @Override
        public _FinalStage archived(Boolean archived) {
            this.archived = Optional.ofNullable(archived);
            return this;
        }

        @Override
        @JsonSetter(value="archived", nulls=Nulls.SKIP)
        public _FinalStage archived(Optional<Boolean> archived) {
            this.archived = archived;
            return this;
        }

        @Override
        public RateSheetClientCreate1 build() {
            return new RateSheetClientCreate1(this.paymentVectorType, this.schemaVersion, this.archived, this.name, this.comments, this.cargoTypes, this.vehicleTypes, this.serviceType, this.baseMileageDistanceMiles, this.baseMileageRateUsdPerInstance, this.additionalMileageRateUsdPerMile, this.longDistanceSurchargeMilesBeforeSurcharge, this.longDistanceSurchargeRateUsdPerMile, this.fuelSurchargeRateUsdPerMile, this.waitTimeBeforeChargeMinutes, this.waitTimeRateUsdPerMinute, this.extraStopRateUsd, this.dangerousGoodsRateUsdPerInstance, this.afterHoursRateUsdPerInstance, this.weekendRateUsdPerInstance, this.holidayRateUsdPerInstance, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public RateSheetClientCreate1 build();

        public _FinalStage archived(Optional<Boolean> var1);

        public _FinalStage archived(Boolean var1);

        public _FinalStage name(Optional<String> var1);

        public _FinalStage name(String var1);

        public _FinalStage name(Nullable<String> var1);

        public _FinalStage comments(Optional<String> var1);

        public _FinalStage comments(String var1);

        public _FinalStage comments(Nullable<String> var1);

        public _FinalStage cargoTypes(Optional<List<CargoTypeEnum1>> var1);

        public _FinalStage cargoTypes(List<CargoTypeEnum1> var1);

        public _FinalStage vehicleTypes(Optional<List<VehicleTypeEnum>> var1);

        public _FinalStage vehicleTypes(List<VehicleTypeEnum> var1);

        public _FinalStage baseMileageDistanceMiles(Optional<Double> var1);

        public _FinalStage baseMileageDistanceMiles(Double var1);

        public _FinalStage baseMileageDistanceMiles(Nullable<Double> var1);

        public _FinalStage baseMileageRateUsdPerInstance(Optional<Double> var1);

        public _FinalStage baseMileageRateUsdPerInstance(Double var1);

        public _FinalStage baseMileageRateUsdPerInstance(Nullable<Double> var1);

        public _FinalStage additionalMileageRateUsdPerMile(Optional<Double> var1);

        public _FinalStage additionalMileageRateUsdPerMile(Double var1);

        public _FinalStage additionalMileageRateUsdPerMile(Nullable<Double> var1);

        public _FinalStage longDistanceSurchargeMilesBeforeSurcharge(Optional<Double> var1);

        public _FinalStage longDistanceSurchargeMilesBeforeSurcharge(Double var1);

        public _FinalStage longDistanceSurchargeMilesBeforeSurcharge(Nullable<Double> var1);

        public _FinalStage longDistanceSurchargeRateUsdPerMile(Optional<Double> var1);

        public _FinalStage longDistanceSurchargeRateUsdPerMile(Double var1);

        public _FinalStage longDistanceSurchargeRateUsdPerMile(Nullable<Double> var1);

        public _FinalStage fuelSurchargeRateUsdPerMile(Optional<Double> var1);

        public _FinalStage fuelSurchargeRateUsdPerMile(Double var1);

        public _FinalStage fuelSurchargeRateUsdPerMile(Nullable<Double> var1);

        public _FinalStage waitTimeBeforeChargeMinutes(Optional<Double> var1);

        public _FinalStage waitTimeBeforeChargeMinutes(Double var1);

        public _FinalStage waitTimeBeforeChargeMinutes(Nullable<Double> var1);

        public _FinalStage waitTimeRateUsdPerMinute(Optional<Double> var1);

        public _FinalStage waitTimeRateUsdPerMinute(Double var1);

        public _FinalStage waitTimeRateUsdPerMinute(Nullable<Double> var1);

        public _FinalStage extraStopRateUsd(Optional<Double> var1);

        public _FinalStage extraStopRateUsd(Double var1);

        public _FinalStage extraStopRateUsd(Nullable<Double> var1);

        public _FinalStage dangerousGoodsRateUsdPerInstance(Optional<Double> var1);

        public _FinalStage dangerousGoodsRateUsdPerInstance(Double var1);

        public _FinalStage dangerousGoodsRateUsdPerInstance(Nullable<Double> var1);

        public _FinalStage afterHoursRateUsdPerInstance(Optional<Double> var1);

        public _FinalStage afterHoursRateUsdPerInstance(Double var1);

        public _FinalStage afterHoursRateUsdPerInstance(Nullable<Double> var1);

        public _FinalStage weekendRateUsdPerInstance(Optional<Double> var1);

        public _FinalStage weekendRateUsdPerInstance(Double var1);

        public _FinalStage weekendRateUsdPerInstance(Nullable<Double> var1);

        public _FinalStage holidayRateUsdPerInstance(Optional<Double> var1);

        public _FinalStage holidayRateUsdPerInstance(Double var1);

        public _FinalStage holidayRateUsdPerInstance(Nullable<Double> var1);
    }

    public static interface ServiceTypeStage {
        public _FinalStage serviceType(@NotNull ServiceTypeEnum1 var1);
    }

    public static interface SchemaVersionStage {
        public ServiceTypeStage schemaVersion(int var1);
    }

    public static interface PaymentVectorTypeStage {
        public SchemaVersionStage paymentVectorType(@NotNull PaymentVectorTypeEnum1 var1);

        public Builder from(RateSheetClientCreate1 var1);
    }
}

