/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.billing.ratesheets.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.resources.billing.ratesheets.types.RateSheetsListByOrgV1RequestSortOrder;
import com.chrt.api.types.CargoTypeEnum1;
import com.chrt.api.types.PaymentVectorTypeEnum1;
import com.chrt.api.types.RateSheetSortByEnum;
import com.chrt.api.types.ServiceTypeEnum1;
import com.chrt.api.types.VehicleTypeEnum;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class RateSheetsListByOrgV1Request {
    private final Optional<RateSheetSortByEnum> sortBy;
    private final Optional<RateSheetsListByOrgV1RequestSortOrder> sortOrder;
    private final Optional<Integer> page;
    private final Optional<Integer> pageSize;
    private final Optional<Boolean> filterArchived;
    private final Optional<PaymentVectorTypeEnum1> filterPaymentVectorType;
    private final Optional<ServiceTypeEnum1> filterServiceType;
    private final Optional<CargoTypeEnum1> filterCargoType;
    private final Optional<VehicleTypeEnum> filterVehicleType;
    private final Map<String, Object> additionalProperties;

    private RateSheetsListByOrgV1Request(Optional<RateSheetSortByEnum> sortBy, Optional<RateSheetsListByOrgV1RequestSortOrder> sortOrder, Optional<Integer> page, Optional<Integer> pageSize, Optional<Boolean> filterArchived, Optional<PaymentVectorTypeEnum1> filterPaymentVectorType, Optional<ServiceTypeEnum1> filterServiceType, Optional<CargoTypeEnum1> filterCargoType, Optional<VehicleTypeEnum> filterVehicleType, Map<String, Object> additionalProperties) {
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.page = page;
        this.pageSize = pageSize;
        this.filterArchived = filterArchived;
        this.filterPaymentVectorType = filterPaymentVectorType;
        this.filterServiceType = filterServiceType;
        this.filterCargoType = filterCargoType;
        this.filterVehicleType = filterVehicleType;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<RateSheetSortByEnum> getSortBy() {
        if (this.sortBy == null) {
            return Optional.empty();
        }
        return this.sortBy;
    }

    @JsonIgnore
    public Optional<RateSheetsListByOrgV1RequestSortOrder> getSortOrder() {
        if (this.sortOrder == null) {
            return Optional.empty();
        }
        return this.sortOrder;
    }

    @JsonIgnore
    public Optional<Integer> getPage() {
        if (this.page == null) {
            return Optional.empty();
        }
        return this.page;
    }

    @JsonIgnore
    public Optional<Integer> getPageSize() {
        if (this.pageSize == null) {
            return Optional.empty();
        }
        return this.pageSize;
    }

    @JsonIgnore
    public Optional<Boolean> getFilterArchived() {
        if (this.filterArchived == null) {
            return Optional.empty();
        }
        return this.filterArchived;
    }

    @JsonIgnore
    public Optional<PaymentVectorTypeEnum1> getFilterPaymentVectorType() {
        if (this.filterPaymentVectorType == null) {
            return Optional.empty();
        }
        return this.filterPaymentVectorType;
    }

    @JsonIgnore
    public Optional<ServiceTypeEnum1> getFilterServiceType() {
        if (this.filterServiceType == null) {
            return Optional.empty();
        }
        return this.filterServiceType;
    }

    @JsonIgnore
    public Optional<CargoTypeEnum1> getFilterCargoType() {
        if (this.filterCargoType == null) {
            return Optional.empty();
        }
        return this.filterCargoType;
    }

    @JsonIgnore
    public Optional<VehicleTypeEnum> getFilterVehicleType() {
        if (this.filterVehicleType == null) {
            return Optional.empty();
        }
        return this.filterVehicleType;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="sort_by")
    private Optional<RateSheetSortByEnum> _getSortBy() {
        return this.sortBy;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="sort_order")
    private Optional<RateSheetsListByOrgV1RequestSortOrder> _getSortOrder() {
        return this.sortOrder;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="page")
    private Optional<Integer> _getPage() {
        return this.page;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="page_size")
    private Optional<Integer> _getPageSize() {
        return this.pageSize;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="filter_archived")
    private Optional<Boolean> _getFilterArchived() {
        return this.filterArchived;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="filter_payment_vector_type")
    private Optional<PaymentVectorTypeEnum1> _getFilterPaymentVectorType() {
        return this.filterPaymentVectorType;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="filter_service_type")
    private Optional<ServiceTypeEnum1> _getFilterServiceType() {
        return this.filterServiceType;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="filter_cargo_type")
    private Optional<CargoTypeEnum1> _getFilterCargoType() {
        return this.filterCargoType;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="filter_vehicle_type")
    private Optional<VehicleTypeEnum> _getFilterVehicleType() {
        return this.filterVehicleType;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof RateSheetsListByOrgV1Request && this.equalTo((RateSheetsListByOrgV1Request)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(RateSheetsListByOrgV1Request other) {
        return this.sortBy.equals(other.sortBy) && this.sortOrder.equals(other.sortOrder) && this.page.equals(other.page) && this.pageSize.equals(other.pageSize) && this.filterArchived.equals(other.filterArchived) && this.filterPaymentVectorType.equals(other.filterPaymentVectorType) && this.filterServiceType.equals(other.filterServiceType) && this.filterCargoType.equals(other.filterCargoType) && this.filterVehicleType.equals(other.filterVehicleType);
    }

    public int hashCode() {
        return Objects.hash(this.sortBy, this.sortOrder, this.page, this.pageSize, this.filterArchived, this.filterPaymentVectorType, this.filterServiceType, this.filterCargoType, this.filterVehicleType);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<RateSheetSortByEnum> sortBy = Optional.empty();
        private Optional<RateSheetsListByOrgV1RequestSortOrder> sortOrder = Optional.empty();
        private Optional<Integer> page = Optional.empty();
        private Optional<Integer> pageSize = Optional.empty();
        private Optional<Boolean> filterArchived = Optional.empty();
        private Optional<PaymentVectorTypeEnum1> filterPaymentVectorType = Optional.empty();
        private Optional<ServiceTypeEnum1> filterServiceType = Optional.empty();
        private Optional<CargoTypeEnum1> filterCargoType = Optional.empty();
        private Optional<VehicleTypeEnum> filterVehicleType = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(RateSheetsListByOrgV1Request other) {
            this.sortBy(other.getSortBy());
            this.sortOrder(other.getSortOrder());
            this.page(other.getPage());
            this.pageSize(other.getPageSize());
            this.filterArchived(other.getFilterArchived());
            this.filterPaymentVectorType(other.getFilterPaymentVectorType());
            this.filterServiceType(other.getFilterServiceType());
            this.filterCargoType(other.getFilterCargoType());
            this.filterVehicleType(other.getFilterVehicleType());
            return this;
        }

        @JsonSetter(value="sort_by", nulls=Nulls.SKIP)
        public Builder sortBy(Optional<RateSheetSortByEnum> sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortBy(RateSheetSortByEnum sortBy) {
            this.sortBy = Optional.ofNullable(sortBy);
            return this;
        }

        public Builder sortBy(Nullable<RateSheetSortByEnum> sortBy) {
            this.sortBy = sortBy.isNull() ? null : (sortBy.isEmpty() ? Optional.empty() : Optional.of(sortBy.get()));
            return this;
        }

        @JsonSetter(value="sort_order", nulls=Nulls.SKIP)
        public Builder sortOrder(Optional<RateSheetsListByOrgV1RequestSortOrder> sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortOrder(RateSheetsListByOrgV1RequestSortOrder sortOrder) {
            this.sortOrder = Optional.ofNullable(sortOrder);
            return this;
        }

        public Builder sortOrder(Nullable<RateSheetsListByOrgV1RequestSortOrder> sortOrder) {
            this.sortOrder = sortOrder.isNull() ? null : (sortOrder.isEmpty() ? Optional.empty() : Optional.of(sortOrder.get()));
            return this;
        }

        @JsonSetter(value="page", nulls=Nulls.SKIP)
        public Builder page(Optional<Integer> page) {
            this.page = page;
            return this;
        }

        public Builder page(Integer page) {
            this.page = Optional.ofNullable(page);
            return this;
        }

        public Builder page(Nullable<Integer> page) {
            this.page = page.isNull() ? null : (page.isEmpty() ? Optional.empty() : Optional.of(page.get()));
            return this;
        }

        @JsonSetter(value="page_size", nulls=Nulls.SKIP)
        public Builder pageSize(Optional<Integer> pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.pageSize = Optional.ofNullable(pageSize);
            return this;
        }

        public Builder pageSize(Nullable<Integer> pageSize) {
            this.pageSize = pageSize.isNull() ? null : (pageSize.isEmpty() ? Optional.empty() : Optional.of(pageSize.get()));
            return this;
        }

        @JsonSetter(value="filter_archived", nulls=Nulls.SKIP)
        public Builder filterArchived(Optional<Boolean> filterArchived) {
            this.filterArchived = filterArchived;
            return this;
        }

        public Builder filterArchived(Boolean filterArchived) {
            this.filterArchived = Optional.ofNullable(filterArchived);
            return this;
        }

        public Builder filterArchived(Nullable<Boolean> filterArchived) {
            this.filterArchived = filterArchived.isNull() ? null : (filterArchived.isEmpty() ? Optional.empty() : Optional.of(filterArchived.get()));
            return this;
        }

        @JsonSetter(value="filter_payment_vector_type", nulls=Nulls.SKIP)
        public Builder filterPaymentVectorType(Optional<PaymentVectorTypeEnum1> filterPaymentVectorType) {
            this.filterPaymentVectorType = filterPaymentVectorType;
            return this;
        }

        public Builder filterPaymentVectorType(PaymentVectorTypeEnum1 filterPaymentVectorType) {
            this.filterPaymentVectorType = Optional.ofNullable(filterPaymentVectorType);
            return this;
        }

        public Builder filterPaymentVectorType(Nullable<PaymentVectorTypeEnum1> filterPaymentVectorType) {
            this.filterPaymentVectorType = filterPaymentVectorType.isNull() ? null : (filterPaymentVectorType.isEmpty() ? Optional.empty() : Optional.of(filterPaymentVectorType.get()));
            return this;
        }

        @JsonSetter(value="filter_service_type", nulls=Nulls.SKIP)
        public Builder filterServiceType(Optional<ServiceTypeEnum1> filterServiceType) {
            this.filterServiceType = filterServiceType;
            return this;
        }

        public Builder filterServiceType(ServiceTypeEnum1 filterServiceType) {
            this.filterServiceType = Optional.ofNullable(filterServiceType);
            return this;
        }

        public Builder filterServiceType(Nullable<ServiceTypeEnum1> filterServiceType) {
            this.filterServiceType = filterServiceType.isNull() ? null : (filterServiceType.isEmpty() ? Optional.empty() : Optional.of(filterServiceType.get()));
            return this;
        }

        @JsonSetter(value="filter_cargo_type", nulls=Nulls.SKIP)
        public Builder filterCargoType(Optional<CargoTypeEnum1> filterCargoType) {
            this.filterCargoType = filterCargoType;
            return this;
        }

        public Builder filterCargoType(CargoTypeEnum1 filterCargoType) {
            this.filterCargoType = Optional.ofNullable(filterCargoType);
            return this;
        }

        public Builder filterCargoType(Nullable<CargoTypeEnum1> filterCargoType) {
            this.filterCargoType = filterCargoType.isNull() ? null : (filterCargoType.isEmpty() ? Optional.empty() : Optional.of(filterCargoType.get()));
            return this;
        }

        @JsonSetter(value="filter_vehicle_type", nulls=Nulls.SKIP)
        public Builder filterVehicleType(Optional<VehicleTypeEnum> filterVehicleType) {
            this.filterVehicleType = filterVehicleType;
            return this;
        }

        public Builder filterVehicleType(VehicleTypeEnum filterVehicleType) {
            this.filterVehicleType = Optional.ofNullable(filterVehicleType);
            return this;
        }

        public Builder filterVehicleType(Nullable<VehicleTypeEnum> filterVehicleType) {
            this.filterVehicleType = filterVehicleType.isNull() ? null : (filterVehicleType.isEmpty() ? Optional.empty() : Optional.of(filterVehicleType.get()));
            return this;
        }

        public RateSheetsListByOrgV1Request build() {
            return new RateSheetsListByOrgV1Request(this.sortBy, this.sortOrder, this.page, this.pageSize, this.filterArchived, this.filterPaymentVectorType, this.filterServiceType, this.filterCargoType, this.filterVehicleType, this.additionalProperties);
        }
    }
}

