/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.billing.ratesheets.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.ServiceTypeEnum1;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class RateSheetsUpdateDefaultForConnectionV1Request {
    private final String connectionId;
    private final ServiceTypeEnum1 serviceType;
    private final Optional<String> rateSheetId;
    private final Map<String, Object> additionalProperties;

    private RateSheetsUpdateDefaultForConnectionV1Request(String connectionId, ServiceTypeEnum1 serviceType, Optional<String> rateSheetId, Map<String, Object> additionalProperties) {
        this.connectionId = connectionId;
        this.serviceType = serviceType;
        this.rateSheetId = rateSheetId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="connection_id")
    public String getConnectionId() {
        return this.connectionId;
    }

    @JsonProperty(value="service_type")
    public ServiceTypeEnum1 getServiceType() {
        return this.serviceType;
    }

    @JsonIgnore
    public Optional<String> getRateSheetId() {
        if (this.rateSheetId == null) {
            return Optional.empty();
        }
        return this.rateSheetId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="rate_sheet_id")
    private Optional<String> _getRateSheetId() {
        return this.rateSheetId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof RateSheetsUpdateDefaultForConnectionV1Request && this.equalTo((RateSheetsUpdateDefaultForConnectionV1Request)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(RateSheetsUpdateDefaultForConnectionV1Request other) {
        return this.connectionId.equals(other.connectionId) && this.serviceType.equals(other.serviceType) && this.rateSheetId.equals(other.rateSheetId);
    }

    public int hashCode() {
        return Objects.hash(this.connectionId, this.serviceType, this.rateSheetId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ConnectionIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ConnectionIdStage,
    ServiceTypeStage,
    _FinalStage {
        private String connectionId;
        private ServiceTypeEnum1 serviceType;
        private Optional<String> rateSheetId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(RateSheetsUpdateDefaultForConnectionV1Request other) {
            this.connectionId(other.getConnectionId());
            this.serviceType(other.getServiceType());
            this.rateSheetId(other.getRateSheetId());
            return this;
        }

        @Override
        @JsonSetter(value="connection_id")
        public ServiceTypeStage connectionId(@NotNull String connectionId) {
            this.connectionId = Objects.requireNonNull(connectionId, "connectionId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="service_type")
        public _FinalStage serviceType(@NotNull ServiceTypeEnum1 serviceType) {
            this.serviceType = Objects.requireNonNull(serviceType, "serviceType must not be null");
            return this;
        }

        @Override
        public _FinalStage rateSheetId(Nullable<String> rateSheetId) {
            this.rateSheetId = rateSheetId.isNull() ? null : (rateSheetId.isEmpty() ? Optional.empty() : Optional.of(rateSheetId.get()));
            return this;
        }

        @Override
        public _FinalStage rateSheetId(String rateSheetId) {
            this.rateSheetId = Optional.ofNullable(rateSheetId);
            return this;
        }

        @Override
        @JsonSetter(value="rate_sheet_id", nulls=Nulls.SKIP)
        public _FinalStage rateSheetId(Optional<String> rateSheetId) {
            this.rateSheetId = rateSheetId;
            return this;
        }

        @Override
        public RateSheetsUpdateDefaultForConnectionV1Request build() {
            return new RateSheetsUpdateDefaultForConnectionV1Request(this.connectionId, this.serviceType, this.rateSheetId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public RateSheetsUpdateDefaultForConnectionV1Request build();

        public _FinalStage rateSheetId(Optional<String> var1);

        public _FinalStage rateSheetId(String var1);

        public _FinalStage rateSheetId(Nullable<String> var1);
    }

    public static interface ServiceTypeStage {
        public _FinalStage serviceType(@NotNull ServiceTypeEnum1 var1);
    }

    public static interface ConnectionIdStage {
        public ServiceTypeStage connectionId(@NotNull String var1);

        public Builder from(RateSheetsUpdateDefaultForConnectionV1Request var1);
    }
}

