/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.billing.ratesheets.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.ServiceTypeEnum1;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class RateSheetsUpdateDefaultForDriverV1Request {
    private final String driverId;
    private final ServiceTypeEnum1 serviceType;
    private final Optional<String> rateSheetId;
    private final Map<String, Object> additionalProperties;

    private RateSheetsUpdateDefaultForDriverV1Request(String driverId, ServiceTypeEnum1 serviceType, Optional<String> rateSheetId, Map<String, Object> additionalProperties) {
        this.driverId = driverId;
        this.serviceType = serviceType;
        this.rateSheetId = rateSheetId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="driver_id")
    public String getDriverId() {
        return this.driverId;
    }

    @JsonProperty(value="service_type")
    public ServiceTypeEnum1 getServiceType() {
        return this.serviceType;
    }

    @JsonIgnore
    public Optional<String> getRateSheetId() {
        if (this.rateSheetId == null) {
            return Optional.empty();
        }
        return this.rateSheetId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="rate_sheet_id")
    private Optional<String> _getRateSheetId() {
        return this.rateSheetId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof RateSheetsUpdateDefaultForDriverV1Request && this.equalTo((RateSheetsUpdateDefaultForDriverV1Request)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(RateSheetsUpdateDefaultForDriverV1Request other) {
        return this.driverId.equals(other.driverId) && this.serviceType.equals(other.serviceType) && this.rateSheetId.equals(other.rateSheetId);
    }

    public int hashCode() {
        return Objects.hash(this.driverId, this.serviceType, this.rateSheetId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static DriverIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements DriverIdStage,
    ServiceTypeStage,
    _FinalStage {
        private String driverId;
        private ServiceTypeEnum1 serviceType;
        private Optional<String> rateSheetId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(RateSheetsUpdateDefaultForDriverV1Request other) {
            this.driverId(other.getDriverId());
            this.serviceType(other.getServiceType());
            this.rateSheetId(other.getRateSheetId());
            return this;
        }

        @Override
        @JsonSetter(value="driver_id")
        public ServiceTypeStage driverId(@NotNull String driverId) {
            this.driverId = Objects.requireNonNull(driverId, "driverId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="service_type")
        public _FinalStage serviceType(@NotNull ServiceTypeEnum1 serviceType) {
            this.serviceType = Objects.requireNonNull(serviceType, "serviceType must not be null");
            return this;
        }

        @Override
        public _FinalStage rateSheetId(Nullable<String> rateSheetId) {
            this.rateSheetId = rateSheetId.isNull() ? null : (rateSheetId.isEmpty() ? Optional.empty() : Optional.of(rateSheetId.get()));
            return this;
        }

        @Override
        public _FinalStage rateSheetId(String rateSheetId) {
            this.rateSheetId = Optional.ofNullable(rateSheetId);
            return this;
        }

        @Override
        @JsonSetter(value="rate_sheet_id", nulls=Nulls.SKIP)
        public _FinalStage rateSheetId(Optional<String> rateSheetId) {
            this.rateSheetId = rateSheetId;
            return this;
        }

        @Override
        public RateSheetsUpdateDefaultForDriverV1Request build() {
            return new RateSheetsUpdateDefaultForDriverV1Request(this.driverId, this.serviceType, this.rateSheetId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public RateSheetsUpdateDefaultForDriverV1Request build();

        public _FinalStage rateSheetId(Optional<String> var1);

        public _FinalStage rateSheetId(String var1);

        public _FinalStage rateSheetId(Nullable<String> var1);
    }

    public static interface ServiceTypeStage {
        public _FinalStage serviceType(@NotNull ServiceTypeEnum1 var1);
    }

    public static interface DriverIdStage {
        public ServiceTypeStage driverId(@NotNull String var1);

        public Builder from(RateSheetsUpdateDefaultForDriverV1Request var1);
    }
}

