/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.billing.statements;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.billing.statements.RawStatementsClient;
import com.chrt.api.resources.billing.statements.requests.BodyStatementsPatchUpdateOffChrtSettlementStateV1BillingUpdateOffChrtSettlementStateV1StatementIdPatch;
import com.chrt.api.resources.billing.statements.requests.BodyStatementsPatchUpdateSettlementTypeV1BillingUpdateSettlementTypeV1StatementIdPatch;
import com.chrt.api.resources.billing.statements.requests.CreateStatementReq;
import com.chrt.api.resources.billing.statements.requests.OpenInvoiceReq;
import com.chrt.api.resources.billing.statements.requests.StatementExpandedRetrieveReq;
import com.chrt.api.resources.billing.statements.requests.StatementsListV1Request;
import com.chrt.api.types.Statement1;
import com.chrt.api.types.StatementExpandedRes;
import com.chrt.api.types.StatementsListRes;

public class StatementsClient {
    protected final ClientOptions clientOptions;
    private final RawStatementsClient rawClient;

    public StatementsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawStatementsClient(clientOptions);
    }

    public RawStatementsClient withRawResponse() {
        return this.rawClient;
    }

    public Statement1 getV1(String statementId) {
        return this.rawClient.getV1(statementId).body();
    }

    public Statement1 getV1(String statementId, RequestOptions requestOptions) {
        return this.rawClient.getV1(statementId, requestOptions).body();
    }

    public Statement1 getByLigIdV1(String lineItemGroupId) {
        return this.rawClient.getByLigIdV1(lineItemGroupId).body();
    }

    public Statement1 getByLigIdV1(String lineItemGroupId, RequestOptions requestOptions) {
        return this.rawClient.getByLigIdV1(lineItemGroupId, requestOptions).body();
    }

    public StatementExpandedRes expandedRetrieveV1(StatementExpandedRetrieveReq request) {
        return this.rawClient.expandedRetrieveV1(request).body();
    }

    public StatementExpandedRes expandedRetrieveV1(StatementExpandedRetrieveReq request, RequestOptions requestOptions) {
        return this.rawClient.expandedRetrieveV1(request, requestOptions).body();
    }

    public StatementsListRes listV1() {
        return this.rawClient.listV1().body();
    }

    public StatementsListRes listV1(StatementsListV1Request request) {
        return this.rawClient.listV1(request).body();
    }

    public StatementsListRes listV1(StatementsListV1Request request, RequestOptions requestOptions) {
        return this.rawClient.listV1(request, requestOptions).body();
    }

    public Statement1 createV1(CreateStatementReq request) {
        return this.rawClient.createV1(request).body();
    }

    public Statement1 createV1(CreateStatementReq request, RequestOptions requestOptions) {
        return this.rawClient.createV1(request, requestOptions).body();
    }

    public boolean deleteV1(String statementId) {
        return this.rawClient.deleteV1(statementId).body();
    }

    public boolean deleteV1(String statementId, RequestOptions requestOptions) {
        return this.rawClient.deleteV1(statementId, requestOptions).body();
    }

    public Statement1 updateSettlementTypeV1(String statementId, BodyStatementsPatchUpdateSettlementTypeV1BillingUpdateSettlementTypeV1StatementIdPatch request) {
        return this.rawClient.updateSettlementTypeV1(statementId, request).body();
    }

    public Statement1 updateSettlementTypeV1(String statementId, BodyStatementsPatchUpdateSettlementTypeV1BillingUpdateSettlementTypeV1StatementIdPatch request, RequestOptions requestOptions) {
        return this.rawClient.updateSettlementTypeV1(statementId, request, requestOptions).body();
    }

    public Statement1 updateOffChrtSettlementStateV1(String statementId, BodyStatementsPatchUpdateOffChrtSettlementStateV1BillingUpdateOffChrtSettlementStateV1StatementIdPatch request) {
        return this.rawClient.updateOffChrtSettlementStateV1(statementId, request).body();
    }

    public Statement1 updateOffChrtSettlementStateV1(String statementId, BodyStatementsPatchUpdateOffChrtSettlementStateV1BillingUpdateOffChrtSettlementStateV1StatementIdPatch request, RequestOptions requestOptions) {
        return this.rawClient.updateOffChrtSettlementStateV1(statementId, request, requestOptions).body();
    }

    public Statement1 openInvoiceV1(String statementId) {
        return this.rawClient.openInvoiceV1(statementId).body();
    }

    public Statement1 openInvoiceV1(String statementId, OpenInvoiceReq request) {
        return this.rawClient.openInvoiceV1(statementId, request).body();
    }

    public Statement1 openInvoiceV1(String statementId, OpenInvoiceReq request, RequestOptions requestOptions) {
        return this.rawClient.openInvoiceV1(statementId, request, requestOptions).body();
    }

    public Statement1 syncInvoiceV1(String statementId) {
        return this.rawClient.syncInvoiceV1(statementId).body();
    }

    public Statement1 syncInvoiceV1(String statementId, RequestOptions requestOptions) {
        return this.rawClient.syncInvoiceV1(statementId, requestOptions).body();
    }

    public Statement1 voidInvoiceV1(String statementId) {
        return this.rawClient.voidInvoiceV1(statementId).body();
    }

    public Statement1 voidInvoiceV1(String statementId, RequestOptions requestOptions) {
        return this.rawClient.voidInvoiceV1(statementId, requestOptions).body();
    }
}

