/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.billing.statements.requests;

import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class OpenInvoiceReq {
    private final Optional<Integer> daysUntilDue;
    private final Optional<String> description;
    private final Map<String, Object> additionalProperties;

    private OpenInvoiceReq(Optional<Integer> daysUntilDue, Optional<String> description, Map<String, Object> additionalProperties) {
        this.daysUntilDue = daysUntilDue;
        this.description = description;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="days_until_due")
    public Optional<Integer> getDaysUntilDue() {
        return this.daysUntilDue;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof OpenInvoiceReq && this.equalTo((OpenInvoiceReq)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OpenInvoiceReq other) {
        return this.daysUntilDue.equals(other.daysUntilDue) && this.description.equals(other.description);
    }

    public int hashCode() {
        return Objects.hash(this.daysUntilDue, this.description);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Integer> daysUntilDue = Optional.empty();
        private Optional<String> description = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(OpenInvoiceReq other) {
            this.daysUntilDue(other.getDaysUntilDue());
            this.description(other.getDescription());
            return this;
        }

        @JsonSetter(value="days_until_due", nulls=Nulls.SKIP)
        public Builder daysUntilDue(Optional<Integer> daysUntilDue) {
            this.daysUntilDue = daysUntilDue;
            return this;
        }

        public Builder daysUntilDue(Integer daysUntilDue) {
            this.daysUntilDue = Optional.ofNullable(daysUntilDue);
            return this;
        }

        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        public OpenInvoiceReq build() {
            return new OpenInvoiceReq(this.daysUntilDue, this.description, this.additionalProperties);
        }
    }
}

