/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.billing.statements.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.SettlementTypeEnum1;
import com.chrt.api.types.SortOrderEnum;
import com.chrt.api.types.StatementSortByEnum;
import com.chrt.api.types.StatementStatusEnum1;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class StatementsListV1Request {
    private final Optional<List<StatementStatusEnum1>> filterStatus;
    private final Optional<StatementSortByEnum> sortBy;
    private final Optional<SortOrderEnum> sortOrder;
    private final Optional<Integer> page;
    private final Optional<Integer> pageSize;
    private final Optional<SettlementTypeEnum1> filterSettlementType;
    private final Optional<String> filterPaymentOriginOrgId;
    private final Optional<String> filterPaymentDestinationOrgId;
    private final Optional<String> filterOwnedByOrgId;
    private final Optional<OffsetDateTime> filterStagedAtTimestampGte;
    private final Optional<OffsetDateTime> filterStagedAtTimestampLte;
    private final Optional<OffsetDateTime> filterOpenedAtTimestampGte;
    private final Optional<OffsetDateTime> filterOpenedAtTimestampLte;
    private final Optional<OffsetDateTime> filterPaidAtTimestampGte;
    private final Optional<OffsetDateTime> filterPaidAtTimestampLte;
    private final Map<String, Object> additionalProperties;

    private StatementsListV1Request(Optional<List<StatementStatusEnum1>> filterStatus, Optional<StatementSortByEnum> sortBy, Optional<SortOrderEnum> sortOrder, Optional<Integer> page, Optional<Integer> pageSize, Optional<SettlementTypeEnum1> filterSettlementType, Optional<String> filterPaymentOriginOrgId, Optional<String> filterPaymentDestinationOrgId, Optional<String> filterOwnedByOrgId, Optional<OffsetDateTime> filterStagedAtTimestampGte, Optional<OffsetDateTime> filterStagedAtTimestampLte, Optional<OffsetDateTime> filterOpenedAtTimestampGte, Optional<OffsetDateTime> filterOpenedAtTimestampLte, Optional<OffsetDateTime> filterPaidAtTimestampGte, Optional<OffsetDateTime> filterPaidAtTimestampLte, Map<String, Object> additionalProperties) {
        this.filterStatus = filterStatus;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.page = page;
        this.pageSize = pageSize;
        this.filterSettlementType = filterSettlementType;
        this.filterPaymentOriginOrgId = filterPaymentOriginOrgId;
        this.filterPaymentDestinationOrgId = filterPaymentDestinationOrgId;
        this.filterOwnedByOrgId = filterOwnedByOrgId;
        this.filterStagedAtTimestampGte = filterStagedAtTimestampGte;
        this.filterStagedAtTimestampLte = filterStagedAtTimestampLte;
        this.filterOpenedAtTimestampGte = filterOpenedAtTimestampGte;
        this.filterOpenedAtTimestampLte = filterOpenedAtTimestampLte;
        this.filterPaidAtTimestampGte = filterPaidAtTimestampGte;
        this.filterPaidAtTimestampLte = filterPaidAtTimestampLte;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<List<StatementStatusEnum1>> getFilterStatus() {
        if (this.filterStatus == null) {
            return Optional.empty();
        }
        return this.filterStatus;
    }

    @JsonIgnore
    public Optional<StatementSortByEnum> getSortBy() {
        if (this.sortBy == null) {
            return Optional.empty();
        }
        return this.sortBy;
    }

    @JsonIgnore
    public Optional<SortOrderEnum> getSortOrder() {
        if (this.sortOrder == null) {
            return Optional.empty();
        }
        return this.sortOrder;
    }

    @JsonIgnore
    public Optional<Integer> getPage() {
        if (this.page == null) {
            return Optional.empty();
        }
        return this.page;
    }

    @JsonIgnore
    public Optional<Integer> getPageSize() {
        if (this.pageSize == null) {
            return Optional.empty();
        }
        return this.pageSize;
    }

    @JsonIgnore
    public Optional<SettlementTypeEnum1> getFilterSettlementType() {
        if (this.filterSettlementType == null) {
            return Optional.empty();
        }
        return this.filterSettlementType;
    }

    @JsonIgnore
    public Optional<String> getFilterPaymentOriginOrgId() {
        if (this.filterPaymentOriginOrgId == null) {
            return Optional.empty();
        }
        return this.filterPaymentOriginOrgId;
    }

    @JsonIgnore
    public Optional<String> getFilterPaymentDestinationOrgId() {
        if (this.filterPaymentDestinationOrgId == null) {
            return Optional.empty();
        }
        return this.filterPaymentDestinationOrgId;
    }

    @JsonIgnore
    public Optional<String> getFilterOwnedByOrgId() {
        if (this.filterOwnedByOrgId == null) {
            return Optional.empty();
        }
        return this.filterOwnedByOrgId;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getFilterStagedAtTimestampGte() {
        if (this.filterStagedAtTimestampGte == null) {
            return Optional.empty();
        }
        return this.filterStagedAtTimestampGte;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getFilterStagedAtTimestampLte() {
        if (this.filterStagedAtTimestampLte == null) {
            return Optional.empty();
        }
        return this.filterStagedAtTimestampLte;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getFilterOpenedAtTimestampGte() {
        if (this.filterOpenedAtTimestampGte == null) {
            return Optional.empty();
        }
        return this.filterOpenedAtTimestampGte;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getFilterOpenedAtTimestampLte() {
        if (this.filterOpenedAtTimestampLte == null) {
            return Optional.empty();
        }
        return this.filterOpenedAtTimestampLte;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getFilterPaidAtTimestampGte() {
        if (this.filterPaidAtTimestampGte == null) {
            return Optional.empty();
        }
        return this.filterPaidAtTimestampGte;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getFilterPaidAtTimestampLte() {
        if (this.filterPaidAtTimestampLte == null) {
            return Optional.empty();
        }
        return this.filterPaidAtTimestampLte;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="filter_status")
    private Optional<List<StatementStatusEnum1>> _getFilterStatus() {
        return this.filterStatus;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="sort_by")
    private Optional<StatementSortByEnum> _getSortBy() {
        return this.sortBy;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="sort_order")
    private Optional<SortOrderEnum> _getSortOrder() {
        return this.sortOrder;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="page")
    private Optional<Integer> _getPage() {
        return this.page;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="page_size")
    private Optional<Integer> _getPageSize() {
        return this.pageSize;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="filter_settlement_type")
    private Optional<SettlementTypeEnum1> _getFilterSettlementType() {
        return this.filterSettlementType;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="filter_payment_origin_org_id")
    private Optional<String> _getFilterPaymentOriginOrgId() {
        return this.filterPaymentOriginOrgId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="filter_payment_destination_org_id")
    private Optional<String> _getFilterPaymentDestinationOrgId() {
        return this.filterPaymentDestinationOrgId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="filter_owned_by_org_id")
    private Optional<String> _getFilterOwnedByOrgId() {
        return this.filterOwnedByOrgId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="filter_staged_at_timestamp_gte")
    private Optional<OffsetDateTime> _getFilterStagedAtTimestampGte() {
        return this.filterStagedAtTimestampGte;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="filter_staged_at_timestamp_lte")
    private Optional<OffsetDateTime> _getFilterStagedAtTimestampLte() {
        return this.filterStagedAtTimestampLte;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="filter_opened_at_timestamp_gte")
    private Optional<OffsetDateTime> _getFilterOpenedAtTimestampGte() {
        return this.filterOpenedAtTimestampGte;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="filter_opened_at_timestamp_lte")
    private Optional<OffsetDateTime> _getFilterOpenedAtTimestampLte() {
        return this.filterOpenedAtTimestampLte;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="filter_paid_at_timestamp_gte")
    private Optional<OffsetDateTime> _getFilterPaidAtTimestampGte() {
        return this.filterPaidAtTimestampGte;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="filter_paid_at_timestamp_lte")
    private Optional<OffsetDateTime> _getFilterPaidAtTimestampLte() {
        return this.filterPaidAtTimestampLte;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof StatementsListV1Request && this.equalTo((StatementsListV1Request)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(StatementsListV1Request other) {
        return this.filterStatus.equals(other.filterStatus) && this.sortBy.equals(other.sortBy) && this.sortOrder.equals(other.sortOrder) && this.page.equals(other.page) && this.pageSize.equals(other.pageSize) && this.filterSettlementType.equals(other.filterSettlementType) && this.filterPaymentOriginOrgId.equals(other.filterPaymentOriginOrgId) && this.filterPaymentDestinationOrgId.equals(other.filterPaymentDestinationOrgId) && this.filterOwnedByOrgId.equals(other.filterOwnedByOrgId) && this.filterStagedAtTimestampGte.equals(other.filterStagedAtTimestampGte) && this.filterStagedAtTimestampLte.equals(other.filterStagedAtTimestampLte) && this.filterOpenedAtTimestampGte.equals(other.filterOpenedAtTimestampGte) && this.filterOpenedAtTimestampLte.equals(other.filterOpenedAtTimestampLte) && this.filterPaidAtTimestampGte.equals(other.filterPaidAtTimestampGte) && this.filterPaidAtTimestampLte.equals(other.filterPaidAtTimestampLte);
    }

    public int hashCode() {
        return Objects.hash(this.filterStatus, this.sortBy, this.sortOrder, this.page, this.pageSize, this.filterSettlementType, this.filterPaymentOriginOrgId, this.filterPaymentDestinationOrgId, this.filterOwnedByOrgId, this.filterStagedAtTimestampGte, this.filterStagedAtTimestampLte, this.filterOpenedAtTimestampGte, this.filterOpenedAtTimestampLte, this.filterPaidAtTimestampGte, this.filterPaidAtTimestampLte);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<StatementStatusEnum1>> filterStatus = Optional.empty();
        private Optional<StatementSortByEnum> sortBy = Optional.empty();
        private Optional<SortOrderEnum> sortOrder = Optional.empty();
        private Optional<Integer> page = Optional.empty();
        private Optional<Integer> pageSize = Optional.empty();
        private Optional<SettlementTypeEnum1> filterSettlementType = Optional.empty();
        private Optional<String> filterPaymentOriginOrgId = Optional.empty();
        private Optional<String> filterPaymentDestinationOrgId = Optional.empty();
        private Optional<String> filterOwnedByOrgId = Optional.empty();
        private Optional<OffsetDateTime> filterStagedAtTimestampGte = Optional.empty();
        private Optional<OffsetDateTime> filterStagedAtTimestampLte = Optional.empty();
        private Optional<OffsetDateTime> filterOpenedAtTimestampGte = Optional.empty();
        private Optional<OffsetDateTime> filterOpenedAtTimestampLte = Optional.empty();
        private Optional<OffsetDateTime> filterPaidAtTimestampGte = Optional.empty();
        private Optional<OffsetDateTime> filterPaidAtTimestampLte = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(StatementsListV1Request other) {
            this.filterStatus(other.getFilterStatus());
            this.sortBy(other.getSortBy());
            this.sortOrder(other.getSortOrder());
            this.page(other.getPage());
            this.pageSize(other.getPageSize());
            this.filterSettlementType(other.getFilterSettlementType());
            this.filterPaymentOriginOrgId(other.getFilterPaymentOriginOrgId());
            this.filterPaymentDestinationOrgId(other.getFilterPaymentDestinationOrgId());
            this.filterOwnedByOrgId(other.getFilterOwnedByOrgId());
            this.filterStagedAtTimestampGte(other.getFilterStagedAtTimestampGte());
            this.filterStagedAtTimestampLte(other.getFilterStagedAtTimestampLte());
            this.filterOpenedAtTimestampGte(other.getFilterOpenedAtTimestampGte());
            this.filterOpenedAtTimestampLte(other.getFilterOpenedAtTimestampLte());
            this.filterPaidAtTimestampGte(other.getFilterPaidAtTimestampGte());
            this.filterPaidAtTimestampLte(other.getFilterPaidAtTimestampLte());
            return this;
        }

        @JsonSetter(value="filter_status", nulls=Nulls.SKIP)
        public Builder filterStatus(Optional<List<StatementStatusEnum1>> filterStatus) {
            this.filterStatus = filterStatus;
            return this;
        }

        public Builder filterStatus(List<StatementStatusEnum1> filterStatus) {
            this.filterStatus = Optional.ofNullable(filterStatus);
            return this;
        }

        public Builder filterStatus(Nullable<List<StatementStatusEnum1>> filterStatus) {
            this.filterStatus = filterStatus.isNull() ? null : (filterStatus.isEmpty() ? Optional.empty() : Optional.of(filterStatus.get()));
            return this;
        }

        public Builder filterStatus(StatementStatusEnum1 filterStatus) {
            this.filterStatus = Optional.of(Collections.singletonList(filterStatus));
            return this;
        }

        @JsonSetter(value="sort_by", nulls=Nulls.SKIP)
        public Builder sortBy(Optional<StatementSortByEnum> sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortBy(StatementSortByEnum sortBy) {
            this.sortBy = Optional.ofNullable(sortBy);
            return this;
        }

        public Builder sortBy(Nullable<StatementSortByEnum> sortBy) {
            this.sortBy = sortBy.isNull() ? null : (sortBy.isEmpty() ? Optional.empty() : Optional.of(sortBy.get()));
            return this;
        }

        @JsonSetter(value="sort_order", nulls=Nulls.SKIP)
        public Builder sortOrder(Optional<SortOrderEnum> sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortOrder(SortOrderEnum sortOrder) {
            this.sortOrder = Optional.ofNullable(sortOrder);
            return this;
        }

        public Builder sortOrder(Nullable<SortOrderEnum> sortOrder) {
            this.sortOrder = sortOrder.isNull() ? null : (sortOrder.isEmpty() ? Optional.empty() : Optional.of(sortOrder.get()));
            return this;
        }

        @JsonSetter(value="page", nulls=Nulls.SKIP)
        public Builder page(Optional<Integer> page) {
            this.page = page;
            return this;
        }

        public Builder page(Integer page) {
            this.page = Optional.ofNullable(page);
            return this;
        }

        public Builder page(Nullable<Integer> page) {
            this.page = page.isNull() ? null : (page.isEmpty() ? Optional.empty() : Optional.of(page.get()));
            return this;
        }

        @JsonSetter(value="page_size", nulls=Nulls.SKIP)
        public Builder pageSize(Optional<Integer> pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.pageSize = Optional.ofNullable(pageSize);
            return this;
        }

        public Builder pageSize(Nullable<Integer> pageSize) {
            this.pageSize = pageSize.isNull() ? null : (pageSize.isEmpty() ? Optional.empty() : Optional.of(pageSize.get()));
            return this;
        }

        @JsonSetter(value="filter_settlement_type", nulls=Nulls.SKIP)
        public Builder filterSettlementType(Optional<SettlementTypeEnum1> filterSettlementType) {
            this.filterSettlementType = filterSettlementType;
            return this;
        }

        public Builder filterSettlementType(SettlementTypeEnum1 filterSettlementType) {
            this.filterSettlementType = Optional.ofNullable(filterSettlementType);
            return this;
        }

        public Builder filterSettlementType(Nullable<SettlementTypeEnum1> filterSettlementType) {
            this.filterSettlementType = filterSettlementType.isNull() ? null : (filterSettlementType.isEmpty() ? Optional.empty() : Optional.of(filterSettlementType.get()));
            return this;
        }

        @JsonSetter(value="filter_payment_origin_org_id", nulls=Nulls.SKIP)
        public Builder filterPaymentOriginOrgId(Optional<String> filterPaymentOriginOrgId) {
            this.filterPaymentOriginOrgId = filterPaymentOriginOrgId;
            return this;
        }

        public Builder filterPaymentOriginOrgId(String filterPaymentOriginOrgId) {
            this.filterPaymentOriginOrgId = Optional.ofNullable(filterPaymentOriginOrgId);
            return this;
        }

        public Builder filterPaymentOriginOrgId(Nullable<String> filterPaymentOriginOrgId) {
            this.filterPaymentOriginOrgId = filterPaymentOriginOrgId.isNull() ? null : (filterPaymentOriginOrgId.isEmpty() ? Optional.empty() : Optional.of(filterPaymentOriginOrgId.get()));
            return this;
        }

        @JsonSetter(value="filter_payment_destination_org_id", nulls=Nulls.SKIP)
        public Builder filterPaymentDestinationOrgId(Optional<String> filterPaymentDestinationOrgId) {
            this.filterPaymentDestinationOrgId = filterPaymentDestinationOrgId;
            return this;
        }

        public Builder filterPaymentDestinationOrgId(String filterPaymentDestinationOrgId) {
            this.filterPaymentDestinationOrgId = Optional.ofNullable(filterPaymentDestinationOrgId);
            return this;
        }

        public Builder filterPaymentDestinationOrgId(Nullable<String> filterPaymentDestinationOrgId) {
            this.filterPaymentDestinationOrgId = filterPaymentDestinationOrgId.isNull() ? null : (filterPaymentDestinationOrgId.isEmpty() ? Optional.empty() : Optional.of(filterPaymentDestinationOrgId.get()));
            return this;
        }

        @JsonSetter(value="filter_owned_by_org_id", nulls=Nulls.SKIP)
        public Builder filterOwnedByOrgId(Optional<String> filterOwnedByOrgId) {
            this.filterOwnedByOrgId = filterOwnedByOrgId;
            return this;
        }

        public Builder filterOwnedByOrgId(String filterOwnedByOrgId) {
            this.filterOwnedByOrgId = Optional.ofNullable(filterOwnedByOrgId);
            return this;
        }

        public Builder filterOwnedByOrgId(Nullable<String> filterOwnedByOrgId) {
            this.filterOwnedByOrgId = filterOwnedByOrgId.isNull() ? null : (filterOwnedByOrgId.isEmpty() ? Optional.empty() : Optional.of(filterOwnedByOrgId.get()));
            return this;
        }

        @JsonSetter(value="filter_staged_at_timestamp_gte", nulls=Nulls.SKIP)
        public Builder filterStagedAtTimestampGte(Optional<OffsetDateTime> filterStagedAtTimestampGte) {
            this.filterStagedAtTimestampGte = filterStagedAtTimestampGte;
            return this;
        }

        public Builder filterStagedAtTimestampGte(OffsetDateTime filterStagedAtTimestampGte) {
            this.filterStagedAtTimestampGte = Optional.ofNullable(filterStagedAtTimestampGte);
            return this;
        }

        public Builder filterStagedAtTimestampGte(Nullable<OffsetDateTime> filterStagedAtTimestampGte) {
            this.filterStagedAtTimestampGte = filterStagedAtTimestampGte.isNull() ? null : (filterStagedAtTimestampGte.isEmpty() ? Optional.empty() : Optional.of(filterStagedAtTimestampGte.get()));
            return this;
        }

        @JsonSetter(value="filter_staged_at_timestamp_lte", nulls=Nulls.SKIP)
        public Builder filterStagedAtTimestampLte(Optional<OffsetDateTime> filterStagedAtTimestampLte) {
            this.filterStagedAtTimestampLte = filterStagedAtTimestampLte;
            return this;
        }

        public Builder filterStagedAtTimestampLte(OffsetDateTime filterStagedAtTimestampLte) {
            this.filterStagedAtTimestampLte = Optional.ofNullable(filterStagedAtTimestampLte);
            return this;
        }

        public Builder filterStagedAtTimestampLte(Nullable<OffsetDateTime> filterStagedAtTimestampLte) {
            this.filterStagedAtTimestampLte = filterStagedAtTimestampLte.isNull() ? null : (filterStagedAtTimestampLte.isEmpty() ? Optional.empty() : Optional.of(filterStagedAtTimestampLte.get()));
            return this;
        }

        @JsonSetter(value="filter_opened_at_timestamp_gte", nulls=Nulls.SKIP)
        public Builder filterOpenedAtTimestampGte(Optional<OffsetDateTime> filterOpenedAtTimestampGte) {
            this.filterOpenedAtTimestampGte = filterOpenedAtTimestampGte;
            return this;
        }

        public Builder filterOpenedAtTimestampGte(OffsetDateTime filterOpenedAtTimestampGte) {
            this.filterOpenedAtTimestampGte = Optional.ofNullable(filterOpenedAtTimestampGte);
            return this;
        }

        public Builder filterOpenedAtTimestampGte(Nullable<OffsetDateTime> filterOpenedAtTimestampGte) {
            this.filterOpenedAtTimestampGte = filterOpenedAtTimestampGte.isNull() ? null : (filterOpenedAtTimestampGte.isEmpty() ? Optional.empty() : Optional.of(filterOpenedAtTimestampGte.get()));
            return this;
        }

        @JsonSetter(value="filter_opened_at_timestamp_lte", nulls=Nulls.SKIP)
        public Builder filterOpenedAtTimestampLte(Optional<OffsetDateTime> filterOpenedAtTimestampLte) {
            this.filterOpenedAtTimestampLte = filterOpenedAtTimestampLte;
            return this;
        }

        public Builder filterOpenedAtTimestampLte(OffsetDateTime filterOpenedAtTimestampLte) {
            this.filterOpenedAtTimestampLte = Optional.ofNullable(filterOpenedAtTimestampLte);
            return this;
        }

        public Builder filterOpenedAtTimestampLte(Nullable<OffsetDateTime> filterOpenedAtTimestampLte) {
            this.filterOpenedAtTimestampLte = filterOpenedAtTimestampLte.isNull() ? null : (filterOpenedAtTimestampLte.isEmpty() ? Optional.empty() : Optional.of(filterOpenedAtTimestampLte.get()));
            return this;
        }

        @JsonSetter(value="filter_paid_at_timestamp_gte", nulls=Nulls.SKIP)
        public Builder filterPaidAtTimestampGte(Optional<OffsetDateTime> filterPaidAtTimestampGte) {
            this.filterPaidAtTimestampGte = filterPaidAtTimestampGte;
            return this;
        }

        public Builder filterPaidAtTimestampGte(OffsetDateTime filterPaidAtTimestampGte) {
            this.filterPaidAtTimestampGte = Optional.ofNullable(filterPaidAtTimestampGte);
            return this;
        }

        public Builder filterPaidAtTimestampGte(Nullable<OffsetDateTime> filterPaidAtTimestampGte) {
            this.filterPaidAtTimestampGte = filterPaidAtTimestampGte.isNull() ? null : (filterPaidAtTimestampGte.isEmpty() ? Optional.empty() : Optional.of(filterPaidAtTimestampGte.get()));
            return this;
        }

        @JsonSetter(value="filter_paid_at_timestamp_lte", nulls=Nulls.SKIP)
        public Builder filterPaidAtTimestampLte(Optional<OffsetDateTime> filterPaidAtTimestampLte) {
            this.filterPaidAtTimestampLte = filterPaidAtTimestampLte;
            return this;
        }

        public Builder filterPaidAtTimestampLte(OffsetDateTime filterPaidAtTimestampLte) {
            this.filterPaidAtTimestampLte = Optional.ofNullable(filterPaidAtTimestampLte);
            return this;
        }

        public Builder filterPaidAtTimestampLte(Nullable<OffsetDateTime> filterPaidAtTimestampLte) {
            this.filterPaidAtTimestampLte = filterPaidAtTimestampLte.isNull() ? null : (filterPaidAtTimestampLte.isEmpty() ? Optional.empty() : Optional.of(filterPaidAtTimestampLte.get()));
            return this;
        }

        public StatementsListV1Request build() {
            return new StatementsListV1Request(this.filterStatus, this.sortBy, this.sortOrder, this.page, this.pageSize, this.filterSettlementType, this.filterPaymentOriginOrgId, this.filterPaymentDestinationOrgId, this.filterOwnedByOrgId, this.filterStagedAtTimestampGte, this.filterStagedAtTimestampLte, this.filterOpenedAtTimestampGte, this.filterOpenedAtTimestampLte, this.filterPaidAtTimestampGte, this.filterPaidAtTimestampLte, this.additionalProperties);
        }
    }
}

