/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.billing.stripeconnect;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.billing.stripeconnect.AsyncRawStripeConnectClient;
import com.chrt.api.types.CreateStripeConnectAccountRes;
import com.chrt.api.types.StripeConnectAccountOnboardingLinkRes;
import java.util.concurrent.CompletableFuture;

public class AsyncStripeConnectClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawStripeConnectClient rawClient;

    public AsyncStripeConnectClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawStripeConnectClient(clientOptions);
    }

    public AsyncRawStripeConnectClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<CreateStripeConnectAccountRes> createAccountV1() {
        return this.rawClient.createAccountV1().thenApply(response -> (CreateStripeConnectAccountRes)response.body());
    }

    public CompletableFuture<CreateStripeConnectAccountRes> createAccountV1(RequestOptions requestOptions) {
        return this.rawClient.createAccountV1(requestOptions).thenApply(response -> (CreateStripeConnectAccountRes)response.body());
    }

    public CompletableFuture<StripeConnectAccountOnboardingLinkRes> onboardingLinkV1() {
        return this.rawClient.onboardingLinkV1().thenApply(response -> (StripeConnectAccountOnboardingLinkRes)response.body());
    }

    public CompletableFuture<StripeConnectAccountOnboardingLinkRes> onboardingLinkV1(RequestOptions requestOptions) {
        return this.rawClient.onboardingLinkV1(requestOptions).thenApply(response -> (StripeConnectAccountOnboardingLinkRes)response.body());
    }
}

