/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.billing.stripeconnect;

import com.chrt.api.core.ChrtApiApiException;
import com.chrt.api.core.ChrtApiException;
import com.chrt.api.core.ChrtApiHttpResponse;
import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.types.CreateStripeConnectAccountRes;
import com.chrt.api.types.StripeConnectAccountOnboardingLinkRes;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawStripeConnectClient {
    protected final ClientOptions clientOptions;

    public RawStripeConnectClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public ChrtApiHttpResponse<CreateStripeConnectAccountRes> createAccountV1() {
        return this.createAccountV1(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChrtApiHttpResponse<CreateStripeConnectAccountRes> createAccountV1(RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("billing/stripe_connect/create_account/v1").build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", RequestBody.create((String)"", null)).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (!response.isSuccessful()) throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            ChrtApiHttpResponse<CreateStripeConnectAccountRes> chrtApiHttpResponse = new ChrtApiHttpResponse<CreateStripeConnectAccountRes>((CreateStripeConnectAccountRes)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, CreateStripeConnectAccountRes.class), response);
            return chrtApiHttpResponse;
        }
        catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }

    public ChrtApiHttpResponse<StripeConnectAccountOnboardingLinkRes> onboardingLinkV1() {
        return this.onboardingLinkV1(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChrtApiHttpResponse<StripeConnectAccountOnboardingLinkRes> onboardingLinkV1(RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("billing/stripe_connect/account_onboarding_link/v1").build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", RequestBody.create((String)"", null)).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (!response.isSuccessful()) throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            ChrtApiHttpResponse<StripeConnectAccountOnboardingLinkRes> chrtApiHttpResponse = new ChrtApiHttpResponse<StripeConnectAccountOnboardingLinkRes>((StripeConnectAccountOnboardingLinkRes)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, StripeConnectAccountOnboardingLinkRes.class), response);
            return chrtApiHttpResponse;
        }
        catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }
}

