/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.cargos;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.cargos.AsyncRawCargosClient;
import com.chrt.api.types.CargoClientUpdate1;
import java.util.concurrent.CompletableFuture;

public class AsyncCargosClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawCargosClient rawClient;

    public AsyncCargosClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawCargosClient(clientOptions);
    }

    public AsyncRawCargosClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<String> updateV1(String cargoId) {
        return this.rawClient.updateV1(cargoId).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<String> updateV1(String cargoId, CargoClientUpdate1 request) {
        return this.rawClient.updateV1(cargoId, request).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<String> updateV1(String cargoId, CargoClientUpdate1 request, RequestOptions requestOptions) {
        return this.rawClient.updateV1(cargoId, request, requestOptions).thenApply(response -> (String)response.body());
    }
}

