/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.connections;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.core.Suppliers;
import com.chrt.api.resources.connections.AsyncRawConnectionsClient;
import com.chrt.api.resources.connections.connectiontocourier.AsyncConnectionToCourierClient;
import com.chrt.api.resources.connections.connectiontoforwarder.AsyncConnectionToForwarderClient;
import com.chrt.api.resources.connections.connectiontoshipper.AsyncConnectionToShipperClient;
import com.chrt.api.resources.connections.types.ConnectionsGetByHandleV1Response;
import com.chrt.api.types.CourierConnectionRes;
import com.chrt.api.types.ForwarderConnectionRes;
import com.chrt.api.types.ShipperConnectionRes;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class AsyncConnectionsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawConnectionsClient rawClient;
    protected final Supplier<AsyncConnectionToCourierClient> connectionToCourierClient;
    protected final Supplier<AsyncConnectionToShipperClient> connectionToShipperClient;
    protected final Supplier<AsyncConnectionToForwarderClient> connectionToForwarderClient;

    public AsyncConnectionsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawConnectionsClient(clientOptions);
        this.connectionToCourierClient = Suppliers.memoize(() -> new AsyncConnectionToCourierClient(clientOptions));
        this.connectionToShipperClient = Suppliers.memoize(() -> new AsyncConnectionToShipperClient(clientOptions));
        this.connectionToForwarderClient = Suppliers.memoize(() -> new AsyncConnectionToForwarderClient(clientOptions));
    }

    public AsyncRawConnectionsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<List<ShipperConnectionRes>> listShippersV1() {
        return this.rawClient.listShippersV1().thenApply(response -> (List)response.body());
    }

    public CompletableFuture<List<ShipperConnectionRes>> listShippersV1(RequestOptions requestOptions) {
        return this.rawClient.listShippersV1(requestOptions).thenApply(response -> (List)response.body());
    }

    public CompletableFuture<List<CourierConnectionRes>> listCouriersV1() {
        return this.rawClient.listCouriersV1().thenApply(response -> (List)response.body());
    }

    public CompletableFuture<List<CourierConnectionRes>> listCouriersV1(RequestOptions requestOptions) {
        return this.rawClient.listCouriersV1(requestOptions).thenApply(response -> (List)response.body());
    }

    public CompletableFuture<List<ForwarderConnectionRes>> listForwardersV1() {
        return this.rawClient.listForwardersV1().thenApply(response -> (List)response.body());
    }

    public CompletableFuture<List<ForwarderConnectionRes>> listForwardersV1(RequestOptions requestOptions) {
        return this.rawClient.listForwardersV1(requestOptions).thenApply(response -> (List)response.body());
    }

    public CompletableFuture<Optional<ConnectionsGetByHandleV1Response>> getByHandleV1(String handle) {
        return this.rawClient.getByHandleV1(handle).thenApply(response -> (Optional)response.body());
    }

    public CompletableFuture<Optional<ConnectionsGetByHandleV1Response>> getByHandleV1(String handle, RequestOptions requestOptions) {
        return this.rawClient.getByHandleV1(handle, requestOptions).thenApply(response -> (Optional)response.body());
    }

    public AsyncConnectionToCourierClient connectionToCourier() {
        return this.connectionToCourierClient.get();
    }

    public AsyncConnectionToShipperClient connectionToShipper() {
        return this.connectionToShipperClient.get();
    }

    public AsyncConnectionToForwarderClient connectionToForwarder() {
        return this.connectionToForwarderClient.get();
    }
}

