/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.dev;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.dev.AsyncRawDevClient;
import com.chrt.api.resources.dev.requests.TemplateReq;
import com.chrt.api.types.DecodedJwtWithOrgAndUserId;
import com.chrt.api.types.TemplateRes;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class AsyncDevClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawDevClient rawClient;

    public AsyncDevClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawDevClient(clientOptions);
    }

    public AsyncRawDevClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<String> getAgentV1() {
        return this.rawClient.getAgentV1().thenApply(response -> (String)response.body());
    }

    public CompletableFuture<String> getAgentV1(RequestOptions requestOptions) {
        return this.rawClient.getAgentV1(requestOptions).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<String> getUserIdV1() {
        return this.rawClient.getUserIdV1().thenApply(response -> (String)response.body());
    }

    public CompletableFuture<String> getUserIdV1(RequestOptions requestOptions) {
        return this.rawClient.getUserIdV1(requestOptions).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<String> getUserIdV2() {
        return this.rawClient.getUserIdV2().thenApply(response -> (String)response.body());
    }

    public CompletableFuture<String> getUserIdV2(RequestOptions requestOptions) {
        return this.rawClient.getUserIdV2(requestOptions).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<DecodedJwtWithOrgAndUserId> getDecodedJwtV1() {
        return this.rawClient.getDecodedJwtV1().thenApply(response -> (DecodedJwtWithOrgAndUserId)response.body());
    }

    public CompletableFuture<DecodedJwtWithOrgAndUserId> getDecodedJwtV1(RequestOptions requestOptions) {
        return this.rawClient.getDecodedJwtV1(requestOptions).thenApply(response -> (DecodedJwtWithOrgAndUserId)response.body());
    }

    public CompletableFuture<String> getEmailV1() {
        return this.rawClient.getEmailV1().thenApply(response -> (String)response.body());
    }

    public CompletableFuture<String> getEmailV1(RequestOptions requestOptions) {
        return this.rawClient.getEmailV1(requestOptions).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<Map<String, Object>> getDurableV1() {
        return this.rawClient.getDurableV1().thenApply(response -> (Map)response.body());
    }

    public CompletableFuture<Map<String, Object>> getDurableV1(RequestOptions requestOptions) {
        return this.rawClient.getDurableV1(requestOptions).thenApply(response -> (Map)response.body());
    }

    public CompletableFuture<String> getTemplateV1() {
        return this.rawClient.getTemplateV1().thenApply(response -> (String)response.body());
    }

    public CompletableFuture<String> getTemplateV1(RequestOptions requestOptions) {
        return this.rawClient.getTemplateV1(requestOptions).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<TemplateRes> createTemplateV1(TemplateReq request) {
        return this.rawClient.createTemplateV1(request).thenApply(response -> (TemplateRes)response.body());
    }

    public CompletableFuture<TemplateRes> createTemplateV1(TemplateReq request, RequestOptions requestOptions) {
        return this.rawClient.createTemplateV1(request, requestOptions).thenApply(response -> (TemplateRes)response.body());
    }

    public CompletableFuture<Map<String, String>> getGitInfoV1() {
        return this.rawClient.getGitInfoV1().thenApply(response -> (Map)response.body());
    }

    public CompletableFuture<Map<String, String>> getGitInfoV1(RequestOptions requestOptions) {
        return this.rawClient.getGitInfoV1(requestOptions).thenApply(response -> (Map)response.body());
    }
}

