/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.dev;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.dev.RawDevClient;
import com.chrt.api.resources.dev.requests.TemplateReq;
import com.chrt.api.types.DecodedJwtWithOrgAndUserId;
import com.chrt.api.types.TemplateRes;
import java.util.Map;

public class DevClient {
    protected final ClientOptions clientOptions;
    private final RawDevClient rawClient;

    public DevClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawDevClient(clientOptions);
    }

    public RawDevClient withRawResponse() {
        return this.rawClient;
    }

    public String getAgentV1() {
        return this.rawClient.getAgentV1().body();
    }

    public String getAgentV1(RequestOptions requestOptions) {
        return this.rawClient.getAgentV1(requestOptions).body();
    }

    public String getUserIdV1() {
        return this.rawClient.getUserIdV1().body();
    }

    public String getUserIdV1(RequestOptions requestOptions) {
        return this.rawClient.getUserIdV1(requestOptions).body();
    }

    public String getUserIdV2() {
        return this.rawClient.getUserIdV2().body();
    }

    public String getUserIdV2(RequestOptions requestOptions) {
        return this.rawClient.getUserIdV2(requestOptions).body();
    }

    public DecodedJwtWithOrgAndUserId getDecodedJwtV1() {
        return this.rawClient.getDecodedJwtV1().body();
    }

    public DecodedJwtWithOrgAndUserId getDecodedJwtV1(RequestOptions requestOptions) {
        return this.rawClient.getDecodedJwtV1(requestOptions).body();
    }

    public String getEmailV1() {
        return this.rawClient.getEmailV1().body();
    }

    public String getEmailV1(RequestOptions requestOptions) {
        return this.rawClient.getEmailV1(requestOptions).body();
    }

    public Map<String, Object> getDurableV1() {
        return this.rawClient.getDurableV1().body();
    }

    public Map<String, Object> getDurableV1(RequestOptions requestOptions) {
        return this.rawClient.getDurableV1(requestOptions).body();
    }

    public String getTemplateV1() {
        return this.rawClient.getTemplateV1().body();
    }

    public String getTemplateV1(RequestOptions requestOptions) {
        return this.rawClient.getTemplateV1(requestOptions).body();
    }

    public TemplateRes createTemplateV1(TemplateReq request) {
        return this.rawClient.createTemplateV1(request).body();
    }

    public TemplateRes createTemplateV1(TemplateReq request, RequestOptions requestOptions) {
        return this.rawClient.createTemplateV1(request, requestOptions).body();
    }

    public Map<String, String> getGitInfoV1() {
        return this.rawClient.getGitInfoV1().body();
    }

    public Map<String, String> getGitInfoV1(RequestOptions requestOptions) {
        return this.rawClient.getGitInfoV1(requestOptions).body();
    }
}

