/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.drivers;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.drivers.RawDriversClient;
import com.chrt.api.resources.drivers.requests.DriverClientCreate1;
import com.chrt.api.resources.drivers.requests.DriverClientUpdate1;
import com.chrt.api.resources.drivers.requests.DriversListOrgMembersAndDriversV1Request;
import com.chrt.api.resources.drivers.requests.DriversListV1Request;
import com.chrt.api.types.Driver1;
import com.chrt.api.types.DriverUpdateAvailabilityReq;
import com.chrt.api.types.OrgMembersAndDrivers;
import java.util.List;

public class DriversClient {
    protected final ClientOptions clientOptions;
    private final RawDriversClient rawClient;

    public DriversClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawDriversClient(clientOptions);
    }

    public RawDriversClient withRawResponse() {
        return this.rawClient;
    }

    public Driver1 getForCallerV1() {
        return this.rawClient.getForCallerV1().body();
    }

    public Driver1 getForCallerV1(RequestOptions requestOptions) {
        return this.rawClient.getForCallerV1(requestOptions).body();
    }

    public Driver1 getByDriverIdV1(String driverId) {
        return this.rawClient.getByDriverIdV1(driverId).body();
    }

    public Driver1 getByDriverIdV1(String driverId, RequestOptions requestOptions) {
        return this.rawClient.getByDriverIdV1(driverId, requestOptions).body();
    }

    public List<OrgMembersAndDrivers> listOrgMembersAndDriversV1() {
        return this.rawClient.listOrgMembersAndDriversV1().body();
    }

    public List<OrgMembersAndDrivers> listOrgMembersAndDriversV1(DriversListOrgMembersAndDriversV1Request request) {
        return this.rawClient.listOrgMembersAndDriversV1(request).body();
    }

    public List<OrgMembersAndDrivers> listOrgMembersAndDriversV1(DriversListOrgMembersAndDriversV1Request request, RequestOptions requestOptions) {
        return this.rawClient.listOrgMembersAndDriversV1(request, requestOptions).body();
    }

    public List<Driver1> listV1() {
        return this.rawClient.listV1().body();
    }

    public List<Driver1> listV1(DriversListV1Request request) {
        return this.rawClient.listV1(request).body();
    }

    public List<Driver1> listV1(DriversListV1Request request, RequestOptions requestOptions) {
        return this.rawClient.listV1(request, requestOptions).body();
    }

    public String createV1(DriverClientCreate1 request) {
        return this.rawClient.createV1(request).body();
    }

    public String createV1(DriverClientCreate1 request, RequestOptions requestOptions) {
        return this.rawClient.createV1(request, requestOptions).body();
    }

    public boolean updateV1(String driverId) {
        return this.rawClient.updateV1(driverId).body();
    }

    public boolean updateV1(String driverId, DriverClientUpdate1 request) {
        return this.rawClient.updateV1(driverId, request).body();
    }

    public boolean updateV1(String driverId, DriverClientUpdate1 request, RequestOptions requestOptions) {
        return this.rawClient.updateV1(driverId, request, requestOptions).body();
    }

    public boolean clearLastSeenV1() {
        return this.rawClient.clearLastSeenV1().body();
    }

    public boolean clearLastSeenV1(RequestOptions requestOptions) {
        return this.rawClient.clearLastSeenV1(requestOptions).body();
    }

    public boolean updateAvailabilityAccordingToDriverV1(DriverUpdateAvailabilityReq request) {
        return this.rawClient.updateAvailabilityAccordingToDriverV1(request).body();
    }

    public boolean updateAvailabilityAccordingToDriverV1(DriverUpdateAvailabilityReq request, RequestOptions requestOptions) {
        return this.rawClient.updateAvailabilityAccordingToDriverV1(request, requestOptions).body();
    }

    public boolean updateAvailabilityAccordingToOperatorsV1(String driverId, DriverUpdateAvailabilityReq request) {
        return this.rawClient.updateAvailabilityAccordingToOperatorsV1(driverId, request).body();
    }

    public boolean updateAvailabilityAccordingToOperatorsV1(String driverId, DriverUpdateAvailabilityReq request, RequestOptions requestOptions) {
        return this.rawClient.updateAvailabilityAccordingToOperatorsV1(driverId, request, requestOptions).body();
    }
}

