/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.drivers;

import com.chrt.api.core.ChrtApiApiException;
import com.chrt.api.core.ChrtApiException;
import com.chrt.api.core.ChrtApiHttpResponse;
import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.MediaTypes;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.core.QueryStringMapper;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.errors.UnprocessableEntityError;
import com.chrt.api.resources.drivers.requests.DriverClientCreate1;
import com.chrt.api.resources.drivers.requests.DriverClientUpdate1;
import com.chrt.api.resources.drivers.requests.DriversListOrgMembersAndDriversV1Request;
import com.chrt.api.resources.drivers.requests.DriversListV1Request;
import com.chrt.api.types.Driver1;
import com.chrt.api.types.DriverUpdateAvailabilityReq;
import com.chrt.api.types.HttpValidationError;
import com.chrt.api.types.OrgMembersAndDrivers;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.List;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawDriversClient {
    protected final ClientOptions clientOptions;

    public RawDriversClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public ChrtApiHttpResponse<Driver1> getForCallerV1() {
        return this.getForCallerV1(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChrtApiHttpResponse<Driver1> getForCallerV1(RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("oort/drivers/for_caller/v1").build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (!response.isSuccessful()) throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            ChrtApiHttpResponse<Driver1> chrtApiHttpResponse = new ChrtApiHttpResponse<Driver1>((Driver1)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Driver1.class), response);
            return chrtApiHttpResponse;
        }
        catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }

    public ChrtApiHttpResponse<Driver1> getByDriverIdV1(String driverId) {
        return this.getByDriverIdV1(driverId, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChrtApiHttpResponse<Driver1> getByDriverIdV1(String driverId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("oort/drivers/v1").addPathSegment(driverId).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            String responseBodyString;
            ResponseBody responseBody = response.body();
            String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                ChrtApiHttpResponse<Driver1> chrtApiHttpResponse = new ChrtApiHttpResponse<Driver1>((Driver1)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Driver1.class), response);
                return chrtApiHttpResponse;
            }
            try {
                if (response.code() != 422) throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                throw new UnprocessableEntityError((HttpValidationError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }

    public ChrtApiHttpResponse<List<OrgMembersAndDrivers>> listOrgMembersAndDriversV1() {
        return this.listOrgMembersAndDriversV1(DriversListOrgMembersAndDriversV1Request.builder().build());
    }

    public ChrtApiHttpResponse<List<OrgMembersAndDrivers>> listOrgMembersAndDriversV1(DriversListOrgMembersAndDriversV1Request request) {
        return this.listOrgMembersAndDriversV1(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChrtApiHttpResponse<List<OrgMembersAndDrivers>> listOrgMembersAndDriversV1(DriversListOrgMembersAndDriversV1Request request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("oort/drivers/org_members_and_drivers/list/v1");
        if (request.getAvailableAccordingToDriver().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "available_according_to_driver", request.getAvailableAccordingToDriver().get(), false);
        }
        if (request.getAvailableAccordingToOperators().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "available_according_to_operators", request.getAvailableAccordingToOperators().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            String responseBodyString;
            ResponseBody responseBody = response.body();
            String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                ChrtApiHttpResponse<List<OrgMembersAndDrivers>> chrtApiHttpResponse = new ChrtApiHttpResponse<List<OrgMembersAndDrivers>>((List)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, (TypeReference)new TypeReference<List<OrgMembersAndDrivers>>(){}), response);
                return chrtApiHttpResponse;
            }
            try {
                if (response.code() != 422) throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                throw new UnprocessableEntityError((HttpValidationError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }

    public ChrtApiHttpResponse<List<Driver1>> listV1() {
        return this.listV1(DriversListV1Request.builder().build());
    }

    public ChrtApiHttpResponse<List<Driver1>> listV1(DriversListV1Request request) {
        return this.listV1(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChrtApiHttpResponse<List<Driver1>> listV1(DriversListV1Request request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("oort/drivers/list/v1");
        if (request.getAvailableAccordingToDriver().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "available_according_to_driver", request.getAvailableAccordingToDriver().get(), false);
        }
        if (request.getAvailableAccordingToOperators().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "available_according_to_operators", request.getAvailableAccordingToOperators().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            String responseBodyString;
            ResponseBody responseBody = response.body();
            String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                ChrtApiHttpResponse<List<Driver1>> chrtApiHttpResponse = new ChrtApiHttpResponse<List<Driver1>>((List)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, (TypeReference)new TypeReference<List<Driver1>>(){}), response);
                return chrtApiHttpResponse;
            }
            try {
                if (response.code() != 422) throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                throw new UnprocessableEntityError((HttpValidationError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }

    public ChrtApiHttpResponse<String> createV1(DriverClientCreate1 request) {
        return this.createV1(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChrtApiHttpResponse<String> createV1(DriverClientCreate1 request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("oort/drivers/create/v1");
        if (request.getTargetUserId().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "target_user_id", request.getTargetUserId().get(), false);
        }
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            String responseBodyString;
            ResponseBody responseBody = response.body();
            String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                ChrtApiHttpResponse<String> chrtApiHttpResponse = new ChrtApiHttpResponse<String>((String)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, String.class), response);
                return chrtApiHttpResponse;
            }
            try {
                if (response.code() != 422) throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                throw new UnprocessableEntityError((HttpValidationError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }

    public ChrtApiHttpResponse<Boolean> updateV1(String driverId) {
        return this.updateV1(driverId, DriverClientUpdate1.builder().build());
    }

    public ChrtApiHttpResponse<Boolean> updateV1(String driverId, DriverClientUpdate1 request) {
        return this.updateV1(driverId, request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChrtApiHttpResponse<Boolean> updateV1(String driverId, DriverClientUpdate1 request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("oort/drivers/update/v1").addPathSegment(driverId).build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new ChrtApiException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("PATCH", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            String responseBodyString;
            ResponseBody responseBody = response.body();
            String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                ChrtApiHttpResponse<Boolean> chrtApiHttpResponse = new ChrtApiHttpResponse<Boolean>((Boolean)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Boolean.TYPE), response);
                return chrtApiHttpResponse;
            }
            try {
                if (response.code() != 422) throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                throw new UnprocessableEntityError((HttpValidationError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }

    public ChrtApiHttpResponse<Boolean> clearLastSeenV1() {
        return this.clearLastSeenV1(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChrtApiHttpResponse<Boolean> clearLastSeenV1(RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("oort/drivers/last_seen/clear/v1").build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", RequestBody.create((String)"", null)).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (!response.isSuccessful()) throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            ChrtApiHttpResponse<Boolean> chrtApiHttpResponse = new ChrtApiHttpResponse<Boolean>((Boolean)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Boolean.TYPE), response);
            return chrtApiHttpResponse;
        }
        catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }

    public ChrtApiHttpResponse<Boolean> updateAvailabilityAccordingToDriverV1(DriverUpdateAvailabilityReq request) {
        return this.updateAvailabilityAccordingToDriverV1(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChrtApiHttpResponse<Boolean> updateAvailabilityAccordingToDriverV1(DriverUpdateAvailabilityReq request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("oort/drivers/update_availability/according_to_driver/v1").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new ChrtApiException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("PATCH", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            String responseBodyString;
            ResponseBody responseBody = response.body();
            String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                ChrtApiHttpResponse<Boolean> chrtApiHttpResponse = new ChrtApiHttpResponse<Boolean>((Boolean)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Boolean.TYPE), response);
                return chrtApiHttpResponse;
            }
            try {
                if (response.code() != 422) throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                throw new UnprocessableEntityError((HttpValidationError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }

    public ChrtApiHttpResponse<Boolean> updateAvailabilityAccordingToOperatorsV1(String driverId, DriverUpdateAvailabilityReq request) {
        return this.updateAvailabilityAccordingToOperatorsV1(driverId, request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChrtApiHttpResponse<Boolean> updateAvailabilityAccordingToOperatorsV1(String driverId, DriverUpdateAvailabilityReq request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("oort/drivers/update_availability/according_to_operators/v1").addPathSegment(driverId).build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new ChrtApiException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("PATCH", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            String responseBodyString;
            ResponseBody responseBody = response.body();
            String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                ChrtApiHttpResponse<Boolean> chrtApiHttpResponse = new ChrtApiHttpResponse<Boolean>((Boolean)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Boolean.TYPE), response);
                return chrtApiHttpResponse;
            }
            try {
                if (response.code() != 422) throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                throw new UnprocessableEntityError((HttpValidationError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }
}

