/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.drivers.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.VehicleTypeEnum;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DriverClientCreate1 {
    private final Optional<String> targetUserId;
    private final int schemaVersion;
    private final Optional<String> emailAddressPrimary;
    private final Optional<String> emailAddressSecondary;
    private final Optional<String> phoneNumberPrimary;
    private final Optional<String> phoneNumberSecondary;
    private final Optional<String> firstName;
    private final Optional<String> lastName;
    private final Optional<List<VehicleTypeEnum>> vehicleTypes;
    private final Map<String, Object> additionalProperties;

    private DriverClientCreate1(Optional<String> targetUserId, int schemaVersion, Optional<String> emailAddressPrimary, Optional<String> emailAddressSecondary, Optional<String> phoneNumberPrimary, Optional<String> phoneNumberSecondary, Optional<String> firstName, Optional<String> lastName, Optional<List<VehicleTypeEnum>> vehicleTypes, Map<String, Object> additionalProperties) {
        this.targetUserId = targetUserId;
        this.schemaVersion = schemaVersion;
        this.emailAddressPrimary = emailAddressPrimary;
        this.emailAddressSecondary = emailAddressSecondary;
        this.phoneNumberPrimary = phoneNumberPrimary;
        this.phoneNumberSecondary = phoneNumberSecondary;
        this.firstName = firstName;
        this.lastName = lastName;
        this.vehicleTypes = vehicleTypes;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getTargetUserId() {
        if (this.targetUserId == null) {
            return Optional.empty();
        }
        return this.targetUserId;
    }

    @JsonProperty(value="schema_version")
    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    @JsonIgnore
    public Optional<String> getEmailAddressPrimary() {
        if (this.emailAddressPrimary == null) {
            return Optional.empty();
        }
        return this.emailAddressPrimary;
    }

    @JsonIgnore
    public Optional<String> getEmailAddressSecondary() {
        if (this.emailAddressSecondary == null) {
            return Optional.empty();
        }
        return this.emailAddressSecondary;
    }

    @JsonIgnore
    public Optional<String> getPhoneNumberPrimary() {
        if (this.phoneNumberPrimary == null) {
            return Optional.empty();
        }
        return this.phoneNumberPrimary;
    }

    @JsonIgnore
    public Optional<String> getPhoneNumberSecondary() {
        if (this.phoneNumberSecondary == null) {
            return Optional.empty();
        }
        return this.phoneNumberSecondary;
    }

    @JsonIgnore
    public Optional<String> getFirstName() {
        if (this.firstName == null) {
            return Optional.empty();
        }
        return this.firstName;
    }

    @JsonIgnore
    public Optional<String> getLastName() {
        if (this.lastName == null) {
            return Optional.empty();
        }
        return this.lastName;
    }

    @JsonProperty(value="vehicle_types")
    public Optional<List<VehicleTypeEnum>> getVehicleTypes() {
        return this.vehicleTypes;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="target_user_id")
    private Optional<String> _getTargetUserId() {
        return this.targetUserId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="email_address_primary")
    private Optional<String> _getEmailAddressPrimary() {
        return this.emailAddressPrimary;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="email_address_secondary")
    private Optional<String> _getEmailAddressSecondary() {
        return this.emailAddressSecondary;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="phone_number_primary")
    private Optional<String> _getPhoneNumberPrimary() {
        return this.phoneNumberPrimary;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="phone_number_secondary")
    private Optional<String> _getPhoneNumberSecondary() {
        return this.phoneNumberSecondary;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="first_name")
    private Optional<String> _getFirstName() {
        return this.firstName;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="last_name")
    private Optional<String> _getLastName() {
        return this.lastName;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DriverClientCreate1 && this.equalTo((DriverClientCreate1)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DriverClientCreate1 other) {
        return this.targetUserId.equals(other.targetUserId) && this.schemaVersion == other.schemaVersion && this.emailAddressPrimary.equals(other.emailAddressPrimary) && this.emailAddressSecondary.equals(other.emailAddressSecondary) && this.phoneNumberPrimary.equals(other.phoneNumberPrimary) && this.phoneNumberSecondary.equals(other.phoneNumberSecondary) && this.firstName.equals(other.firstName) && this.lastName.equals(other.lastName) && this.vehicleTypes.equals(other.vehicleTypes);
    }

    public int hashCode() {
        return Objects.hash(this.targetUserId, this.schemaVersion, this.emailAddressPrimary, this.emailAddressSecondary, this.phoneNumberPrimary, this.phoneNumberSecondary, this.firstName, this.lastName, this.vehicleTypes);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SchemaVersionStage,
    _FinalStage {
        private int schemaVersion;
        private Optional<List<VehicleTypeEnum>> vehicleTypes = Optional.empty();
        private Optional<String> lastName = Optional.empty();
        private Optional<String> firstName = Optional.empty();
        private Optional<String> phoneNumberSecondary = Optional.empty();
        private Optional<String> phoneNumberPrimary = Optional.empty();
        private Optional<String> emailAddressSecondary = Optional.empty();
        private Optional<String> emailAddressPrimary = Optional.empty();
        private Optional<String> targetUserId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(DriverClientCreate1 other) {
            this.targetUserId(other.getTargetUserId());
            this.schemaVersion(other.getSchemaVersion());
            this.emailAddressPrimary(other.getEmailAddressPrimary());
            this.emailAddressSecondary(other.getEmailAddressSecondary());
            this.phoneNumberPrimary(other.getPhoneNumberPrimary());
            this.phoneNumberSecondary(other.getPhoneNumberSecondary());
            this.firstName(other.getFirstName());
            this.lastName(other.getLastName());
            this.vehicleTypes(other.getVehicleTypes());
            return this;
        }

        @Override
        @JsonSetter(value="schema_version")
        public _FinalStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @Override
        public _FinalStage vehicleTypes(List<VehicleTypeEnum> vehicleTypes) {
            this.vehicleTypes = Optional.ofNullable(vehicleTypes);
            return this;
        }

        @Override
        @JsonSetter(value="vehicle_types", nulls=Nulls.SKIP)
        public _FinalStage vehicleTypes(Optional<List<VehicleTypeEnum>> vehicleTypes) {
            this.vehicleTypes = vehicleTypes;
            return this;
        }

        @Override
        public _FinalStage lastName(Nullable<String> lastName) {
            this.lastName = lastName.isNull() ? null : (lastName.isEmpty() ? Optional.empty() : Optional.of(lastName.get()));
            return this;
        }

        @Override
        public _FinalStage lastName(String lastName) {
            this.lastName = Optional.ofNullable(lastName);
            return this;
        }

        @Override
        @JsonSetter(value="last_name", nulls=Nulls.SKIP)
        public _FinalStage lastName(Optional<String> lastName) {
            this.lastName = lastName;
            return this;
        }

        @Override
        public _FinalStage firstName(Nullable<String> firstName) {
            this.firstName = firstName.isNull() ? null : (firstName.isEmpty() ? Optional.empty() : Optional.of(firstName.get()));
            return this;
        }

        @Override
        public _FinalStage firstName(String firstName) {
            this.firstName = Optional.ofNullable(firstName);
            return this;
        }

        @Override
        @JsonSetter(value="first_name", nulls=Nulls.SKIP)
        public _FinalStage firstName(Optional<String> firstName) {
            this.firstName = firstName;
            return this;
        }

        @Override
        public _FinalStage phoneNumberSecondary(Nullable<String> phoneNumberSecondary) {
            this.phoneNumberSecondary = phoneNumberSecondary.isNull() ? null : (phoneNumberSecondary.isEmpty() ? Optional.empty() : Optional.of(phoneNumberSecondary.get()));
            return this;
        }

        @Override
        public _FinalStage phoneNumberSecondary(String phoneNumberSecondary) {
            this.phoneNumberSecondary = Optional.ofNullable(phoneNumberSecondary);
            return this;
        }

        @Override
        @JsonSetter(value="phone_number_secondary", nulls=Nulls.SKIP)
        public _FinalStage phoneNumberSecondary(Optional<String> phoneNumberSecondary) {
            this.phoneNumberSecondary = phoneNumberSecondary;
            return this;
        }

        @Override
        public _FinalStage phoneNumberPrimary(Nullable<String> phoneNumberPrimary) {
            this.phoneNumberPrimary = phoneNumberPrimary.isNull() ? null : (phoneNumberPrimary.isEmpty() ? Optional.empty() : Optional.of(phoneNumberPrimary.get()));
            return this;
        }

        @Override
        public _FinalStage phoneNumberPrimary(String phoneNumberPrimary) {
            this.phoneNumberPrimary = Optional.ofNullable(phoneNumberPrimary);
            return this;
        }

        @Override
        @JsonSetter(value="phone_number_primary", nulls=Nulls.SKIP)
        public _FinalStage phoneNumberPrimary(Optional<String> phoneNumberPrimary) {
            this.phoneNumberPrimary = phoneNumberPrimary;
            return this;
        }

        @Override
        public _FinalStage emailAddressSecondary(Nullable<String> emailAddressSecondary) {
            this.emailAddressSecondary = emailAddressSecondary.isNull() ? null : (emailAddressSecondary.isEmpty() ? Optional.empty() : Optional.of(emailAddressSecondary.get()));
            return this;
        }

        @Override
        public _FinalStage emailAddressSecondary(String emailAddressSecondary) {
            this.emailAddressSecondary = Optional.ofNullable(emailAddressSecondary);
            return this;
        }

        @Override
        @JsonSetter(value="email_address_secondary", nulls=Nulls.SKIP)
        public _FinalStage emailAddressSecondary(Optional<String> emailAddressSecondary) {
            this.emailAddressSecondary = emailAddressSecondary;
            return this;
        }

        @Override
        public _FinalStage emailAddressPrimary(Nullable<String> emailAddressPrimary) {
            this.emailAddressPrimary = emailAddressPrimary.isNull() ? null : (emailAddressPrimary.isEmpty() ? Optional.empty() : Optional.of(emailAddressPrimary.get()));
            return this;
        }

        @Override
        public _FinalStage emailAddressPrimary(String emailAddressPrimary) {
            this.emailAddressPrimary = Optional.ofNullable(emailAddressPrimary);
            return this;
        }

        @Override
        @JsonSetter(value="email_address_primary", nulls=Nulls.SKIP)
        public _FinalStage emailAddressPrimary(Optional<String> emailAddressPrimary) {
            this.emailAddressPrimary = emailAddressPrimary;
            return this;
        }

        @Override
        public _FinalStage targetUserId(Nullable<String> targetUserId) {
            this.targetUserId = targetUserId.isNull() ? null : (targetUserId.isEmpty() ? Optional.empty() : Optional.of(targetUserId.get()));
            return this;
        }

        @Override
        public _FinalStage targetUserId(String targetUserId) {
            this.targetUserId = Optional.ofNullable(targetUserId);
            return this;
        }

        @Override
        @JsonSetter(value="target_user_id", nulls=Nulls.SKIP)
        public _FinalStage targetUserId(Optional<String> targetUserId) {
            this.targetUserId = targetUserId;
            return this;
        }

        @Override
        public DriverClientCreate1 build() {
            return new DriverClientCreate1(this.targetUserId, this.schemaVersion, this.emailAddressPrimary, this.emailAddressSecondary, this.phoneNumberPrimary, this.phoneNumberSecondary, this.firstName, this.lastName, this.vehicleTypes, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public DriverClientCreate1 build();

        public _FinalStage targetUserId(Optional<String> var1);

        public _FinalStage targetUserId(String var1);

        public _FinalStage targetUserId(Nullable<String> var1);

        public _FinalStage emailAddressPrimary(Optional<String> var1);

        public _FinalStage emailAddressPrimary(String var1);

        public _FinalStage emailAddressPrimary(Nullable<String> var1);

        public _FinalStage emailAddressSecondary(Optional<String> var1);

        public _FinalStage emailAddressSecondary(String var1);

        public _FinalStage emailAddressSecondary(Nullable<String> var1);

        public _FinalStage phoneNumberPrimary(Optional<String> var1);

        public _FinalStage phoneNumberPrimary(String var1);

        public _FinalStage phoneNumberPrimary(Nullable<String> var1);

        public _FinalStage phoneNumberSecondary(Optional<String> var1);

        public _FinalStage phoneNumberSecondary(String var1);

        public _FinalStage phoneNumberSecondary(Nullable<String> var1);

        public _FinalStage firstName(Optional<String> var1);

        public _FinalStage firstName(String var1);

        public _FinalStage firstName(Nullable<String> var1);

        public _FinalStage lastName(Optional<String> var1);

        public _FinalStage lastName(String var1);

        public _FinalStage lastName(Nullable<String> var1);

        public _FinalStage vehicleTypes(Optional<List<VehicleTypeEnum>> var1);

        public _FinalStage vehicleTypes(List<VehicleTypeEnum> var1);
    }

    public static interface SchemaVersionStage {
        public _FinalStage schemaVersion(int var1);

        public Builder from(DriverClientCreate1 var1);
    }
}

