/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.flights;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.flights.AsyncRawFlightsClient;
import com.chrt.api.types.FlightInfoForTaskRes;
import java.util.concurrent.CompletableFuture;

public class AsyncFlightsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawFlightsClient rawClient;

    public AsyncFlightsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawFlightsClient(clientOptions);
    }

    public AsyncRawFlightsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<FlightInfoForTaskRes> getFlightInfoForTaskV1(String taskId) {
        return this.rawClient.getFlightInfoForTaskV1(taskId).thenApply(response -> (FlightInfoForTaskRes)response.body());
    }

    public CompletableFuture<FlightInfoForTaskRes> getFlightInfoForTaskV1(String taskId, RequestOptions requestOptions) {
        return this.rawClient.getFlightInfoForTaskV1(taskId, requestOptions).thenApply(response -> (FlightInfoForTaskRes)response.body());
    }
}

