/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.flights;

import com.chrt.api.core.ChrtApiApiException;
import com.chrt.api.core.ChrtApiException;
import com.chrt.api.core.ChrtApiHttpResponse;
import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.errors.UnprocessableEntityError;
import com.chrt.api.types.FlightInfoForTaskRes;
import com.chrt.api.types.HttpValidationError;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawFlightsClient {
    protected final ClientOptions clientOptions;

    public RawFlightsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public ChrtApiHttpResponse<FlightInfoForTaskRes> getFlightInfoForTaskV1(String taskId) {
        return this.getFlightInfoForTaskV1(taskId, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChrtApiHttpResponse<FlightInfoForTaskRes> getFlightInfoForTaskV1(String taskId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("flights/flight_info/for_task/v1").addPathSegment(taskId).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            String responseBodyString;
            ResponseBody responseBody = response.body();
            String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                ChrtApiHttpResponse<FlightInfoForTaskRes> chrtApiHttpResponse = new ChrtApiHttpResponse<FlightInfoForTaskRes>((FlightInfoForTaskRes)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, FlightInfoForTaskRes.class), response);
                return chrtApiHttpResponse;
            }
            try {
                if (response.code() != 422) throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                throw new UnprocessableEntityError((HttpValidationError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }
}

