/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.orderdrafts;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.core.Suppliers;
import com.chrt.api.resources.orderdrafts.RawOrderDraftsClient;
import com.chrt.api.resources.orderdrafts.cargo.CargoClient;
import com.chrt.api.resources.orderdrafts.expanded.ExpandedClient;
import com.chrt.api.resources.orderdrafts.requests.OrdersDraftUpdateReq;
import com.chrt.api.resources.orderdrafts.requests.OrdersNewDraftReq;
import com.chrt.api.resources.orderdrafts.task.TaskClient;
import com.chrt.api.resources.orderdrafts.taskartifact.TaskArtifactClient;
import com.chrt.api.resources.orderdrafts.taskgroup.TaskGroupClient;
import com.chrt.api.types.OrdersDraftUpdateRes;
import com.chrt.api.types.OrdersNewDraftRes;
import java.util.function.Supplier;

public class OrderDraftsClient {
    protected final ClientOptions clientOptions;
    private final RawOrderDraftsClient rawClient;
    protected final Supplier<TaskGroupClient> taskGroupClient;
    protected final Supplier<TaskClient> taskClient;
    protected final Supplier<TaskArtifactClient> taskArtifactClient;
    protected final Supplier<CargoClient> cargoClient;
    protected final Supplier<ExpandedClient> expandedClient;

    public OrderDraftsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawOrderDraftsClient(clientOptions);
        this.taskGroupClient = Suppliers.memoize(() -> new TaskGroupClient(clientOptions));
        this.taskClient = Suppliers.memoize(() -> new TaskClient(clientOptions));
        this.taskArtifactClient = Suppliers.memoize(() -> new TaskArtifactClient(clientOptions));
        this.cargoClient = Suppliers.memoize(() -> new CargoClient(clientOptions));
        this.expandedClient = Suppliers.memoize(() -> new ExpandedClient(clientOptions));
    }

    public RawOrderDraftsClient withRawResponse() {
        return this.rawClient;
    }

    public OrdersNewDraftRes newV1() {
        return this.rawClient.newV1().body();
    }

    public OrdersNewDraftRes newV1(OrdersNewDraftReq request) {
        return this.rawClient.newV1(request).body();
    }

    public OrdersNewDraftRes newV1(OrdersNewDraftReq request, RequestOptions requestOptions) {
        return this.rawClient.newV1(request, requestOptions).body();
    }

    public OrdersDraftUpdateRes updateV1(OrdersDraftUpdateReq request) {
        return this.rawClient.updateV1(request).body();
    }

    public OrdersDraftUpdateRes updateV1(OrdersDraftUpdateReq request, RequestOptions requestOptions) {
        return this.rawClient.updateV1(request, requestOptions).body();
    }

    public boolean deleteV1(String orderId) {
        return this.rawClient.deleteV1(orderId).body();
    }

    public boolean deleteV1(String orderId, RequestOptions requestOptions) {
        return this.rawClient.deleteV1(orderId, requestOptions).body();
    }

    public boolean validateV1(String orderId) {
        return this.rawClient.validateV1(orderId).body();
    }

    public boolean validateV1(String orderId, RequestOptions requestOptions) {
        return this.rawClient.validateV1(orderId, requestOptions).body();
    }

    public TaskGroupClient taskGroup() {
        return this.taskGroupClient.get();
    }

    public TaskClient task() {
        return this.taskClient.get();
    }

    public TaskArtifactClient taskArtifact() {
        return this.taskArtifactClient.get();
    }

    public CargoClient cargo() {
        return this.cargoClient.get();
    }

    public ExpandedClient expanded() {
        return this.expandedClient.get();
    }
}

