/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.orderdrafts.expanded;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.orderdrafts.expanded.AsyncRawExpandedClient;
import com.chrt.api.resources.orderdrafts.expanded.requests.ExpandedListV1Request;
import com.chrt.api.types.OrderAndTaskGroupExpandedReq;
import com.chrt.api.types.OrderDraftExpanded;
import com.chrt.api.types.OrderDraftExpandedListRes;
import java.util.concurrent.CompletableFuture;

public class AsyncExpandedClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawExpandedClient rawClient;

    public AsyncExpandedClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawExpandedClient(clientOptions);
    }

    public AsyncRawExpandedClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<OrderDraftExpanded> retrieveV1(String orderIdOrShortId) {
        return this.rawClient.retrieveV1(orderIdOrShortId).thenApply(response -> (OrderDraftExpanded)response.body());
    }

    public CompletableFuture<OrderDraftExpanded> retrieveV1(String orderIdOrShortId, OrderAndTaskGroupExpandedReq request) {
        return this.rawClient.retrieveV1(orderIdOrShortId, request).thenApply(response -> (OrderDraftExpanded)response.body());
    }

    public CompletableFuture<OrderDraftExpanded> retrieveV1(String orderIdOrShortId, OrderAndTaskGroupExpandedReq request, RequestOptions requestOptions) {
        return this.rawClient.retrieveV1(orderIdOrShortId, request, requestOptions).thenApply(response -> (OrderDraftExpanded)response.body());
    }

    public CompletableFuture<OrderDraftExpandedListRes> listV1(ExpandedListV1Request request) {
        return this.rawClient.listV1(request).thenApply(response -> (OrderDraftExpandedListRes)response.body());
    }

    public CompletableFuture<OrderDraftExpandedListRes> listV1(ExpandedListV1Request request, RequestOptions requestOptions) {
        return this.rawClient.listV1(request, requestOptions).thenApply(response -> (OrderDraftExpandedListRes)response.body());
    }
}

