/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.orderdrafts.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class OrdersDraftUpdateReq {
    private final String orderId;
    private final Optional<String> forwarderOrgId;
    private final Optional<String> shipperOrgId;
    private final Optional<String> offChrtShipperOrgId;
    private final Map<String, Object> additionalProperties;

    private OrdersDraftUpdateReq(String orderId, Optional<String> forwarderOrgId, Optional<String> shipperOrgId, Optional<String> offChrtShipperOrgId, Map<String, Object> additionalProperties) {
        this.orderId = orderId;
        this.forwarderOrgId = forwarderOrgId;
        this.shipperOrgId = shipperOrgId;
        this.offChrtShipperOrgId = offChrtShipperOrgId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="order_id")
    public String getOrderId() {
        return this.orderId;
    }

    @JsonIgnore
    public Optional<String> getForwarderOrgId() {
        if (this.forwarderOrgId == null) {
            return Optional.empty();
        }
        return this.forwarderOrgId;
    }

    @JsonIgnore
    public Optional<String> getShipperOrgId() {
        if (this.shipperOrgId == null) {
            return Optional.empty();
        }
        return this.shipperOrgId;
    }

    @JsonIgnore
    public Optional<String> getOffChrtShipperOrgId() {
        if (this.offChrtShipperOrgId == null) {
            return Optional.empty();
        }
        return this.offChrtShipperOrgId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="forwarder_org_id")
    private Optional<String> _getForwarderOrgId() {
        return this.forwarderOrgId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="shipper_org_id")
    private Optional<String> _getShipperOrgId() {
        return this.shipperOrgId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="off_chrt_shipper_org_id")
    private Optional<String> _getOffChrtShipperOrgId() {
        return this.offChrtShipperOrgId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof OrdersDraftUpdateReq && this.equalTo((OrdersDraftUpdateReq)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OrdersDraftUpdateReq other) {
        return this.orderId.equals(other.orderId) && this.forwarderOrgId.equals(other.forwarderOrgId) && this.shipperOrgId.equals(other.shipperOrgId) && this.offChrtShipperOrgId.equals(other.offChrtShipperOrgId);
    }

    public int hashCode() {
        return Objects.hash(this.orderId, this.forwarderOrgId, this.shipperOrgId, this.offChrtShipperOrgId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static OrderIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements OrderIdStage,
    _FinalStage {
        private String orderId;
        private Optional<String> offChrtShipperOrgId = Optional.empty();
        private Optional<String> shipperOrgId = Optional.empty();
        private Optional<String> forwarderOrgId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(OrdersDraftUpdateReq other) {
            this.orderId(other.getOrderId());
            this.forwarderOrgId(other.getForwarderOrgId());
            this.shipperOrgId(other.getShipperOrgId());
            this.offChrtShipperOrgId(other.getOffChrtShipperOrgId());
            return this;
        }

        @Override
        @JsonSetter(value="order_id")
        public _FinalStage orderId(@NotNull String orderId) {
            this.orderId = Objects.requireNonNull(orderId, "orderId must not be null");
            return this;
        }

        @Override
        public _FinalStage offChrtShipperOrgId(Nullable<String> offChrtShipperOrgId) {
            this.offChrtShipperOrgId = offChrtShipperOrgId.isNull() ? null : (offChrtShipperOrgId.isEmpty() ? Optional.empty() : Optional.of(offChrtShipperOrgId.get()));
            return this;
        }

        @Override
        public _FinalStage offChrtShipperOrgId(String offChrtShipperOrgId) {
            this.offChrtShipperOrgId = Optional.ofNullable(offChrtShipperOrgId);
            return this;
        }

        @Override
        @JsonSetter(value="off_chrt_shipper_org_id", nulls=Nulls.SKIP)
        public _FinalStage offChrtShipperOrgId(Optional<String> offChrtShipperOrgId) {
            this.offChrtShipperOrgId = offChrtShipperOrgId;
            return this;
        }

        @Override
        public _FinalStage shipperOrgId(Nullable<String> shipperOrgId) {
            this.shipperOrgId = shipperOrgId.isNull() ? null : (shipperOrgId.isEmpty() ? Optional.empty() : Optional.of(shipperOrgId.get()));
            return this;
        }

        @Override
        public _FinalStage shipperOrgId(String shipperOrgId) {
            this.shipperOrgId = Optional.ofNullable(shipperOrgId);
            return this;
        }

        @Override
        @JsonSetter(value="shipper_org_id", nulls=Nulls.SKIP)
        public _FinalStage shipperOrgId(Optional<String> shipperOrgId) {
            this.shipperOrgId = shipperOrgId;
            return this;
        }

        @Override
        public _FinalStage forwarderOrgId(Nullable<String> forwarderOrgId) {
            this.forwarderOrgId = forwarderOrgId.isNull() ? null : (forwarderOrgId.isEmpty() ? Optional.empty() : Optional.of(forwarderOrgId.get()));
            return this;
        }

        @Override
        public _FinalStage forwarderOrgId(String forwarderOrgId) {
            this.forwarderOrgId = Optional.ofNullable(forwarderOrgId);
            return this;
        }

        @Override
        @JsonSetter(value="forwarder_org_id", nulls=Nulls.SKIP)
        public _FinalStage forwarderOrgId(Optional<String> forwarderOrgId) {
            this.forwarderOrgId = forwarderOrgId;
            return this;
        }

        @Override
        public OrdersDraftUpdateReq build() {
            return new OrdersDraftUpdateReq(this.orderId, this.forwarderOrgId, this.shipperOrgId, this.offChrtShipperOrgId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public OrdersDraftUpdateReq build();

        public _FinalStage forwarderOrgId(Optional<String> var1);

        public _FinalStage forwarderOrgId(String var1);

        public _FinalStage forwarderOrgId(Nullable<String> var1);

        public _FinalStage shipperOrgId(Optional<String> var1);

        public _FinalStage shipperOrgId(String var1);

        public _FinalStage shipperOrgId(Nullable<String> var1);

        public _FinalStage offChrtShipperOrgId(Optional<String> var1);

        public _FinalStage offChrtShipperOrgId(String var1);

        public _FinalStage offChrtShipperOrgId(Nullable<String> var1);
    }

    public static interface OrderIdStage {
        public _FinalStage orderId(@NotNull String var1);

        public Builder from(OrdersDraftUpdateReq var1);
    }
}

