/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.orderdrafts.taskgroup;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.orderdrafts.taskgroup.AsyncRawTaskGroupClient;
import com.chrt.api.resources.orderdrafts.taskgroup.requests.OrderDraftAddTaskGroupReq;
import com.chrt.api.resources.orderdrafts.taskgroup.requests.SetRateSheetsReq;
import com.chrt.api.resources.orderdrafts.taskgroup.requests.SetServiceTypeReq;
import com.chrt.api.resources.orderdrafts.taskgroup.requests.SetTaskOrderingDraftReq;
import com.chrt.api.resources.orderdrafts.taskgroup.requests.UpdateCourierOrgDraftReq;
import com.chrt.api.types.SetFlightInfoReq;
import java.util.concurrent.CompletableFuture;

public class AsyncTaskGroupClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawTaskGroupClient rawClient;

    public AsyncTaskGroupClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawTaskGroupClient(clientOptions);
    }

    public AsyncRawTaskGroupClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<String> addV1(OrderDraftAddTaskGroupReq request) {
        return this.rawClient.addV1(request).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<String> addV1(OrderDraftAddTaskGroupReq request, RequestOptions requestOptions) {
        return this.rawClient.addV1(request, requestOptions).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<Boolean> setFlightInfoV1(String taskGroupId) {
        return this.rawClient.setFlightInfoV1(taskGroupId).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> setFlightInfoV1(String taskGroupId, SetFlightInfoReq request) {
        return this.rawClient.setFlightInfoV1(taskGroupId, request).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> setFlightInfoV1(String taskGroupId, SetFlightInfoReq request, RequestOptions requestOptions) {
        return this.rawClient.setFlightInfoV1(taskGroupId, request, requestOptions).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> updateCourierOrgV1(String taskGroupId, UpdateCourierOrgDraftReq request) {
        return this.rawClient.updateCourierOrgV1(taskGroupId, request).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> updateCourierOrgV1(String taskGroupId, UpdateCourierOrgDraftReq request, RequestOptions requestOptions) {
        return this.rawClient.updateCourierOrgV1(taskGroupId, request, requestOptions).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> removeCourierOrgV1(String taskGroupId) {
        return this.rawClient.removeCourierOrgV1(taskGroupId).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> removeCourierOrgV1(String taskGroupId, RequestOptions requestOptions) {
        return this.rawClient.removeCourierOrgV1(taskGroupId, requestOptions).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> setTaskOrderingV1(String taskGroupId, SetTaskOrderingDraftReq request) {
        return this.rawClient.setTaskOrderingV1(taskGroupId, request).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> setTaskOrderingV1(String taskGroupId, SetTaskOrderingDraftReq request, RequestOptions requestOptions) {
        return this.rawClient.setTaskOrderingV1(taskGroupId, request, requestOptions).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> setRateSheetsV1(String taskGroupId) {
        return this.rawClient.setRateSheetsV1(taskGroupId).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> setRateSheetsV1(String taskGroupId, SetRateSheetsReq request) {
        return this.rawClient.setRateSheetsV1(taskGroupId, request).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> setRateSheetsV1(String taskGroupId, SetRateSheetsReq request, RequestOptions requestOptions) {
        return this.rawClient.setRateSheetsV1(taskGroupId, request, requestOptions).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> setServiceTypeV1(String taskGroupId, SetServiceTypeReq request) {
        return this.rawClient.setServiceTypeV1(taskGroupId, request).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> setServiceTypeV1(String taskGroupId, SetServiceTypeReq request, RequestOptions requestOptions) {
        return this.rawClient.setServiceTypeV1(taskGroupId, request, requestOptions).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> deleteV1(String taskGroupId) {
        return this.rawClient.deleteV1(taskGroupId).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> deleteV1(String taskGroupId, RequestOptions requestOptions) {
        return this.rawClient.deleteV1(taskGroupId, requestOptions).thenApply(response -> (Boolean)response.body());
    }
}

