/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.orderdrafts.taskgroup.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.ServiceTypeEnum1;
import com.chrt.api.types.TaskGroupTypeEnum1;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class OrderDraftAddTaskGroupReq {
    private final TaskGroupTypeEnum1 taskGroupType;
    private final String orderId;
    private final Optional<String> courierOrgId;
    private final Optional<ServiceTypeEnum1> serviceType;
    private final Map<String, Object> additionalProperties;

    private OrderDraftAddTaskGroupReq(TaskGroupTypeEnum1 taskGroupType, String orderId, Optional<String> courierOrgId, Optional<ServiceTypeEnum1> serviceType, Map<String, Object> additionalProperties) {
        this.taskGroupType = taskGroupType;
        this.orderId = orderId;
        this.courierOrgId = courierOrgId;
        this.serviceType = serviceType;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="task_group_type")
    public TaskGroupTypeEnum1 getTaskGroupType() {
        return this.taskGroupType;
    }

    @JsonProperty(value="order_id")
    public String getOrderId() {
        return this.orderId;
    }

    @JsonIgnore
    public Optional<String> getCourierOrgId() {
        if (this.courierOrgId == null) {
            return Optional.empty();
        }
        return this.courierOrgId;
    }

    @JsonIgnore
    public Optional<ServiceTypeEnum1> getServiceType() {
        if (this.serviceType == null) {
            return Optional.empty();
        }
        return this.serviceType;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="courier_org_id")
    private Optional<String> _getCourierOrgId() {
        return this.courierOrgId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="service_type")
    private Optional<ServiceTypeEnum1> _getServiceType() {
        return this.serviceType;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof OrderDraftAddTaskGroupReq && this.equalTo((OrderDraftAddTaskGroupReq)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OrderDraftAddTaskGroupReq other) {
        return this.taskGroupType.equals(other.taskGroupType) && this.orderId.equals(other.orderId) && this.courierOrgId.equals(other.courierOrgId) && this.serviceType.equals(other.serviceType);
    }

    public int hashCode() {
        return Objects.hash(this.taskGroupType, this.orderId, this.courierOrgId, this.serviceType);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TaskGroupTypeStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TaskGroupTypeStage,
    OrderIdStage,
    _FinalStage {
        private TaskGroupTypeEnum1 taskGroupType;
        private String orderId;
        private Optional<ServiceTypeEnum1> serviceType = Optional.empty();
        private Optional<String> courierOrgId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(OrderDraftAddTaskGroupReq other) {
            this.taskGroupType(other.getTaskGroupType());
            this.orderId(other.getOrderId());
            this.courierOrgId(other.getCourierOrgId());
            this.serviceType(other.getServiceType());
            return this;
        }

        @Override
        @JsonSetter(value="task_group_type")
        public OrderIdStage taskGroupType(@NotNull TaskGroupTypeEnum1 taskGroupType) {
            this.taskGroupType = Objects.requireNonNull(taskGroupType, "taskGroupType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="order_id")
        public _FinalStage orderId(@NotNull String orderId) {
            this.orderId = Objects.requireNonNull(orderId, "orderId must not be null");
            return this;
        }

        @Override
        public _FinalStage serviceType(Nullable<ServiceTypeEnum1> serviceType) {
            this.serviceType = serviceType.isNull() ? null : (serviceType.isEmpty() ? Optional.empty() : Optional.of(serviceType.get()));
            return this;
        }

        @Override
        public _FinalStage serviceType(ServiceTypeEnum1 serviceType) {
            this.serviceType = Optional.ofNullable(serviceType);
            return this;
        }

        @Override
        @JsonSetter(value="service_type", nulls=Nulls.SKIP)
        public _FinalStage serviceType(Optional<ServiceTypeEnum1> serviceType) {
            this.serviceType = serviceType;
            return this;
        }

        @Override
        public _FinalStage courierOrgId(Nullable<String> courierOrgId) {
            this.courierOrgId = courierOrgId.isNull() ? null : (courierOrgId.isEmpty() ? Optional.empty() : Optional.of(courierOrgId.get()));
            return this;
        }

        @Override
        public _FinalStage courierOrgId(String courierOrgId) {
            this.courierOrgId = Optional.ofNullable(courierOrgId);
            return this;
        }

        @Override
        @JsonSetter(value="courier_org_id", nulls=Nulls.SKIP)
        public _FinalStage courierOrgId(Optional<String> courierOrgId) {
            this.courierOrgId = courierOrgId;
            return this;
        }

        @Override
        public OrderDraftAddTaskGroupReq build() {
            return new OrderDraftAddTaskGroupReq(this.taskGroupType, this.orderId, this.courierOrgId, this.serviceType, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public OrderDraftAddTaskGroupReq build();

        public _FinalStage courierOrgId(Optional<String> var1);

        public _FinalStage courierOrgId(String var1);

        public _FinalStage courierOrgId(Nullable<String> var1);

        public _FinalStage serviceType(Optional<ServiceTypeEnum1> var1);

        public _FinalStage serviceType(ServiceTypeEnum1 var1);

        public _FinalStage serviceType(Nullable<ServiceTypeEnum1> var1);
    }

    public static interface OrderIdStage {
        public _FinalStage orderId(@NotNull String var1);
    }

    public static interface TaskGroupTypeStage {
        public OrderIdStage taskGroupType(@NotNull TaskGroupTypeEnum1 var1);

        public Builder from(OrderDraftAddTaskGroupReq var1);
    }
}

