/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.orders.expanded;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.orders.expanded.AsyncRawExpandedClient;
import com.chrt.api.resources.orders.expanded.requests.ExpandedListForForwarderOperatorsV1Request;
import com.chrt.api.resources.orders.expanded.requests.ExpandedListForShipperOperatorsV1Request;
import com.chrt.api.types.OrderAndTaskGroupExpandedReq;
import com.chrt.api.types.OrderExpanded;
import com.chrt.api.types.OrdersExpandedListRes;
import java.util.concurrent.CompletableFuture;

public class AsyncExpandedClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawExpandedClient rawClient;

    public AsyncExpandedClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawExpandedClient(clientOptions);
    }

    public AsyncRawExpandedClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<OrderExpanded> forShipperOperatorsV1(String orderIdOrShortId) {
        return this.rawClient.forShipperOperatorsV1(orderIdOrShortId).thenApply(response -> (OrderExpanded)response.body());
    }

    public CompletableFuture<OrderExpanded> forShipperOperatorsV1(String orderIdOrShortId, OrderAndTaskGroupExpandedReq request) {
        return this.rawClient.forShipperOperatorsV1(orderIdOrShortId, request).thenApply(response -> (OrderExpanded)response.body());
    }

    public CompletableFuture<OrderExpanded> forShipperOperatorsV1(String orderIdOrShortId, OrderAndTaskGroupExpandedReq request, RequestOptions requestOptions) {
        return this.rawClient.forShipperOperatorsV1(orderIdOrShortId, request, requestOptions).thenApply(response -> (OrderExpanded)response.body());
    }

    public CompletableFuture<OrderExpanded> forForwarderOperatorsV1(String orderIdOrShortId) {
        return this.rawClient.forForwarderOperatorsV1(orderIdOrShortId).thenApply(response -> (OrderExpanded)response.body());
    }

    public CompletableFuture<OrderExpanded> forForwarderOperatorsV1(String orderIdOrShortId, OrderAndTaskGroupExpandedReq request) {
        return this.rawClient.forForwarderOperatorsV1(orderIdOrShortId, request).thenApply(response -> (OrderExpanded)response.body());
    }

    public CompletableFuture<OrderExpanded> forForwarderOperatorsV1(String orderIdOrShortId, OrderAndTaskGroupExpandedReq request, RequestOptions requestOptions) {
        return this.rawClient.forForwarderOperatorsV1(orderIdOrShortId, request, requestOptions).thenApply(response -> (OrderExpanded)response.body());
    }

    public CompletableFuture<OrdersExpandedListRes> listForForwarderOperatorsV1(ExpandedListForForwarderOperatorsV1Request request) {
        return this.rawClient.listForForwarderOperatorsV1(request).thenApply(response -> (OrdersExpandedListRes)response.body());
    }

    public CompletableFuture<OrdersExpandedListRes> listForForwarderOperatorsV1(ExpandedListForForwarderOperatorsV1Request request, RequestOptions requestOptions) {
        return this.rawClient.listForForwarderOperatorsV1(request, requestOptions).thenApply(response -> (OrdersExpandedListRes)response.body());
    }

    public CompletableFuture<OrdersExpandedListRes> listForShipperOperatorsV1(ExpandedListForShipperOperatorsV1Request request) {
        return this.rawClient.listForShipperOperatorsV1(request).thenApply(response -> (OrdersExpandedListRes)response.body());
    }

    public CompletableFuture<OrdersExpandedListRes> listForShipperOperatorsV1(ExpandedListForShipperOperatorsV1Request request, RequestOptions requestOptions) {
        return this.rawClient.listForShipperOperatorsV1(request, requestOptions).thenApply(response -> (OrdersExpandedListRes)response.body());
    }
}

