/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.orginfoforconnections;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.Suppliers;
import com.chrt.api.resources.orginfoforconnections.courier.AsyncCourierClient;
import com.chrt.api.resources.orginfoforconnections.forwarder.AsyncForwarderClient;
import com.chrt.api.resources.orginfoforconnections.shipper.AsyncShipperClient;
import java.util.function.Supplier;

public class AsyncOrgInfoForConnectionsClient {
    protected final ClientOptions clientOptions;
    protected final Supplier<AsyncShipperClient> shipperClient;
    protected final Supplier<AsyncCourierClient> courierClient;
    protected final Supplier<AsyncForwarderClient> forwarderClient;

    public AsyncOrgInfoForConnectionsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.shipperClient = Suppliers.memoize(() -> new AsyncShipperClient(clientOptions));
        this.courierClient = Suppliers.memoize(() -> new AsyncCourierClient(clientOptions));
        this.forwarderClient = Suppliers.memoize(() -> new AsyncForwarderClient(clientOptions));
    }

    public AsyncShipperClient shipper() {
        return this.shipperClient.get();
    }

    public AsyncCourierClient courier() {
        return this.courierClient.get();
    }

    public AsyncForwarderClient forwarder() {
        return this.forwarderClient.get();
    }
}

