/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.orginfoforconnections.courier;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.orginfoforconnections.courier.AsyncRawCourierClient;
import com.chrt.api.resources.orginfoforconnections.courier.requests.CourierOrgInfoForConnectionsClientCreate1;
import com.chrt.api.resources.orginfoforconnections.courier.requests.CourierOrgInfoForConnectionsClientUpdate1;
import com.chrt.api.types.CourierOrgInfoForConnections1;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class AsyncCourierClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawCourierClient rawClient;

    public AsyncCourierClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawCourierClient(clientOptions);
    }

    public AsyncRawCourierClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<CourierOrgInfoForConnections1> getV1() {
        return this.rawClient.getV1().thenApply(response -> (CourierOrgInfoForConnections1)response.body());
    }

    public CompletableFuture<CourierOrgInfoForConnections1> getV1(RequestOptions requestOptions) {
        return this.rawClient.getV1(requestOptions).thenApply(response -> (CourierOrgInfoForConnections1)response.body());
    }

    public CompletableFuture<List<CourierOrgInfoForConnections1>> listV1() {
        return this.rawClient.listV1().thenApply(response -> (List)response.body());
    }

    public CompletableFuture<List<CourierOrgInfoForConnections1>> listV1(RequestOptions requestOptions) {
        return this.rawClient.listV1(requestOptions).thenApply(response -> (List)response.body());
    }

    public CompletableFuture<String> createV1(CourierOrgInfoForConnectionsClientCreate1 request) {
        return this.rawClient.createV1(request).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<String> createV1(CourierOrgInfoForConnectionsClientCreate1 request, RequestOptions requestOptions) {
        return this.rawClient.createV1(request, requestOptions).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<Boolean> updateV1() {
        return this.rawClient.updateV1().thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> updateV1(CourierOrgInfoForConnectionsClientUpdate1 request) {
        return this.rawClient.updateV1(request).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> updateV1(CourierOrgInfoForConnectionsClientUpdate1 request, RequestOptions requestOptions) {
        return this.rawClient.updateV1(request, requestOptions).thenApply(response -> (Boolean)response.body());
    }
}

