/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.orgs;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.orgs.RawOrgsClient;
import com.chrt.api.resources.orgs.requests.CreateOrgPublicDataReq;
import com.chrt.api.resources.orgs.requests.SetOrgTypeReq;
import com.chrt.api.resources.orgs.requests.UpdateOrgPublicDataReq;
import com.chrt.api.types.CreateOrgPublicDataRes;
import com.chrt.api.types.OrgMemberDetails;
import com.chrt.api.types.OrgPublicData1;
import java.util.List;
import java.util.Map;

public class OrgsClient {
    protected final ClientOptions clientOptions;
    private final RawOrgsClient rawClient;

    public OrgsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawOrgsClient(clientOptions);
    }

    public RawOrgsClient withRawResponse() {
        return this.rawClient;
    }

    public Map<String, Object> getInfoV1() {
        return this.rawClient.getInfoV1().body();
    }

    public Map<String, Object> getInfoV1(RequestOptions requestOptions) {
        return this.rawClient.getInfoV1(requestOptions).body();
    }

    public List<OrgMemberDetails> listMembersV1() {
        return this.rawClient.listMembersV1().body();
    }

    public List<OrgMemberDetails> listMembersV1(RequestOptions requestOptions) {
        return this.rawClient.listMembersV1(requestOptions).body();
    }

    public OrgPublicData1 getOrgPublicDataV1() {
        return this.rawClient.getOrgPublicDataV1().body();
    }

    public OrgPublicData1 getOrgPublicDataV1(RequestOptions requestOptions) {
        return this.rawClient.getOrgPublicDataV1(requestOptions).body();
    }

    public CreateOrgPublicDataRes createOrgPublicDataV1() {
        return this.rawClient.createOrgPublicDataV1().body();
    }

    public CreateOrgPublicDataRes createOrgPublicDataV1(CreateOrgPublicDataReq request) {
        return this.rawClient.createOrgPublicDataV1(request).body();
    }

    public CreateOrgPublicDataRes createOrgPublicDataV1(CreateOrgPublicDataReq request, RequestOptions requestOptions) {
        return this.rawClient.createOrgPublicDataV1(request, requestOptions).body();
    }

    public boolean updateOrgPublicDataV1() {
        return this.rawClient.updateOrgPublicDataV1().body();
    }

    public boolean updateOrgPublicDataV1(UpdateOrgPublicDataReq request) {
        return this.rawClient.updateOrgPublicDataV1(request).body();
    }

    public boolean updateOrgPublicDataV1(UpdateOrgPublicDataReq request, RequestOptions requestOptions) {
        return this.rawClient.updateOrgPublicDataV1(request, requestOptions).body();
    }

    public OrgPublicData1 getOrgPublicDataByOrgIdV1(String orgId) {
        return this.rawClient.getOrgPublicDataByOrgIdV1(orgId).body();
    }

    public OrgPublicData1 getOrgPublicDataByOrgIdV1(String orgId, RequestOptions requestOptions) {
        return this.rawClient.getOrgPublicDataByOrgIdV1(orgId, requestOptions).body();
    }

    public boolean getOrgPublicDataHandleAvailabilityV1(String handle) {
        return this.rawClient.getOrgPublicDataHandleAvailabilityV1(handle).body();
    }

    public boolean getOrgPublicDataHandleAvailabilityV1(String handle, RequestOptions requestOptions) {
        return this.rawClient.getOrgPublicDataHandleAvailabilityV1(handle, requestOptions).body();
    }

    public boolean setOrgTypeV1(SetOrgTypeReq request) {
        return this.rawClient.setOrgTypeV1(request).body();
    }

    public boolean setOrgTypeV1(SetOrgTypeReq request, RequestOptions requestOptions) {
        return this.rawClient.setOrgTypeV1(request, requestOptions).body();
    }

    public String getStripeConnectAccountIdV1() {
        return this.rawClient.getStripeConnectAccountIdV1().body();
    }

    public String getStripeConnectAccountIdV1(RequestOptions requestOptions) {
        return this.rawClient.getStripeConnectAccountIdV1(requestOptions).body();
    }
}

