/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.shippercontactinfo;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.shippercontactinfo.RawShipperContactInfoClient;
import com.chrt.api.resources.shippercontactinfo.requests.ShipperContactClientUpdate1;
import com.chrt.api.types.ShipperContact1;
import com.chrt.api.types.ShipperContactClientCreate1;
import java.util.List;

public class ShipperContactInfoClient {
    protected final ClientOptions clientOptions;
    private final RawShipperContactInfoClient rawClient;

    public ShipperContactInfoClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawShipperContactInfoClient(clientOptions);
    }

    public RawShipperContactInfoClient withRawResponse() {
        return this.rawClient;
    }

    public ShipperContact1 getCallerV1() {
        return this.rawClient.getCallerV1().body();
    }

    public ShipperContact1 getCallerV1(RequestOptions requestOptions) {
        return this.rawClient.getCallerV1(requestOptions).body();
    }

    public List<ShipperContact1> listV1() {
        return this.rawClient.listV1().body();
    }

    public List<ShipperContact1> listV1(RequestOptions requestOptions) {
        return this.rawClient.listV1(requestOptions).body();
    }

    public List<ShipperContact1> listCourierContactsV1(String shipperOrgId) {
        return this.rawClient.listCourierContactsV1(shipperOrgId).body();
    }

    public List<ShipperContact1> listCourierContactsV1(String shipperOrgId, RequestOptions requestOptions) {
        return this.rawClient.listCourierContactsV1(shipperOrgId, requestOptions).body();
    }

    public List<ShipperContact1> listForwarderContactsV1(String shipperOrgId) {
        return this.rawClient.listForwarderContactsV1(shipperOrgId).body();
    }

    public List<ShipperContact1> listForwarderContactsV1(String shipperOrgId, RequestOptions requestOptions) {
        return this.rawClient.listForwarderContactsV1(shipperOrgId, requestOptions).body();
    }

    public List<ShipperContact1> listOffPlatformContactsV1(String offChrtShipperOrgId) {
        return this.rawClient.listOffPlatformContactsV1(offChrtShipperOrgId).body();
    }

    public List<ShipperContact1> listOffPlatformContactsV1(String offChrtShipperOrgId, RequestOptions requestOptions) {
        return this.rawClient.listOffPlatformContactsV1(offChrtShipperOrgId, requestOptions).body();
    }

    public ShipperContact1 getV1(String id) {
        return this.rawClient.getV1(id).body();
    }

    public ShipperContact1 getV1(String id, RequestOptions requestOptions) {
        return this.rawClient.getV1(id, requestOptions).body();
    }

    public String createOnPlatformV1(ShipperContactClientCreate1 request) {
        return this.rawClient.createOnPlatformV1(request).body();
    }

    public String createOnPlatformV1(ShipperContactClientCreate1 request, RequestOptions requestOptions) {
        return this.rawClient.createOnPlatformV1(request, requestOptions).body();
    }

    public String createOffPlatformV1(ShipperContactClientCreate1 request) {
        return this.rawClient.createOffPlatformV1(request).body();
    }

    public String createOffPlatformV1(ShipperContactClientCreate1 request, RequestOptions requestOptions) {
        return this.rawClient.createOffPlatformV1(request, requestOptions).body();
    }

    public boolean updateV1(String shipperContactInfoId) {
        return this.rawClient.updateV1(shipperContactInfoId).body();
    }

    public boolean updateV1(String shipperContactInfoId, ShipperContactClientUpdate1 request) {
        return this.rawClient.updateV1(shipperContactInfoId, request).body();
    }

    public boolean updateV1(String shipperContactInfoId, ShipperContactClientUpdate1 request, RequestOptions requestOptions) {
        return this.rawClient.updateV1(shipperContactInfoId, request, requestOptions).body();
    }

    public boolean deleteV1(String id) {
        return this.rawClient.deleteV1(id).body();
    }

    public boolean deleteV1(String id, RequestOptions requestOptions) {
        return this.rawClient.deleteV1(id, requestOptions).body();
    }
}

