/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.taskartifacts;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.core.Suppliers;
import com.chrt.api.resources.taskartifacts.AsyncRawTaskArtifactsClient;
import com.chrt.api.resources.taskartifacts.requests.AddTaskArtifactReq;
import com.chrt.api.resources.taskartifacts.s3object.AsyncS3ObjectClient;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class AsyncTaskArtifactsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawTaskArtifactsClient rawClient;
    protected final Supplier<AsyncS3ObjectClient> s3ObjectClient;

    public AsyncTaskArtifactsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawTaskArtifactsClient(clientOptions);
        this.s3ObjectClient = Suppliers.memoize(() -> new AsyncS3ObjectClient(clientOptions));
    }

    public AsyncRawTaskArtifactsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<String> addToTaskV1(String taskId, AddTaskArtifactReq request) {
        return this.rawClient.addToTaskV1(taskId, request).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<String> addToTaskV1(String taskId, AddTaskArtifactReq request, RequestOptions requestOptions) {
        return this.rawClient.addToTaskV1(taskId, request, requestOptions).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<Boolean> completeV1(String taskArtifactId) {
        return this.rawClient.completeV1(taskArtifactId).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> completeV1(String taskArtifactId, RequestOptions requestOptions) {
        return this.rawClient.completeV1(taskArtifactId, requestOptions).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> skipV1(String taskArtifactId) {
        return this.rawClient.skipV1(taskArtifactId).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> skipV1(String taskArtifactId, RequestOptions requestOptions) {
        return this.rawClient.skipV1(taskArtifactId, requestOptions).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> deleteV1(String taskArtifactId) {
        return this.rawClient.deleteV1(taskArtifactId).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> deleteV1(String taskArtifactId, RequestOptions requestOptions) {
        return this.rawClient.deleteV1(taskArtifactId, requestOptions).thenApply(response -> (Boolean)response.body());
    }

    public AsyncS3ObjectClient s3Object() {
        return this.s3ObjectClient.get();
    }
}

