/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.taskgroups;

import com.chrt.api.core.ChrtApiApiException;
import com.chrt.api.core.ChrtApiException;
import com.chrt.api.core.ChrtApiHttpResponse;
import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.MediaTypes;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.errors.UnprocessableEntityError;
import com.chrt.api.resources.taskgroups.requests.AddMessageReq;
import com.chrt.api.resources.taskgroups.requests.SetTaskOrderingReq;
import com.chrt.api.resources.taskgroups.requests.UpdateCourierOrgReq;
import com.chrt.api.resources.taskgroups.requests.UpdateDriverReq;
import com.chrt.api.types.HttpValidationError;
import com.chrt.api.types.SetFlightInfoReq;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

public class AsyncRawTaskGroupsClient {
    protected final ClientOptions clientOptions;

    public AsyncRawTaskGroupsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public CompletableFuture<ChrtApiHttpResponse<Boolean>> startV1(String taskGroupId) {
        return this.startV1(taskGroupId, null);
    }

    public CompletableFuture<ChrtApiHttpResponse<Boolean>> startV1(String taskGroupId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("oort/task_groups/start/v1").addPathSegment(taskGroupId).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("PUT", RequestBody.create((String)"", null)).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<ChrtApiHttpResponse<Boolean>> future = new CompletableFuture<ChrtApiHttpResponse<Boolean>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            /*
             * Loose catch block
             */
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try {
                    String responseBodyString;
                    ResponseBody responseBody;
                    block13: {
                        block14: {
                            block11: {
                                block12: {
                                    responseBody = response.body();
                                    String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
                                    if (!response.isSuccessful()) break block11;
                                    future.complete(new ChrtApiHttpResponse<Boolean>((Boolean)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Boolean.TYPE), response));
                                    if (responseBody == null) break block12;
                                    responseBody.close();
                                }
                                return;
                            }
                            if (response.code() != 422) break block13;
                            future.completeExceptionally(new UnprocessableEntityError((HttpValidationError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class), response));
                            if (responseBody == null) break block14;
                            responseBody.close();
                        }
                        return;
                    }
                    try {
                        block15: {
                            break block15;
                            catch (JsonProcessingException jsonProcessingException) {
                                // empty catch block
                            }
                        }
                        future.completeExceptionally(new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                        return;
                    }
                    finally {
                        if (responseBody != null) {
                            responseBody.close();
                        }
                    }
                }
                catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<ChrtApiHttpResponse<Boolean>> setTaskOrderingV1(String taskGroupId, SetTaskOrderingReq request) {
        return this.setTaskOrderingV1(taskGroupId, request, null);
    }

    public CompletableFuture<ChrtApiHttpResponse<Boolean>> setTaskOrderingV1(String taskGroupId, SetTaskOrderingReq request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("oort/task_groups/set_task_ordering/v1").addPathSegment(taskGroupId).build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new ChrtApiException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("PUT", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<ChrtApiHttpResponse<Boolean>> future = new CompletableFuture<ChrtApiHttpResponse<Boolean>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            /*
             * Loose catch block
             */
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try {
                    String responseBodyString;
                    ResponseBody responseBody;
                    block13: {
                        block14: {
                            block11: {
                                block12: {
                                    responseBody = response.body();
                                    String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
                                    if (!response.isSuccessful()) break block11;
                                    future.complete(new ChrtApiHttpResponse<Boolean>((Boolean)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Boolean.TYPE), response));
                                    if (responseBody == null) break block12;
                                    responseBody.close();
                                }
                                return;
                            }
                            if (response.code() != 422) break block13;
                            future.completeExceptionally(new UnprocessableEntityError((HttpValidationError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class), response));
                            if (responseBody == null) break block14;
                            responseBody.close();
                        }
                        return;
                    }
                    try {
                        block15: {
                            break block15;
                            catch (JsonProcessingException jsonProcessingException) {
                                // empty catch block
                            }
                        }
                        future.completeExceptionally(new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                        return;
                    }
                    finally {
                        if (responseBody != null) {
                            responseBody.close();
                        }
                    }
                }
                catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<ChrtApiHttpResponse<Boolean>> updateDriverV1(String taskGroupId, UpdateDriverReq request) {
        return this.updateDriverV1(taskGroupId, request, null);
    }

    public CompletableFuture<ChrtApiHttpResponse<Boolean>> updateDriverV1(String taskGroupId, UpdateDriverReq request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("oort/task_groups/update_driver/v1").addPathSegment(taskGroupId).build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new ChrtApiException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("PATCH", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<ChrtApiHttpResponse<Boolean>> future = new CompletableFuture<ChrtApiHttpResponse<Boolean>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            /*
             * Loose catch block
             */
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try {
                    String responseBodyString;
                    ResponseBody responseBody;
                    block13: {
                        block14: {
                            block11: {
                                block12: {
                                    responseBody = response.body();
                                    String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
                                    if (!response.isSuccessful()) break block11;
                                    future.complete(new ChrtApiHttpResponse<Boolean>((Boolean)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Boolean.TYPE), response));
                                    if (responseBody == null) break block12;
                                    responseBody.close();
                                }
                                return;
                            }
                            if (response.code() != 422) break block13;
                            future.completeExceptionally(new UnprocessableEntityError((HttpValidationError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class), response));
                            if (responseBody == null) break block14;
                            responseBody.close();
                        }
                        return;
                    }
                    try {
                        block15: {
                            break block15;
                            catch (JsonProcessingException jsonProcessingException) {
                                // empty catch block
                            }
                        }
                        future.completeExceptionally(new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                        return;
                    }
                    finally {
                        if (responseBody != null) {
                            responseBody.close();
                        }
                    }
                }
                catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<ChrtApiHttpResponse<Boolean>> removeDriverV1(String taskGroupId) {
        return this.removeDriverV1(taskGroupId, null);
    }

    public CompletableFuture<ChrtApiHttpResponse<Boolean>> removeDriverV1(String taskGroupId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("oort/task_groups/remove_driver/v1").addPathSegment(taskGroupId).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("PATCH", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<ChrtApiHttpResponse<Boolean>> future = new CompletableFuture<ChrtApiHttpResponse<Boolean>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            /*
             * Loose catch block
             */
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try {
                    String responseBodyString;
                    ResponseBody responseBody;
                    block13: {
                        block14: {
                            block11: {
                                block12: {
                                    responseBody = response.body();
                                    String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
                                    if (!response.isSuccessful()) break block11;
                                    future.complete(new ChrtApiHttpResponse<Boolean>((Boolean)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Boolean.TYPE), response));
                                    if (responseBody == null) break block12;
                                    responseBody.close();
                                }
                                return;
                            }
                            if (response.code() != 422) break block13;
                            future.completeExceptionally(new UnprocessableEntityError((HttpValidationError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class), response));
                            if (responseBody == null) break block14;
                            responseBody.close();
                        }
                        return;
                    }
                    try {
                        block15: {
                            break block15;
                            catch (JsonProcessingException jsonProcessingException) {
                                // empty catch block
                            }
                        }
                        future.completeExceptionally(new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                        return;
                    }
                    finally {
                        if (responseBody != null) {
                            responseBody.close();
                        }
                    }
                }
                catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<ChrtApiHttpResponse<Boolean>> updateCourierOrgV1(String taskGroupId, UpdateCourierOrgReq request) {
        return this.updateCourierOrgV1(taskGroupId, request, null);
    }

    public CompletableFuture<ChrtApiHttpResponse<Boolean>> updateCourierOrgV1(String taskGroupId, UpdateCourierOrgReq request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("oort/task_groups/update_courier_org/v1").addPathSegment(taskGroupId).build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new ChrtApiException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("PATCH", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<ChrtApiHttpResponse<Boolean>> future = new CompletableFuture<ChrtApiHttpResponse<Boolean>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            /*
             * Loose catch block
             */
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try {
                    String responseBodyString;
                    ResponseBody responseBody;
                    block13: {
                        block14: {
                            block11: {
                                block12: {
                                    responseBody = response.body();
                                    String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
                                    if (!response.isSuccessful()) break block11;
                                    future.complete(new ChrtApiHttpResponse<Boolean>((Boolean)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Boolean.TYPE), response));
                                    if (responseBody == null) break block12;
                                    responseBody.close();
                                }
                                return;
                            }
                            if (response.code() != 422) break block13;
                            future.completeExceptionally(new UnprocessableEntityError((HttpValidationError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class), response));
                            if (responseBody == null) break block14;
                            responseBody.close();
                        }
                        return;
                    }
                    try {
                        block15: {
                            break block15;
                            catch (JsonProcessingException jsonProcessingException) {
                                // empty catch block
                            }
                        }
                        future.completeExceptionally(new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                        return;
                    }
                    finally {
                        if (responseBody != null) {
                            responseBody.close();
                        }
                    }
                }
                catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<ChrtApiHttpResponse<Boolean>> setFlightInfoV1(String taskGroupId) {
        return this.setFlightInfoV1(taskGroupId, SetFlightInfoReq.builder().build());
    }

    public CompletableFuture<ChrtApiHttpResponse<Boolean>> setFlightInfoV1(String taskGroupId, SetFlightInfoReq request) {
        return this.setFlightInfoV1(taskGroupId, request, null);
    }

    public CompletableFuture<ChrtApiHttpResponse<Boolean>> setFlightInfoV1(String taskGroupId, SetFlightInfoReq request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("oort/task_groups/set_flight_info/v1").addPathSegment(taskGroupId).build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new ChrtApiException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("PATCH", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<ChrtApiHttpResponse<Boolean>> future = new CompletableFuture<ChrtApiHttpResponse<Boolean>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            /*
             * Loose catch block
             */
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try {
                    String responseBodyString;
                    ResponseBody responseBody;
                    block13: {
                        block14: {
                            block11: {
                                block12: {
                                    responseBody = response.body();
                                    String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
                                    if (!response.isSuccessful()) break block11;
                                    future.complete(new ChrtApiHttpResponse<Boolean>((Boolean)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Boolean.TYPE), response));
                                    if (responseBody == null) break block12;
                                    responseBody.close();
                                }
                                return;
                            }
                            if (response.code() != 422) break block13;
                            future.completeExceptionally(new UnprocessableEntityError((HttpValidationError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class), response));
                            if (responseBody == null) break block14;
                            responseBody.close();
                        }
                        return;
                    }
                    try {
                        block15: {
                            break block15;
                            catch (JsonProcessingException jsonProcessingException) {
                                // empty catch block
                            }
                        }
                        future.completeExceptionally(new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                        return;
                    }
                    finally {
                        if (responseBody != null) {
                            responseBody.close();
                        }
                    }
                }
                catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<ChrtApiHttpResponse<Boolean>> addMessageV1(String taskGroupId, AddMessageReq request) {
        return this.addMessageV1(taskGroupId, request, null);
    }

    public CompletableFuture<ChrtApiHttpResponse<Boolean>> addMessageV1(String taskGroupId, AddMessageReq request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("oort/task_groups/add_message/v1").addPathSegment(taskGroupId).build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new ChrtApiException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<ChrtApiHttpResponse<Boolean>> future = new CompletableFuture<ChrtApiHttpResponse<Boolean>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            /*
             * Loose catch block
             */
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try {
                    String responseBodyString;
                    ResponseBody responseBody;
                    block13: {
                        block14: {
                            block11: {
                                block12: {
                                    responseBody = response.body();
                                    String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
                                    if (!response.isSuccessful()) break block11;
                                    future.complete(new ChrtApiHttpResponse<Boolean>((Boolean)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Boolean.TYPE), response));
                                    if (responseBody == null) break block12;
                                    responseBody.close();
                                }
                                return;
                            }
                            if (response.code() != 422) break block13;
                            future.completeExceptionally(new UnprocessableEntityError((HttpValidationError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class), response));
                            if (responseBody == null) break block14;
                            responseBody.close();
                        }
                        return;
                    }
                    try {
                        block15: {
                            break block15;
                            catch (JsonProcessingException jsonProcessingException) {
                                // empty catch block
                            }
                        }
                        future.completeExceptionally(new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                        return;
                    }
                    finally {
                        if (responseBody != null) {
                            responseBody.close();
                        }
                    }
                }
                catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }
}

