/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.taskgroups.expanded;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.taskgroups.expanded.AsyncRawExpandedClient;
import com.chrt.api.resources.taskgroups.expanded.requests.ExpandedListForCourierDriverV1Request;
import com.chrt.api.resources.taskgroups.expanded.requests.ExpandedListForCourierOperatorsV1Request;
import com.chrt.api.types.OrderAndTaskGroupExpandedReq;
import com.chrt.api.types.TaskGroupExpanded;
import com.chrt.api.types.TaskGroupExpandedListRes;
import java.util.concurrent.CompletableFuture;

public class AsyncExpandedClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawExpandedClient rawClient;

    public AsyncExpandedClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawExpandedClient(clientOptions);
    }

    public AsyncRawExpandedClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<TaskGroupExpanded> forCourierOperatorsV1(String taskGroupId) {
        return this.rawClient.forCourierOperatorsV1(taskGroupId).thenApply(response -> (TaskGroupExpanded)response.body());
    }

    public CompletableFuture<TaskGroupExpanded> forCourierOperatorsV1(String taskGroupId, OrderAndTaskGroupExpandedReq request) {
        return this.rawClient.forCourierOperatorsV1(taskGroupId, request).thenApply(response -> (TaskGroupExpanded)response.body());
    }

    public CompletableFuture<TaskGroupExpanded> forCourierOperatorsV1(String taskGroupId, OrderAndTaskGroupExpandedReq request, RequestOptions requestOptions) {
        return this.rawClient.forCourierOperatorsV1(taskGroupId, request, requestOptions).thenApply(response -> (TaskGroupExpanded)response.body());
    }

    public CompletableFuture<TaskGroupExpanded> forCourierDriverV1(String taskGroupId) {
        return this.rawClient.forCourierDriverV1(taskGroupId).thenApply(response -> (TaskGroupExpanded)response.body());
    }

    public CompletableFuture<TaskGroupExpanded> forCourierDriverV1(String taskGroupId, OrderAndTaskGroupExpandedReq request) {
        return this.rawClient.forCourierDriverV1(taskGroupId, request).thenApply(response -> (TaskGroupExpanded)response.body());
    }

    public CompletableFuture<TaskGroupExpanded> forCourierDriverV1(String taskGroupId, OrderAndTaskGroupExpandedReq request, RequestOptions requestOptions) {
        return this.rawClient.forCourierDriverV1(taskGroupId, request, requestOptions).thenApply(response -> (TaskGroupExpanded)response.body());
    }

    public CompletableFuture<TaskGroupExpanded> forShipperOperatorsV1(String taskGroupId) {
        return this.rawClient.forShipperOperatorsV1(taskGroupId).thenApply(response -> (TaskGroupExpanded)response.body());
    }

    public CompletableFuture<TaskGroupExpanded> forShipperOperatorsV1(String taskGroupId, OrderAndTaskGroupExpandedReq request) {
        return this.rawClient.forShipperOperatorsV1(taskGroupId, request).thenApply(response -> (TaskGroupExpanded)response.body());
    }

    public CompletableFuture<TaskGroupExpanded> forShipperOperatorsV1(String taskGroupId, OrderAndTaskGroupExpandedReq request, RequestOptions requestOptions) {
        return this.rawClient.forShipperOperatorsV1(taskGroupId, request, requestOptions).thenApply(response -> (TaskGroupExpanded)response.body());
    }

    public CompletableFuture<TaskGroupExpanded> forForwarderOperatorsV1(String taskGroupId) {
        return this.rawClient.forForwarderOperatorsV1(taskGroupId).thenApply(response -> (TaskGroupExpanded)response.body());
    }

    public CompletableFuture<TaskGroupExpanded> forForwarderOperatorsV1(String taskGroupId, OrderAndTaskGroupExpandedReq request) {
        return this.rawClient.forForwarderOperatorsV1(taskGroupId, request).thenApply(response -> (TaskGroupExpanded)response.body());
    }

    public CompletableFuture<TaskGroupExpanded> forForwarderOperatorsV1(String taskGroupId, OrderAndTaskGroupExpandedReq request, RequestOptions requestOptions) {
        return this.rawClient.forForwarderOperatorsV1(taskGroupId, request, requestOptions).thenApply(response -> (TaskGroupExpanded)response.body());
    }

    public CompletableFuture<TaskGroupExpandedListRes> listForCourierOperatorsV1(ExpandedListForCourierOperatorsV1Request request) {
        return this.rawClient.listForCourierOperatorsV1(request).thenApply(response -> (TaskGroupExpandedListRes)response.body());
    }

    public CompletableFuture<TaskGroupExpandedListRes> listForCourierOperatorsV1(ExpandedListForCourierOperatorsV1Request request, RequestOptions requestOptions) {
        return this.rawClient.listForCourierOperatorsV1(request, requestOptions).thenApply(response -> (TaskGroupExpandedListRes)response.body());
    }

    public CompletableFuture<TaskGroupExpandedListRes> listForCourierDriverV1(ExpandedListForCourierDriverV1Request request) {
        return this.rawClient.listForCourierDriverV1(request).thenApply(response -> (TaskGroupExpandedListRes)response.body());
    }

    public CompletableFuture<TaskGroupExpandedListRes> listForCourierDriverV1(ExpandedListForCourierDriverV1Request request, RequestOptions requestOptions) {
        return this.rawClient.listForCourierDriverV1(request, requestOptions).thenApply(response -> (TaskGroupExpandedListRes)response.body());
    }
}

