/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.taskgroups.expanded;

import com.chrt.api.core.ChrtApiApiException;
import com.chrt.api.core.ChrtApiException;
import com.chrt.api.core.ChrtApiHttpResponse;
import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.MediaTypes;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.core.QueryStringMapper;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.errors.UnprocessableEntityError;
import com.chrt.api.resources.taskgroups.expanded.requests.ExpandedListForCourierDriverV1Request;
import com.chrt.api.resources.taskgroups.expanded.requests.ExpandedListForCourierOperatorsV1Request;
import com.chrt.api.types.HttpValidationError;
import com.chrt.api.types.OrderAndTaskGroupExpandedReq;
import com.chrt.api.types.TaskGroupExpanded;
import com.chrt.api.types.TaskGroupExpandedListRes;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawExpandedClient {
    protected final ClientOptions clientOptions;

    public RawExpandedClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public ChrtApiHttpResponse<TaskGroupExpanded> forCourierOperatorsV1(String taskGroupId) {
        return this.forCourierOperatorsV1(taskGroupId, OrderAndTaskGroupExpandedReq.builder().build());
    }

    public ChrtApiHttpResponse<TaskGroupExpanded> forCourierOperatorsV1(String taskGroupId, OrderAndTaskGroupExpandedReq request) {
        return this.forCourierOperatorsV1(taskGroupId, request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChrtApiHttpResponse<TaskGroupExpanded> forCourierOperatorsV1(String taskGroupId, OrderAndTaskGroupExpandedReq request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("oort/task_groups/expanded/for_courier_operators/v1").addPathSegment(taskGroupId).build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new ChrtApiException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            String responseBodyString;
            ResponseBody responseBody = response.body();
            String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                ChrtApiHttpResponse<TaskGroupExpanded> chrtApiHttpResponse = new ChrtApiHttpResponse<TaskGroupExpanded>((TaskGroupExpanded)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, TaskGroupExpanded.class), response);
                return chrtApiHttpResponse;
            }
            try {
                if (response.code() != 422) throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                throw new UnprocessableEntityError((HttpValidationError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }

    public ChrtApiHttpResponse<TaskGroupExpanded> forCourierDriverV1(String taskGroupId) {
        return this.forCourierDriverV1(taskGroupId, OrderAndTaskGroupExpandedReq.builder().build());
    }

    public ChrtApiHttpResponse<TaskGroupExpanded> forCourierDriverV1(String taskGroupId, OrderAndTaskGroupExpandedReq request) {
        return this.forCourierDriverV1(taskGroupId, request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChrtApiHttpResponse<TaskGroupExpanded> forCourierDriverV1(String taskGroupId, OrderAndTaskGroupExpandedReq request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("oort/task_groups/expanded/for_courier_driver/v1").addPathSegment(taskGroupId).build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new ChrtApiException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            String responseBodyString;
            ResponseBody responseBody = response.body();
            String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                ChrtApiHttpResponse<TaskGroupExpanded> chrtApiHttpResponse = new ChrtApiHttpResponse<TaskGroupExpanded>((TaskGroupExpanded)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, TaskGroupExpanded.class), response);
                return chrtApiHttpResponse;
            }
            try {
                if (response.code() != 422) throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                throw new UnprocessableEntityError((HttpValidationError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }

    public ChrtApiHttpResponse<TaskGroupExpanded> forShipperOperatorsV1(String taskGroupId) {
        return this.forShipperOperatorsV1(taskGroupId, OrderAndTaskGroupExpandedReq.builder().build());
    }

    public ChrtApiHttpResponse<TaskGroupExpanded> forShipperOperatorsV1(String taskGroupId, OrderAndTaskGroupExpandedReq request) {
        return this.forShipperOperatorsV1(taskGroupId, request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChrtApiHttpResponse<TaskGroupExpanded> forShipperOperatorsV1(String taskGroupId, OrderAndTaskGroupExpandedReq request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("oort/task_groups/expanded/for_shipper_operators/v1").addPathSegment(taskGroupId).build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new ChrtApiException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            String responseBodyString;
            ResponseBody responseBody = response.body();
            String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                ChrtApiHttpResponse<TaskGroupExpanded> chrtApiHttpResponse = new ChrtApiHttpResponse<TaskGroupExpanded>((TaskGroupExpanded)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, TaskGroupExpanded.class), response);
                return chrtApiHttpResponse;
            }
            try {
                if (response.code() != 422) throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                throw new UnprocessableEntityError((HttpValidationError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }

    public ChrtApiHttpResponse<TaskGroupExpanded> forForwarderOperatorsV1(String taskGroupId) {
        return this.forForwarderOperatorsV1(taskGroupId, OrderAndTaskGroupExpandedReq.builder().build());
    }

    public ChrtApiHttpResponse<TaskGroupExpanded> forForwarderOperatorsV1(String taskGroupId, OrderAndTaskGroupExpandedReq request) {
        return this.forForwarderOperatorsV1(taskGroupId, request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChrtApiHttpResponse<TaskGroupExpanded> forForwarderOperatorsV1(String taskGroupId, OrderAndTaskGroupExpandedReq request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("oort/task_groups/expanded/for_forwarder_operators/v1").addPathSegment(taskGroupId).build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new ChrtApiException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            String responseBodyString;
            ResponseBody responseBody = response.body();
            String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                ChrtApiHttpResponse<TaskGroupExpanded> chrtApiHttpResponse = new ChrtApiHttpResponse<TaskGroupExpanded>((TaskGroupExpanded)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, TaskGroupExpanded.class), response);
                return chrtApiHttpResponse;
            }
            try {
                if (response.code() != 422) throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                throw new UnprocessableEntityError((HttpValidationError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }

    public ChrtApiHttpResponse<TaskGroupExpandedListRes> listForCourierOperatorsV1(ExpandedListForCourierOperatorsV1Request request) {
        return this.listForCourierOperatorsV1(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChrtApiHttpResponse<TaskGroupExpandedListRes> listForCourierOperatorsV1(ExpandedListForCourierOperatorsV1Request request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("oort/task_groups/expanded/list/for_courier_operators/v1");
        if (request.getSortBy().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "sort_by", request.getSortBy().get(), false);
        }
        if (request.getSortOrder().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "sort_order", request.getSortOrder().get(), false);
        }
        if (request.getPage().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "page", request.getPage().get(), false);
        }
        if (request.getPageSize().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "page_size", request.getPageSize().get(), false);
        }
        if (request.getFilterDraftStartedAtTimestampLte().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_draft_started_at_timestamp_lte", request.getFilterDraftStartedAtTimestampLte().get(), false);
        }
        if (request.getFilterDraftStartedAtTimestampGte().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_draft_started_at_timestamp_gte", request.getFilterDraftStartedAtTimestampGte().get(), false);
        }
        if (request.getFilterStagedAtTimestampLte().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_staged_at_timestamp_lte", request.getFilterStagedAtTimestampLte().get(), false);
        }
        if (request.getFilterStagedAtTimestampGte().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_staged_at_timestamp_gte", request.getFilterStagedAtTimestampGte().get(), false);
        }
        if (request.getFilterInProgressAtTimestampLte().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_in_progress_at_timestamp_lte", request.getFilterInProgressAtTimestampLte().get(), false);
        }
        if (request.getFilterInProgressAtTimestampGte().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_in_progress_at_timestamp_gte", request.getFilterInProgressAtTimestampGte().get(), false);
        }
        if (request.getFilterCompletedAtTimestampLte().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_completed_at_timestamp_lte", request.getFilterCompletedAtTimestampLte().get(), false);
        }
        if (request.getFilterCompletedAtTimestampGte().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_completed_at_timestamp_gte", request.getFilterCompletedAtTimestampGte().get(), false);
        }
        if (request.getFilterSkippedAtTimestampLte().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_skipped_at_timestamp_lte", request.getFilterSkippedAtTimestampLte().get(), false);
        }
        if (request.getFilterSkippedAtTimestampGte().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_skipped_at_timestamp_gte", request.getFilterSkippedAtTimestampGte().get(), false);
        }
        if (request.getFilterExceptionAtTimestampLte().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_exception_at_timestamp_lte", request.getFilterExceptionAtTimestampLte().get(), false);
        }
        if (request.getFilterExceptionAtTimestampGte().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_exception_at_timestamp_gte", request.getFilterExceptionAtTimestampGte().get(), false);
        }
        if (request.getFilterStatus().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_status", request.getFilterStatus().get(), true);
        }
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request.getBody()), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            String responseBodyString;
            ResponseBody responseBody = response.body();
            String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                ChrtApiHttpResponse<TaskGroupExpandedListRes> chrtApiHttpResponse = new ChrtApiHttpResponse<TaskGroupExpandedListRes>((TaskGroupExpandedListRes)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, TaskGroupExpandedListRes.class), response);
                return chrtApiHttpResponse;
            }
            try {
                if (response.code() != 422) throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                throw new UnprocessableEntityError((HttpValidationError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }

    public ChrtApiHttpResponse<TaskGroupExpandedListRes> listForCourierDriverV1(ExpandedListForCourierDriverV1Request request) {
        return this.listForCourierDriverV1(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChrtApiHttpResponse<TaskGroupExpandedListRes> listForCourierDriverV1(ExpandedListForCourierDriverV1Request request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("oort/task_groups/expanded/list/for_courier_driver/v1");
        if (request.getSortBy().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "sort_by", request.getSortBy().get(), false);
        }
        if (request.getSortOrder().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "sort_order", request.getSortOrder().get(), false);
        }
        if (request.getPage().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "page", request.getPage().get(), false);
        }
        if (request.getPageSize().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "page_size", request.getPageSize().get(), false);
        }
        if (request.getFilterDraftStartedAtTimestampLte().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_draft_started_at_timestamp_lte", request.getFilterDraftStartedAtTimestampLte().get(), false);
        }
        if (request.getFilterDraftStartedAtTimestampGte().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_draft_started_at_timestamp_gte", request.getFilterDraftStartedAtTimestampGte().get(), false);
        }
        if (request.getFilterStagedAtTimestampLte().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_staged_at_timestamp_lte", request.getFilterStagedAtTimestampLte().get(), false);
        }
        if (request.getFilterStagedAtTimestampGte().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_staged_at_timestamp_gte", request.getFilterStagedAtTimestampGte().get(), false);
        }
        if (request.getFilterInProgressAtTimestampLte().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_in_progress_at_timestamp_lte", request.getFilterInProgressAtTimestampLte().get(), false);
        }
        if (request.getFilterInProgressAtTimestampGte().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_in_progress_at_timestamp_gte", request.getFilterInProgressAtTimestampGte().get(), false);
        }
        if (request.getFilterCompletedAtTimestampLte().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_completed_at_timestamp_lte", request.getFilterCompletedAtTimestampLte().get(), false);
        }
        if (request.getFilterCompletedAtTimestampGte().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_completed_at_timestamp_gte", request.getFilterCompletedAtTimestampGte().get(), false);
        }
        if (request.getFilterSkippedAtTimestampLte().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_skipped_at_timestamp_lte", request.getFilterSkippedAtTimestampLte().get(), false);
        }
        if (request.getFilterSkippedAtTimestampGte().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_skipped_at_timestamp_gte", request.getFilterSkippedAtTimestampGte().get(), false);
        }
        if (request.getFilterExceptionAtTimestampLte().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_exception_at_timestamp_lte", request.getFilterExceptionAtTimestampLte().get(), false);
        }
        if (request.getFilterExceptionAtTimestampGte().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_exception_at_timestamp_gte", request.getFilterExceptionAtTimestampGte().get(), false);
        }
        if (request.getFilterStatus().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "filter_status", request.getFilterStatus().get(), true);
        }
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request.getBody()), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            String responseBodyString;
            ResponseBody responseBody = response.body();
            String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                ChrtApiHttpResponse<TaskGroupExpandedListRes> chrtApiHttpResponse = new ChrtApiHttpResponse<TaskGroupExpandedListRes>((TaskGroupExpandedListRes)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, TaskGroupExpandedListRes.class), response);
                return chrtApiHttpResponse;
            }
            try {
                if (response.code() != 422) throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                throw new UnprocessableEntityError((HttpValidationError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }
}

