/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.taskgroups.s3object;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.taskgroups.s3object.AsyncRawS3ObjectClient;
import com.chrt.api.resources.taskgroups.s3object.requests.BodyPostTaskGroupsS3ObjectAddV1OortTaskGroupsS3ObjectAddV1TaskGroupIdPost;
import com.chrt.api.types.TaskGroupS3ObjectMetadata1;
import java.io.File;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;

public class AsyncS3ObjectClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawS3ObjectClient rawClient;

    public AsyncS3ObjectClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawS3ObjectClient(clientOptions);
    }

    public AsyncRawS3ObjectClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<TaskGroupS3ObjectMetadata1> getS3ObjectMetadataV1(String taskGroupS3ObjectMetadataId) {
        return this.rawClient.getS3ObjectMetadataV1(taskGroupS3ObjectMetadataId).thenApply(response -> (TaskGroupS3ObjectMetadata1)response.body());
    }

    public CompletableFuture<TaskGroupS3ObjectMetadata1> getS3ObjectMetadataV1(String taskGroupS3ObjectMetadataId, RequestOptions requestOptions) {
        return this.rawClient.getS3ObjectMetadataV1(taskGroupS3ObjectMetadataId, requestOptions).thenApply(response -> (TaskGroupS3ObjectMetadata1)response.body());
    }

    public CompletableFuture<InputStream> getV1(String taskGroupS3ObjectMetadataId) {
        return this.rawClient.getV1(taskGroupS3ObjectMetadataId).thenApply(response -> (InputStream)response.body());
    }

    public CompletableFuture<InputStream> getV1(String taskGroupS3ObjectMetadataId, RequestOptions requestOptions) {
        return this.rawClient.getV1(taskGroupS3ObjectMetadataId, requestOptions).thenApply(response -> (InputStream)response.body());
    }

    public CompletableFuture<Boolean> addV1(String taskGroupId, File image, BodyPostTaskGroupsS3ObjectAddV1OortTaskGroupsS3ObjectAddV1TaskGroupIdPost request) {
        return this.rawClient.addV1(taskGroupId, image, request).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> addV1(String taskGroupId, File image, BodyPostTaskGroupsS3ObjectAddV1OortTaskGroupsS3ObjectAddV1TaskGroupIdPost request, RequestOptions requestOptions) {
        return this.rawClient.addV1(taskGroupId, image, request, requestOptions).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> deleteV1(String taskGroupS3ObjectMetadataId) {
        return this.rawClient.deleteV1(taskGroupS3ObjectMetadataId).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> deleteV1(String taskGroupS3ObjectMetadataId, RequestOptions requestOptions) {
        return this.rawClient.deleteV1(taskGroupS3ObjectMetadataId, requestOptions).thenApply(response -> (Boolean)response.body());
    }
}

