/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.tasks;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.tasks.AsyncRawTasksClient;
import com.chrt.api.resources.tasks.requests.AddTaskToGroupReq;
import com.chrt.api.types.TaskClientUpdate1;
import java.util.concurrent.CompletableFuture;

public class AsyncTasksClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawTasksClient rawClient;

    public AsyncTasksClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawTasksClient(clientOptions);
    }

    public AsyncRawTasksClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<String> addToTaskGroupV1(String taskGroupId, AddTaskToGroupReq request) {
        return this.rawClient.addToTaskGroupV1(taskGroupId, request).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<String> addToTaskGroupV1(String taskGroupId, AddTaskToGroupReq request, RequestOptions requestOptions) {
        return this.rawClient.addToTaskGroupV1(taskGroupId, request, requestOptions).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<String> updateV1(String taskId) {
        return this.rawClient.updateV1(taskId).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<String> updateV1(String taskId, TaskClientUpdate1 request) {
        return this.rawClient.updateV1(taskId, request).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<String> updateV1(String taskId, TaskClientUpdate1 request, RequestOptions requestOptions) {
        return this.rawClient.updateV1(taskId, request, requestOptions).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<Boolean> completeV1(String taskId) {
        return this.rawClient.completeV1(taskId).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> completeV1(String taskId, RequestOptions requestOptions) {
        return this.rawClient.completeV1(taskId, requestOptions).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> skipV1(String taskId) {
        return this.rawClient.skipV1(taskId).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> skipV1(String taskId, RequestOptions requestOptions) {
        return this.rawClient.skipV1(taskId, requestOptions).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> deleteV1(String taskId) {
        return this.rawClient.deleteV1(taskId).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> deleteV1(String taskId, RequestOptions requestOptions) {
        return this.rawClient.deleteV1(taskId, requestOptions).thenApply(response -> (Boolean)response.body());
    }
}

