/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.tasks.requests;

import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.TaskClientCreate1;
import com.chrt.api.types.TaskStatusEnum1;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class AddTaskToGroupReq {
    private final TaskClientCreate1 task;
    private final TaskStatusEnum1 status;
    private final int index;
    private final Map<String, Object> additionalProperties;

    private AddTaskToGroupReq(TaskClientCreate1 task, TaskStatusEnum1 status, int index, Map<String, Object> additionalProperties) {
        this.task = task;
        this.status = status;
        this.index = index;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="task")
    public TaskClientCreate1 getTask() {
        return this.task;
    }

    @JsonProperty(value="status")
    public TaskStatusEnum1 getStatus() {
        return this.status;
    }

    @JsonProperty(value="index")
    public int getIndex() {
        return this.index;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AddTaskToGroupReq && this.equalTo((AddTaskToGroupReq)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AddTaskToGroupReq other) {
        return this.task.equals(other.task) && this.status.equals(other.status) && this.index == other.index;
    }

    public int hashCode() {
        return Objects.hash(this.task, this.status, this.index);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TaskStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TaskStage,
    StatusStage,
    IndexStage,
    _FinalStage {
        private TaskClientCreate1 task;
        private TaskStatusEnum1 status;
        private int index;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(AddTaskToGroupReq other) {
            this.task(other.getTask());
            this.status(other.getStatus());
            this.index(other.getIndex());
            return this;
        }

        @Override
        @JsonSetter(value="task")
        public StatusStage task(@NotNull TaskClientCreate1 task) {
            this.task = Objects.requireNonNull(task, "task must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="status")
        public IndexStage status(@NotNull TaskStatusEnum1 status) {
            this.status = Objects.requireNonNull(status, "status must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="index")
        public _FinalStage index(int index) {
            this.index = index;
            return this;
        }

        @Override
        public AddTaskToGroupReq build() {
            return new AddTaskToGroupReq(this.task, this.status, this.index, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public AddTaskToGroupReq build();
    }

    public static interface IndexStage {
        public _FinalStage index(int var1);
    }

    public static interface StatusStage {
        public IndexStage status(@NotNull TaskStatusEnum1 var1);
    }

    public static interface TaskStage {
        public StatusStage task(@NotNull TaskClientCreate1 var1);

        public Builder from(AddTaskToGroupReq var1);
    }
}

