/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.tracking.devices.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DevicesGetV1Request {
    private final Optional<String> deviceMacAddress;
    private final Optional<String> deviceId;
    private final Map<String, Object> additionalProperties;

    private DevicesGetV1Request(Optional<String> deviceMacAddress, Optional<String> deviceId, Map<String, Object> additionalProperties) {
        this.deviceMacAddress = deviceMacAddress;
        this.deviceId = deviceId;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getDeviceMacAddress() {
        if (this.deviceMacAddress == null) {
            return Optional.empty();
        }
        return this.deviceMacAddress;
    }

    @JsonIgnore
    public Optional<String> getDeviceId() {
        if (this.deviceId == null) {
            return Optional.empty();
        }
        return this.deviceId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="device_mac_address")
    private Optional<String> _getDeviceMacAddress() {
        return this.deviceMacAddress;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="device_id")
    private Optional<String> _getDeviceId() {
        return this.deviceId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DevicesGetV1Request && this.equalTo((DevicesGetV1Request)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DevicesGetV1Request other) {
        return this.deviceMacAddress.equals(other.deviceMacAddress) && this.deviceId.equals(other.deviceId);
    }

    public int hashCode() {
        return Objects.hash(this.deviceMacAddress, this.deviceId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> deviceMacAddress = Optional.empty();
        private Optional<String> deviceId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(DevicesGetV1Request other) {
            this.deviceMacAddress(other.getDeviceMacAddress());
            this.deviceId(other.getDeviceId());
            return this;
        }

        @JsonSetter(value="device_mac_address", nulls=Nulls.SKIP)
        public Builder deviceMacAddress(Optional<String> deviceMacAddress) {
            this.deviceMacAddress = deviceMacAddress;
            return this;
        }

        public Builder deviceMacAddress(String deviceMacAddress) {
            this.deviceMacAddress = Optional.ofNullable(deviceMacAddress);
            return this;
        }

        public Builder deviceMacAddress(Nullable<String> deviceMacAddress) {
            this.deviceMacAddress = deviceMacAddress.isNull() ? null : (deviceMacAddress.isEmpty() ? Optional.empty() : Optional.of(deviceMacAddress.get()));
            return this;
        }

        @JsonSetter(value="device_id", nulls=Nulls.SKIP)
        public Builder deviceId(Optional<String> deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public Builder deviceId(String deviceId) {
            this.deviceId = Optional.ofNullable(deviceId);
            return this;
        }

        public Builder deviceId(Nullable<String> deviceId) {
            this.deviceId = deviceId.isNull() ? null : (deviceId.isEmpty() ? Optional.empty() : Optional.of(deviceId.get()));
            return this;
        }

        public DevicesGetV1Request build() {
            return new DevicesGetV1Request(this.deviceMacAddress, this.deviceId, this.additionalProperties);
        }
    }
}

