/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.tracking.sessions;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.tracking.sessions.RawSessionsClient;
import com.chrt.api.resources.tracking.sessions.requests.SessionCreateSessionRequest1;
import com.chrt.api.resources.tracking.sessions.requests.SessionUpdateRequest1;
import com.chrt.api.resources.tracking.sessions.requests.SessionsDeleteV1Request;
import com.chrt.api.resources.tracking.sessions.requests.SessionsGetV1Request;
import com.chrt.api.resources.tracking.sessions.requests.SessionsPauseRecordingV1Request;
import com.chrt.api.resources.tracking.sessions.requests.SessionsResumeRecordingV1Request;
import com.chrt.api.resources.tracking.sessions.requests.SessionsStartV1Request;
import com.chrt.api.resources.tracking.sessions.requests.SessionsTerminateV1Request;
import com.chrt.api.types.Session1;
import com.chrt.api.types.SessionDeleteResponse1;
import java.util.List;

public class SessionsClient {
    protected final ClientOptions clientOptions;
    private final RawSessionsClient rawClient;

    public SessionsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawSessionsClient(clientOptions);
    }

    public RawSessionsClient withRawResponse() {
        return this.rawClient;
    }

    public List<Session1> listV1() {
        return this.rawClient.listV1().body();
    }

    public List<Session1> listV1(RequestOptions requestOptions) {
        return this.rawClient.listV1(requestOptions).body();
    }

    public Session1 getV1(SessionsGetV1Request request) {
        return this.rawClient.getV1(request).body();
    }

    public Session1 getV1(SessionsGetV1Request request, RequestOptions requestOptions) {
        return this.rawClient.getV1(request, requestOptions).body();
    }

    public String createSessionV1(SessionCreateSessionRequest1 request) {
        return this.rawClient.createSessionV1(request).body();
    }

    public String createSessionV1(SessionCreateSessionRequest1 request, RequestOptions requestOptions) {
        return this.rawClient.createSessionV1(request, requestOptions).body();
    }

    public boolean updateV1(SessionUpdateRequest1 request) {
        return this.rawClient.updateV1(request).body();
    }

    public boolean updateV1(SessionUpdateRequest1 request, RequestOptions requestOptions) {
        return this.rawClient.updateV1(request, requestOptions).body();
    }

    public boolean startV1(SessionsStartV1Request request) {
        return this.rawClient.startV1(request).body();
    }

    public boolean startV1(SessionsStartV1Request request, RequestOptions requestOptions) {
        return this.rawClient.startV1(request, requestOptions).body();
    }

    public boolean pauseRecordingV1(SessionsPauseRecordingV1Request request) {
        return this.rawClient.pauseRecordingV1(request).body();
    }

    public boolean pauseRecordingV1(SessionsPauseRecordingV1Request request, RequestOptions requestOptions) {
        return this.rawClient.pauseRecordingV1(request, requestOptions).body();
    }

    public boolean resumeRecordingV1(SessionsResumeRecordingV1Request request) {
        return this.rawClient.resumeRecordingV1(request).body();
    }

    public boolean resumeRecordingV1(SessionsResumeRecordingV1Request request, RequestOptions requestOptions) {
        return this.rawClient.resumeRecordingV1(request, requestOptions).body();
    }

    public boolean terminateV1(SessionsTerminateV1Request request) {
        return this.rawClient.terminateV1(request).body();
    }

    public boolean terminateV1(SessionsTerminateV1Request request, RequestOptions requestOptions) {
        return this.rawClient.terminateV1(request, requestOptions).body();
    }

    public SessionDeleteResponse1 deleteV1(SessionsDeleteV1Request request) {
        return this.rawClient.deleteV1(request).body();
    }

    public SessionDeleteResponse1 deleteV1(SessionsDeleteV1Request request, RequestOptions requestOptions) {
        return this.rawClient.deleteV1(request, requestOptions).body();
    }
}

