/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.tracking.sessions.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SessionCreateSessionRequest1 {
    private final String deviceMacAddress;
    private final Optional<String> comments;
    private final Map<String, Object> additionalProperties;

    private SessionCreateSessionRequest1(String deviceMacAddress, Optional<String> comments, Map<String, Object> additionalProperties) {
        this.deviceMacAddress = deviceMacAddress;
        this.comments = comments;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="device_mac_address")
    public String getDeviceMacAddress() {
        return this.deviceMacAddress;
    }

    @JsonIgnore
    public Optional<String> getComments() {
        if (this.comments == null) {
            return Optional.empty();
        }
        return this.comments;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="comments")
    private Optional<String> _getComments() {
        return this.comments;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SessionCreateSessionRequest1 && this.equalTo((SessionCreateSessionRequest1)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SessionCreateSessionRequest1 other) {
        return this.deviceMacAddress.equals(other.deviceMacAddress) && this.comments.equals(other.comments);
    }

    public int hashCode() {
        return Objects.hash(this.deviceMacAddress, this.comments);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static DeviceMacAddressStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements DeviceMacAddressStage,
    _FinalStage {
        private String deviceMacAddress;
        private Optional<String> comments = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(SessionCreateSessionRequest1 other) {
            this.deviceMacAddress(other.getDeviceMacAddress());
            this.comments(other.getComments());
            return this;
        }

        @Override
        @JsonSetter(value="device_mac_address")
        public _FinalStage deviceMacAddress(@NotNull String deviceMacAddress) {
            this.deviceMacAddress = Objects.requireNonNull(deviceMacAddress, "deviceMacAddress must not be null");
            return this;
        }

        @Override
        public _FinalStage comments(Nullable<String> comments) {
            this.comments = comments.isNull() ? null : (comments.isEmpty() ? Optional.empty() : Optional.of(comments.get()));
            return this;
        }

        @Override
        public _FinalStage comments(String comments) {
            this.comments = Optional.ofNullable(comments);
            return this;
        }

        @Override
        @JsonSetter(value="comments", nulls=Nulls.SKIP)
        public _FinalStage comments(Optional<String> comments) {
            this.comments = comments;
            return this;
        }

        @Override
        public SessionCreateSessionRequest1 build() {
            return new SessionCreateSessionRequest1(this.deviceMacAddress, this.comments, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public SessionCreateSessionRequest1 build();

        public _FinalStage comments(Optional<String> var1);

        public _FinalStage comments(String var1);

        public _FinalStage comments(Nullable<String> var1);
    }

    public static interface DeviceMacAddressStage {
        public _FinalStage deviceMacAddress(@NotNull String var1);

        public Builder from(SessionCreateSessionRequest1 var1);
    }
}

