/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.tracking.sharingsettings;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.tracking.sharingsettings.AsyncRawSharingSettingsClient;
import com.chrt.api.resources.tracking.sharingsettings.requests.CargoByDeviceSharingSettingsUpdateReq;
import com.chrt.api.resources.tracking.sharingsettings.requests.CargoByDriverSharingSettingsUpdateReq;
import com.chrt.api.resources.tracking.sharingsettings.requests.TaskGroupByDriverSharingSettingsUpdateReq;
import com.chrt.api.types.CargoByDeviceSharingSettings1;
import com.chrt.api.types.CargoByDriverSharingSettings1;
import com.chrt.api.types.TaskGroupByDriverSharingSettings1;
import com.chrt.api.types.TrackingSharingSettingsRes;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class AsyncSharingSettingsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawSharingSettingsClient rawClient;

    public AsyncSharingSettingsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawSharingSettingsClient(clientOptions);
    }

    public AsyncRawSharingSettingsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<TaskGroupByDriverSharingSettings1> taskGroupByDriverSharingSettingsV1(TaskGroupByDriverSharingSettingsUpdateReq request) {
        return this.rawClient.taskGroupByDriverSharingSettingsV1(request).thenApply(response -> (TaskGroupByDriverSharingSettings1)response.body());
    }

    public CompletableFuture<TaskGroupByDriverSharingSettings1> taskGroupByDriverSharingSettingsV1(TaskGroupByDriverSharingSettingsUpdateReq request, RequestOptions requestOptions) {
        return this.rawClient.taskGroupByDriverSharingSettingsV1(request, requestOptions).thenApply(response -> (TaskGroupByDriverSharingSettings1)response.body());
    }

    public CompletableFuture<CargoByDriverSharingSettings1> cargoByDriverSettingsV1(CargoByDriverSharingSettingsUpdateReq request) {
        return this.rawClient.cargoByDriverSettingsV1(request).thenApply(response -> (CargoByDriverSharingSettings1)response.body());
    }

    public CompletableFuture<CargoByDriverSharingSettings1> cargoByDriverSettingsV1(CargoByDriverSharingSettingsUpdateReq request, RequestOptions requestOptions) {
        return this.rawClient.cargoByDriverSettingsV1(request, requestOptions).thenApply(response -> (CargoByDriverSharingSettings1)response.body());
    }

    public CompletableFuture<CargoByDeviceSharingSettings1> cargoByDeviceSettingsV1(CargoByDeviceSharingSettingsUpdateReq request) {
        return this.rawClient.cargoByDeviceSettingsV1(request).thenApply(response -> (CargoByDeviceSharingSettings1)response.body());
    }

    public CompletableFuture<CargoByDeviceSharingSettings1> cargoByDeviceSettingsV1(CargoByDeviceSharingSettingsUpdateReq request, RequestOptions requestOptions) {
        return this.rawClient.cargoByDeviceSettingsV1(request, requestOptions).thenApply(response -> (CargoByDeviceSharingSettings1)response.body());
    }

    public CompletableFuture<List<TrackingSharingSettingsRes>> getSettingsV1(String orderIdOrShortId) {
        return this.rawClient.getSettingsV1(orderIdOrShortId).thenApply(response -> (List)response.body());
    }

    public CompletableFuture<List<TrackingSharingSettingsRes>> getSettingsV1(String orderIdOrShortId, RequestOptions requestOptions) {
        return this.rawClient.getSettingsV1(orderIdOrShortId, requestOptions).thenApply(response -> (List)response.body());
    }
}

