/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.tracking.sharingsettings;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.tracking.sharingsettings.RawSharingSettingsClient;
import com.chrt.api.resources.tracking.sharingsettings.requests.CargoByDeviceSharingSettingsUpdateReq;
import com.chrt.api.resources.tracking.sharingsettings.requests.CargoByDriverSharingSettingsUpdateReq;
import com.chrt.api.resources.tracking.sharingsettings.requests.TaskGroupByDriverSharingSettingsUpdateReq;
import com.chrt.api.types.CargoByDeviceSharingSettings1;
import com.chrt.api.types.CargoByDriverSharingSettings1;
import com.chrt.api.types.TaskGroupByDriverSharingSettings1;
import com.chrt.api.types.TrackingSharingSettingsRes;
import java.util.List;

public class SharingSettingsClient {
    protected final ClientOptions clientOptions;
    private final RawSharingSettingsClient rawClient;

    public SharingSettingsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawSharingSettingsClient(clientOptions);
    }

    public RawSharingSettingsClient withRawResponse() {
        return this.rawClient;
    }

    public TaskGroupByDriverSharingSettings1 taskGroupByDriverSharingSettingsV1(TaskGroupByDriverSharingSettingsUpdateReq request) {
        return this.rawClient.taskGroupByDriverSharingSettingsV1(request).body();
    }

    public TaskGroupByDriverSharingSettings1 taskGroupByDriverSharingSettingsV1(TaskGroupByDriverSharingSettingsUpdateReq request, RequestOptions requestOptions) {
        return this.rawClient.taskGroupByDriverSharingSettingsV1(request, requestOptions).body();
    }

    public CargoByDriverSharingSettings1 cargoByDriverSettingsV1(CargoByDriverSharingSettingsUpdateReq request) {
        return this.rawClient.cargoByDriverSettingsV1(request).body();
    }

    public CargoByDriverSharingSettings1 cargoByDriverSettingsV1(CargoByDriverSharingSettingsUpdateReq request, RequestOptions requestOptions) {
        return this.rawClient.cargoByDriverSettingsV1(request, requestOptions).body();
    }

    public CargoByDeviceSharingSettings1 cargoByDeviceSettingsV1(CargoByDeviceSharingSettingsUpdateReq request) {
        return this.rawClient.cargoByDeviceSettingsV1(request).body();
    }

    public CargoByDeviceSharingSettings1 cargoByDeviceSettingsV1(CargoByDeviceSharingSettingsUpdateReq request, RequestOptions requestOptions) {
        return this.rawClient.cargoByDeviceSettingsV1(request, requestOptions).body();
    }

    public List<TrackingSharingSettingsRes> getSettingsV1(String orderIdOrShortId) {
        return this.rawClient.getSettingsV1(orderIdOrShortId).body();
    }

    public List<TrackingSharingSettingsRes> getSettingsV1(String orderIdOrShortId, RequestOptions requestOptions) {
        return this.rawClient.getSettingsV1(orderIdOrShortId, requestOptions).body();
    }
}

