/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.tracking.timeseries;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.Suppliers;
import com.chrt.api.resources.tracking.timeseries.cargobydevice.CargoByDeviceClient;
import com.chrt.api.resources.tracking.timeseries.cargobydriver.CargoByDriverClient;
import com.chrt.api.resources.tracking.timeseries.sessionbydevice.SessionByDeviceClient;
import com.chrt.api.resources.tracking.timeseries.taskgroupbydriver.TaskGroupByDriverClient;
import java.util.function.Supplier;

public class TimeseriesClient {
    protected final ClientOptions clientOptions;
    protected final Supplier<CargoByDeviceClient> cargoByDeviceClient;
    protected final Supplier<CargoByDriverClient> cargoByDriverClient;
    protected final Supplier<SessionByDeviceClient> sessionByDeviceClient;
    protected final Supplier<TaskGroupByDriverClient> taskGroupByDriverClient;

    public TimeseriesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.cargoByDeviceClient = Suppliers.memoize(() -> new CargoByDeviceClient(clientOptions));
        this.cargoByDriverClient = Suppliers.memoize(() -> new CargoByDriverClient(clientOptions));
        this.sessionByDeviceClient = Suppliers.memoize(() -> new SessionByDeviceClient(clientOptions));
        this.taskGroupByDriverClient = Suppliers.memoize(() -> new TaskGroupByDriverClient(clientOptions));
    }

    public CargoByDeviceClient cargoByDevice() {
        return this.cargoByDeviceClient.get();
    }

    public CargoByDriverClient cargoByDriver() {
        return this.cargoByDriverClient.get();
    }

    public SessionByDeviceClient sessionByDevice() {
        return this.sessionByDeviceClient.get();
    }

    public TaskGroupByDriverClient taskGroupByDriver() {
        return this.taskGroupByDriverClient.get();
    }
}

