/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.tracking.timeseries.cargobydevice;

import com.chrt.api.core.ChrtApiApiException;
import com.chrt.api.core.ChrtApiException;
import com.chrt.api.core.ChrtApiHttpResponse;
import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.MediaTypes;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.core.QueryStringMapper;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.errors.UnprocessableEntityError;
import com.chrt.api.resources.tracking.timeseries.cargobydevice.requests.CargoByDeviceDataPointsPublicV1Request;
import com.chrt.api.resources.tracking.timeseries.cargobydevice.requests.CargoByDeviceDataPointsV1Request;
import com.chrt.api.resources.tracking.timeseries.cargobydevice.requests.CargoByDeviceLastSeenPublicV1Request;
import com.chrt.api.resources.tracking.timeseries.cargobydevice.requests.CargoByDeviceLastSeenV1Request;
import com.chrt.api.resources.tracking.timeseries.cargobydevice.requests.CargoByDeviceMarkOutliersRequest1;
import com.chrt.api.types.CargoByDeviceDataPoint1;
import com.chrt.api.types.CargoByDeviceMarkOutliersResponse1;
import com.chrt.api.types.HttpValidationError;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

public class AsyncRawCargoByDeviceClient {
    protected final ClientOptions clientOptions;

    public AsyncRawCargoByDeviceClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public CompletableFuture<ChrtApiHttpResponse<Optional<CargoByDeviceDataPoint1>>> lastSeenV1(CargoByDeviceLastSeenV1Request request) {
        return this.lastSeenV1(request, null);
    }

    public CompletableFuture<ChrtApiHttpResponse<Optional<CargoByDeviceDataPoint1>>> lastSeenV1(CargoByDeviceLastSeenV1Request request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("tracking/timeseries/cargo_by_device/last_seen/v1");
        QueryStringMapper.addQueryParameter(httpUrl, "cargo_id", request.getCargoId(), false);
        QueryStringMapper.addQueryParameter(httpUrl, "task_group_id", request.getTaskGroupId(), false);
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<ChrtApiHttpResponse<Optional<CargoByDeviceDataPoint1>>> future = new CompletableFuture<ChrtApiHttpResponse<Optional<CargoByDeviceDataPoint1>>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            /*
             * Loose catch block
             */
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try {
                    String responseBodyString;
                    ResponseBody responseBody;
                    block13: {
                        block14: {
                            block11: {
                                block12: {
                                    responseBody = response.body();
                                    String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
                                    if (!response.isSuccessful()) break block11;
                                    future.complete(new ChrtApiHttpResponse<Optional>((Optional)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, (TypeReference)new TypeReference<Optional<CargoByDeviceDataPoint1>>(){}), response));
                                    if (responseBody == null) break block12;
                                    responseBody.close();
                                }
                                return;
                            }
                            if (response.code() != 422) break block13;
                            future.completeExceptionally(new UnprocessableEntityError((HttpValidationError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class), response));
                            if (responseBody == null) break block14;
                            responseBody.close();
                        }
                        return;
                    }
                    try {
                        block15: {
                            break block15;
                            catch (JsonProcessingException jsonProcessingException) {
                                // empty catch block
                            }
                        }
                        future.completeExceptionally(new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                        return;
                    }
                    finally {
                        if (responseBody != null) {
                            responseBody.close();
                        }
                    }
                }
                catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<ChrtApiHttpResponse<List<CargoByDeviceDataPoint1>>> dataPointsV1(CargoByDeviceDataPointsV1Request request) {
        return this.dataPointsV1(request, null);
    }

    public CompletableFuture<ChrtApiHttpResponse<List<CargoByDeviceDataPoint1>>> dataPointsV1(CargoByDeviceDataPointsV1Request request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("tracking/timeseries/cargo_by_device/data_points/v1");
        QueryStringMapper.addQueryParameter(httpUrl, "cargo_id", request.getCargoId(), false);
        QueryStringMapper.addQueryParameter(httpUrl, "task_group_id", request.getTaskGroupId(), false);
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<ChrtApiHttpResponse<List<CargoByDeviceDataPoint1>>> future = new CompletableFuture<ChrtApiHttpResponse<List<CargoByDeviceDataPoint1>>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            /*
             * Loose catch block
             */
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try {
                    String responseBodyString;
                    ResponseBody responseBody;
                    block13: {
                        block14: {
                            block11: {
                                block12: {
                                    responseBody = response.body();
                                    String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
                                    if (!response.isSuccessful()) break block11;
                                    future.complete(new ChrtApiHttpResponse<List>((List)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, (TypeReference)new TypeReference<List<CargoByDeviceDataPoint1>>(){}), response));
                                    if (responseBody == null) break block12;
                                    responseBody.close();
                                }
                                return;
                            }
                            if (response.code() != 422) break block13;
                            future.completeExceptionally(new UnprocessableEntityError((HttpValidationError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class), response));
                            if (responseBody == null) break block14;
                            responseBody.close();
                        }
                        return;
                    }
                    try {
                        block15: {
                            break block15;
                            catch (JsonProcessingException jsonProcessingException) {
                                // empty catch block
                            }
                        }
                        future.completeExceptionally(new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                        return;
                    }
                    finally {
                        if (responseBody != null) {
                            responseBody.close();
                        }
                    }
                }
                catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<ChrtApiHttpResponse<CargoByDeviceMarkOutliersResponse1>> outlierV1(CargoByDeviceMarkOutliersRequest1 request) {
        return this.outlierV1(request, null);
    }

    public CompletableFuture<ChrtApiHttpResponse<CargoByDeviceMarkOutliersResponse1>> outlierV1(CargoByDeviceMarkOutliersRequest1 request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("tracking/timeseries/cargo_by_device/outlier/v1").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new ChrtApiException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<ChrtApiHttpResponse<CargoByDeviceMarkOutliersResponse1>> future = new CompletableFuture<ChrtApiHttpResponse<CargoByDeviceMarkOutliersResponse1>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            /*
             * Loose catch block
             */
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try {
                    String responseBodyString;
                    ResponseBody responseBody;
                    block13: {
                        block14: {
                            block11: {
                                block12: {
                                    responseBody = response.body();
                                    String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
                                    if (!response.isSuccessful()) break block11;
                                    future.complete(new ChrtApiHttpResponse<CargoByDeviceMarkOutliersResponse1>((CargoByDeviceMarkOutliersResponse1)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, CargoByDeviceMarkOutliersResponse1.class), response));
                                    if (responseBody == null) break block12;
                                    responseBody.close();
                                }
                                return;
                            }
                            if (response.code() != 422) break block13;
                            future.completeExceptionally(new UnprocessableEntityError((HttpValidationError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class), response));
                            if (responseBody == null) break block14;
                            responseBody.close();
                        }
                        return;
                    }
                    try {
                        block15: {
                            break block15;
                            catch (JsonProcessingException jsonProcessingException) {
                                // empty catch block
                            }
                        }
                        future.completeExceptionally(new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                        return;
                    }
                    finally {
                        if (responseBody != null) {
                            responseBody.close();
                        }
                    }
                }
                catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<ChrtApiHttpResponse<Optional<CargoByDeviceDataPoint1>>> lastSeenPublicV1(CargoByDeviceLastSeenPublicV1Request request) {
        return this.lastSeenPublicV1(request, null);
    }

    public CompletableFuture<ChrtApiHttpResponse<Optional<CargoByDeviceDataPoint1>>> lastSeenPublicV1(CargoByDeviceLastSeenPublicV1Request request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("tracking/timeseries/cargo_by_device/last_seen_public/v1");
        QueryStringMapper.addQueryParameter(httpUrl, "cargo_id", request.getCargoId(), false);
        QueryStringMapper.addQueryParameter(httpUrl, "task_group_id", request.getTaskGroupId(), false);
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<ChrtApiHttpResponse<Optional<CargoByDeviceDataPoint1>>> future = new CompletableFuture<ChrtApiHttpResponse<Optional<CargoByDeviceDataPoint1>>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            /*
             * Loose catch block
             */
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try {
                    String responseBodyString;
                    ResponseBody responseBody;
                    block13: {
                        block14: {
                            block11: {
                                block12: {
                                    responseBody = response.body();
                                    String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
                                    if (!response.isSuccessful()) break block11;
                                    future.complete(new ChrtApiHttpResponse<Optional>((Optional)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, (TypeReference)new TypeReference<Optional<CargoByDeviceDataPoint1>>(){}), response));
                                    if (responseBody == null) break block12;
                                    responseBody.close();
                                }
                                return;
                            }
                            if (response.code() != 422) break block13;
                            future.completeExceptionally(new UnprocessableEntityError((HttpValidationError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class), response));
                            if (responseBody == null) break block14;
                            responseBody.close();
                        }
                        return;
                    }
                    try {
                        block15: {
                            break block15;
                            catch (JsonProcessingException jsonProcessingException) {
                                // empty catch block
                            }
                        }
                        future.completeExceptionally(new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                        return;
                    }
                    finally {
                        if (responseBody != null) {
                            responseBody.close();
                        }
                    }
                }
                catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<ChrtApiHttpResponse<List<CargoByDeviceDataPoint1>>> dataPointsPublicV1(CargoByDeviceDataPointsPublicV1Request request) {
        return this.dataPointsPublicV1(request, null);
    }

    public CompletableFuture<ChrtApiHttpResponse<List<CargoByDeviceDataPoint1>>> dataPointsPublicV1(CargoByDeviceDataPointsPublicV1Request request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("tracking/timeseries/cargo_by_device/data_points_public/v1");
        QueryStringMapper.addQueryParameter(httpUrl, "cargo_id", request.getCargoId(), false);
        QueryStringMapper.addQueryParameter(httpUrl, "task_group_id", request.getTaskGroupId(), false);
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<ChrtApiHttpResponse<List<CargoByDeviceDataPoint1>>> future = new CompletableFuture<ChrtApiHttpResponse<List<CargoByDeviceDataPoint1>>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            /*
             * Loose catch block
             */
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try {
                    String responseBodyString;
                    ResponseBody responseBody;
                    block13: {
                        block14: {
                            block11: {
                                block12: {
                                    responseBody = response.body();
                                    String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
                                    if (!response.isSuccessful()) break block11;
                                    future.complete(new ChrtApiHttpResponse<List>((List)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, (TypeReference)new TypeReference<List<CargoByDeviceDataPoint1>>(){}), response));
                                    if (responseBody == null) break block12;
                                    responseBody.close();
                                }
                                return;
                            }
                            if (response.code() != 422) break block13;
                            future.completeExceptionally(new UnprocessableEntityError((HttpValidationError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class), response));
                            if (responseBody == null) break block14;
                            responseBody.close();
                        }
                        return;
                    }
                    try {
                        block15: {
                            break block15;
                            catch (JsonProcessingException jsonProcessingException) {
                                // empty catch block
                            }
                        }
                        future.completeExceptionally(new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                        return;
                    }
                    finally {
                        if (responseBody != null) {
                            responseBody.close();
                        }
                    }
                }
                catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }
}

