/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.tracking.timeseries.cargobydevice.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CargoByDeviceDataPointsV1Request {
    private final String cargoId;
    private final String taskGroupId;
    private final Optional<Integer> limit;
    private final Map<String, Object> additionalProperties;

    private CargoByDeviceDataPointsV1Request(String cargoId, String taskGroupId, Optional<Integer> limit, Map<String, Object> additionalProperties) {
        this.cargoId = cargoId;
        this.taskGroupId = taskGroupId;
        this.limit = limit;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="cargo_id")
    public String getCargoId() {
        return this.cargoId;
    }

    @JsonProperty(value="task_group_id")
    public String getTaskGroupId() {
        return this.taskGroupId;
    }

    @JsonIgnore
    public Optional<Integer> getLimit() {
        if (this.limit == null) {
            return Optional.empty();
        }
        return this.limit;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="limit")
    private Optional<Integer> _getLimit() {
        return this.limit;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CargoByDeviceDataPointsV1Request && this.equalTo((CargoByDeviceDataPointsV1Request)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CargoByDeviceDataPointsV1Request other) {
        return this.cargoId.equals(other.cargoId) && this.taskGroupId.equals(other.taskGroupId) && this.limit.equals(other.limit);
    }

    public int hashCode() {
        return Objects.hash(this.cargoId, this.taskGroupId, this.limit);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CargoIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CargoIdStage,
    TaskGroupIdStage,
    _FinalStage {
        private String cargoId;
        private String taskGroupId;
        private Optional<Integer> limit = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CargoByDeviceDataPointsV1Request other) {
            this.cargoId(other.getCargoId());
            this.taskGroupId(other.getTaskGroupId());
            this.limit(other.getLimit());
            return this;
        }

        @Override
        @JsonSetter(value="cargo_id")
        public TaskGroupIdStage cargoId(@NotNull String cargoId) {
            this.cargoId = Objects.requireNonNull(cargoId, "cargoId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="task_group_id")
        public _FinalStage taskGroupId(@NotNull String taskGroupId) {
            this.taskGroupId = Objects.requireNonNull(taskGroupId, "taskGroupId must not be null");
            return this;
        }

        @Override
        public _FinalStage limit(Nullable<Integer> limit) {
            this.limit = limit.isNull() ? null : (limit.isEmpty() ? Optional.empty() : Optional.of(limit.get()));
            return this;
        }

        @Override
        public _FinalStage limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @Override
        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public _FinalStage limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public CargoByDeviceDataPointsV1Request build() {
            return new CargoByDeviceDataPointsV1Request(this.cargoId, this.taskGroupId, this.limit, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CargoByDeviceDataPointsV1Request build();

        public _FinalStage limit(Optional<Integer> var1);

        public _FinalStage limit(Integer var1);

        public _FinalStage limit(Nullable<Integer> var1);
    }

    public static interface TaskGroupIdStage {
        public _FinalStage taskGroupId(@NotNull String var1);
    }

    public static interface CargoIdStage {
        public TaskGroupIdStage cargoId(@NotNull String var1);

        public Builder from(CargoByDeviceDataPointsV1Request var1);
    }
}

